/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.lang;

import java.util.Locale;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class SystemUtils {
    public static final String OS_NAME_KEY = "os.name";
    public static final String OS_ARCH_KEY = "os.arch";
    public static final String OS_VERSION_KEY = "os.version";
    public static final String FILE_SEPARATOR_KEY = "file.separator";
    public static final String PATH_SEPARATOR_KEY = "path.separator";
    public static final String LINE_SEPARATOR_KEY = "line.separator";
    public static final String USER_NAME_KEY = "user.name";
    public static final String USER_HOME_KEY = "user.home";
    public static final byte OS_WIN = 1;
    public static final byte OS_MAC = 2;
    public static final String ARCH_X86_64 = "x86_64";
    public static final String ARCH_X86_32 = "x86_32";
    public static final String ARCH_ARM_64 = "arm_64";
    private static final byte LOCAL_OS = SystemUtils.getOs(ObjectUtils.nonNullAssert(System.getProperty("os.name")));
    private static final String LOCAL_ARCH = ObjectUtils.nonNullElse(SystemUtils.getArch(ObjectUtils.nonNullAssert(System.getProperty("os.arch"))), "other");
    private static final String LOCAL_USER_NAME = ObjectUtils.nonNullAssert(System.getProperty("user.name"));

    public static byte getLocalOs() {
        return LOCAL_OS;
    }

    public static String getLocalArch() {
        return LOCAL_ARCH;
    }

    public static byte getOs(String osName) {
        if ((osName = osName.toLowerCase(Locale.ROOT)).startsWith("windows", 0)) {
            return 1;
        }
        if (osName.startsWith("mac os", 0)) {
            return 2;
        }
        return 0;
    }

    public static @Nullable String getArch(String osArch) {
        switch (osArch = osArch.toLowerCase(Locale.ROOT)) {
            case "x86_64": 
            case "x64": 
            case "amd64": {
                return ARCH_X86_64;
            }
            case "x86_32": 
            case "x86": 
            case "i386": 
            case "i486": 
            case "i586": 
            case "i686": {
                return ARCH_X86_32;
            }
            case "aarch64": {
                return ARCH_ARM_64;
            }
        }
        return null;
    }

    public static String getLocalUserName() {
        return LOCAL_USER_NAME;
    }
}

