/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.io;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.statet.internal.jcommons.io.AbstractNestedArchiveUriUrl;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public final class NestedJarBoot2UriUrl
extends AbstractNestedArchiveUriUrl {
    private final int nestSepIndex;
    private final int jarSepIndex;

    public NestedJarBoot2UriUrl(URI uri, int nestSepIndex, int jarSepIndex) throws URISyntaxException {
        super(uri);
        this.nestSepIndex = nestSepIndex;
        this.jarSepIndex = jarSepIndex;
    }

    @Override
    public String getOuterArchiveType() {
        return "jar";
    }

    @Override
    protected URI createOuterArchiveUrl(URI url) throws URISyntaxException {
        String ssp = url.getSchemeSpecificPart();
        return new URI("file", ssp.substring(5, this.nestSepIndex), url.getFragment());
    }

    @Override
    public String getInnerArchiveType() {
        return "jar";
    }

    @Override
    protected URI createInnerArchiveUrl(URI url) throws URISyntaxException {
        String ssp = url.getSchemeSpecificPart();
        return new URI("jar", ssp.substring(0, this.jarSepIndex), null);
    }

    @Override
    protected String createEntryPath(URI url) {
        String ssp = url.getSchemeSpecificPart();
        return ssp.substring(this.jarSepIndex + 2, ssp.length());
    }
}

