/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.ui.matcher;

import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.core.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.ui.matcher.IMouseEventMatcher;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.events.MouseEvent;

public class MouseEventMatcher
implements IMouseEventMatcher {
    public static final int WILDCARD_MASK = 1;
    private final int stateMask;
    private final String regionName;
    private final String regionName2;
    private final int button;

    public MouseEventMatcher() {
        this(0, null, 0);
    }

    public MouseEventMatcher(String eventRegionName) {
        this(0, eventRegionName, 0);
    }

    public MouseEventMatcher(String eventRegion, int button) {
        this(0, eventRegion, button);
    }

    public MouseEventMatcher(int stateMask, String eventRegion) {
        this(stateMask, eventRegion, 0);
    }

    public MouseEventMatcher(int stateMask, String eventRegion, int button) {
        this(stateMask, eventRegion, null, button);
    }

    public MouseEventMatcher(int stateMask, String eventRegion1, String eventRegion2, int button) {
        this.stateMask = stateMask;
        this.regionName = eventRegion1;
        this.regionName2 = eventRegion2;
        this.button = button;
    }

    public int getStateMask() {
        return this.stateMask;
    }

    public String getEventRegion() {
        return this.regionName;
    }

    public int getButton() {
        return this.button;
    }

    @Override
    public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
        return ((this.stateMask & 1) == 1 ? (event.stateMask | this.stateMask) == this.stateMask : event.stateMask == this.stateMask) && event.button == this.button && (this.regionName == null || regionLabels != null && (regionLabels.hasLabel(this.regionName) || this.regionName2 != null && regionLabels.hasLabel(this.regionName2)));
    }

    public int hashCode() {
        return (this.stateMask + (this.regionName != null ? this.regionName.hashCode() : -1) * 13) * this.button;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MouseEventMatcher)) {
            return false;
        }
        MouseEventMatcher other = (MouseEventMatcher)obj;
        return this.stateMask == other.stateMask && this.button == other.button && (this.regionName != null ? this.regionName.equals(other.regionName) : other.regionName == null) && (this.regionName2 != null ? this.regionName2.equals(other.regionName) : other.regionName == null);
    }

    public static MouseEventMatcher columnHeaderLeftClick(int mask) {
        return new MouseEventMatcher(mask, "COLUMN_HEADER", 1);
    }

    public static MouseEventMatcher columnHeaderRightClick(int mask) {
        return new MouseEventMatcher(mask, "COLUMN_HEADER", 3);
    }

    public static MouseEventMatcher rowHeaderLeftClick(int mask) {
        return new MouseEventMatcher(mask, "ROW_HEADER", 1);
    }

    public static MouseEventMatcher rowHeaderRightClick(int mask) {
        return new MouseEventMatcher(mask, "ROW_HEADER", 3);
    }

    public static MouseEventMatcher bodyLeftClick(int mask) {
        return new MouseEventMatcher(mask, "BODY", 1);
    }

    public static MouseEventMatcher bodyRightClick(int mask) {
        return new MouseEventMatcher(mask, "BODY", 3);
    }
}

