/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.core.treepartitioner;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.statet.ecommons.text.core.treepartitioner.NodePosition;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNode;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeScan;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeType;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitioner;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
final class TreePartitionerScan
implements TreePartitionNodeScan {
    private static final int END_FLAGS = 256;
    private final TreePartitioner partitioner;
    private int startOffset;
    private int endOffset;
    private NodePosition beginPosition;
    private NodePosition lastParentPosition;
    private int lastAddedIndex;
    private @Nullable NodePosition lastAddedPosition;
    private int currentOffset;
    private int dirtyStartOffset;
    private int dirtyEndOffset;
    private int stamp;
    private int equalTypeEndOffset;
    private boolean autoBreakEnabled;

    public TreePartitionerScan(TreePartitioner partitioner) {
        this.partitioner = partitioner;
    }

    void init(int startOffset, int endOffset, NodePosition beginPosition) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.beginPosition = beginPosition;
        this.lastParentPosition = beginPosition;
        int childIdx = beginPosition.indexOfChild(startOffset);
        if (childIdx < 0) {
            childIdx ^= 0xFFFFFFFF;
        }
        this.lastAddedIndex = childIdx - 1;
        this.currentOffset = startOffset;
        this.dirtyStartOffset = Integer.MAX_VALUE;
        this.dirtyEndOffset = -1;
        ++this.stamp;
        this.equalTypeEndOffset = Integer.MIN_VALUE;
        this.autoBreakEnabled = true;
    }

    void addBeginPosition(TreePartitionNodeType type) {
        this.beginPosition = this.doAdd(type, this.beginPosition, this.startOffset, 0);
    }

    @Override
    public IDocument getDocument() {
        return this.partitioner.document;
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public TreePartitionNode getBeginNode() {
        return this.beginPosition;
    }

    @Override
    public void setAutoBreakEnabled(boolean enable) {
        this.autoBreakEnabled = enable;
    }

    @Override
    public boolean isAutoBreakEnabled() {
        return this.autoBreakEnabled;
    }

    @Override
    public NodePosition add(TreePartitionNodeType type, TreePartitionNode parent, int offset, int flags) {
        NodePosition position = this.doAdd(type, (NodePosition)parent, offset, 0);
        position.flags = position.flags & 0x100 | flags;
        if (TreePartitioner.DEBUG) {
            this.partitioner.check(false);
        }
        if (this.autoBreakEnabled) {
            this.checkBreak();
        }
        return position;
    }

    private NodePosition doAdd(TreePartitionNodeType type, NodePosition parentPosition, int offset, int length) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (parentPosition == null) {
            throw new NullPointerException("parent");
        }
        if (offset < parentPosition.getOffset()) {
            throw new IllegalArgumentException("offset: offset < parent.offset");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length: length < 0");
        }
        NodePosition position = null;
        int endOffset = offset + length;
        if (offset >= this.currentOffset) {
            int childIdx = this.cleanUpTo(parentPosition);
            position = this.findReuse(parentPosition.children, childIdx, type, offset);
            if (position != null && length <= position.getLength()) {
                int firstOffset;
                int end = endOffset;
                if (!position.children.isEmpty() && (firstOffset = position.children.getFirst().getOffset()) < end) {
                    end = firstOffset;
                }
                this.equalTypeEndOffset = end;
            }
            this.doDeleteChildren(parentPosition, childIdx, endOffset, position);
            if (parentPosition.getEndOffset() < endOffset) {
                this.doUpdateEnd(parentPosition, endOffset);
            }
            if (position == null) {
                position = this.createPosition(parentPosition, offset, length, childIdx, type);
            }
            this.lastParentPosition = parentPosition;
            this.lastAddedIndex = childIdx;
            this.lastAddedPosition = position;
            this.currentOffset = offset;
        } else {
            if (offset < parentPosition.offset || endOffset >= parentPosition.getEndOffset()) {
                throw new IllegalArgumentException("node not inside parent");
            }
            int childIdx = parentPosition.indexOfChild(offset);
            if (childIdx < 0) {
                childIdx ^= 0xFFFFFFFF;
            }
            while (childIdx < parentPosition.children.size()) {
                NodePosition child = parentPosition.children.get(childIdx);
                if (child.getOffset() == offset && child.getLength() == 0) {
                    ++childIdx;
                    continue;
                }
                if (child.getOffset() > offset) break;
                throw new IllegalArgumentException("node overlaps with existing node");
            }
            position = this.createPosition(parentPosition, offset, length, childIdx, type);
            this.lastParentPosition = parentPosition;
            this.lastAddedIndex = childIdx;
            this.lastAddedPosition = position;
            this.currentOffset = offset;
        }
        return position;
    }

    private int cleanUpTo(NodePosition parentPosition) {
        int childIdx;
        if (parentPosition == this.lastParentPosition) {
            childIdx = this.lastAddedIndex + 1;
        } else if (parentPosition == this.lastAddedPosition) {
            childIdx = 0;
        } else {
            childIdx = this.lastAddedIndex + 1;
            NodePosition p = this.lastParentPosition;
            do {
                this.doDeleteChildren(p, childIdx, Integer.MAX_VALUE, null);
                childIdx = p.parent.indexOfChild(p) + 1;
            } while (parentPosition != (p = p.parent));
        }
        return childIdx;
    }

    private NodePosition createPosition(NodePosition parentPosition, int offset, int length, int childIdx, TreePartitionNodeType type) {
        this.markDirtyRegion(offset, length);
        NodePosition.CommonNode position = new NodePosition.CommonNode(parentPosition, offset, length, type, this.stamp);
        parentPosition.insertChild(childIdx, position);
        try {
            this.partitioner.addPosition(position);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        return position;
    }

    private NodePosition findReuse(List<NodePosition> children, int childIdx, TreePartitionNodeType type, int offset) {
        while (childIdx < children.size()) {
            NodePosition child = children.get(childIdx);
            if (child.getOffset() == offset && type.equals(child.type)) {
                child.type = type;
                return child;
            }
            if (child.getOffset() > offset) break;
            ++childIdx;
        }
        return null;
    }

    @Override
    public void expand(TreePartitionNode node, int offset, int flags, boolean close) {
        NodePosition position = (NodePosition)node;
        if (position == null) {
            throw new IllegalArgumentException("node");
        }
        int length = offset - position.getOffset();
        if (length < 0) {
            throw new IllegalArgumentException("offset: offset < node.offset");
        }
        if (offset >= this.currentOffset) {
            int childIdx = this.cleanUpTo(position);
            this.doDeleteChildren(position, childIdx, close ? Integer.MAX_VALUE : offset, null);
            this.lastParentPosition = position;
            this.lastAddedIndex = childIdx - 1;
            this.lastAddedPosition = childIdx > 0 ? position.children.get(childIdx - 1) : null;
            this.currentOffset = offset;
        } else {
            List<NodePosition> children = position.children;
            if (!children.isEmpty() && children.getLast().getEndOffset() > offset) {
                throw new IllegalArgumentException("offset: offset < endOffset of children");
            }
        }
        if (close ? position.getLength() == length : position.getLength() >= length) {
            if (position.stamp != this.stamp && offset > this.equalTypeEndOffset) {
                this.equalTypeEndOffset = offset;
            }
        } else {
            this.doUpdateEnd(position, offset);
        }
        int n = position.flags = close ? position.flags & 0xFFFFFEFF | flags : position.flags | flags;
        if (TreePartitioner.DEBUG) {
            this.partitioner.check(false);
        }
        if (this.autoBreakEnabled) {
            this.checkBreak();
        }
    }

    private void doUpdateEnd(NodePosition position, int endOffset) {
        this.markDirtyEnd(Math.max(endOffset, position.getEndOffset()));
        position.setLength(endOffset - position.getOffset());
        position.stamp = this.stamp;
        while (position.parent != null) {
            int parentLength = position.parent.getLength();
            int parentOffset = position.parent.getOffset();
            this.doDeleteChildren(position.parent, position.parent.indexOfChild(position), endOffset, position);
            if (parentOffset + parentLength >= endOffset) {
                return;
            }
            position.parent.setLength(endOffset - parentOffset);
            position.parent.stamp = this.stamp;
            position = position.parent;
        }
    }

    private void doDeleteChildren(NodePosition parentPosition, int childIdx, int endOffset, @Nullable NodePosition keepPosition) {
        List<NodePosition> children = parentPosition.children;
        while (childIdx < children.size()) {
            NodePosition child = children.get(childIdx);
            if (child == keepPosition) {
                ++childIdx;
                continue;
            }
            if (child.getOffset() >= endOffset && (child.getOffset() != endOffset || child.getLength() != 0)) break;
            this.markDirtyRegion(child.getOffset(), child.getLength());
            children.remove(childIdx);
            try {
                this.doDelete(child);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                // empty catch block
            }
        }
    }

    private void doDelete(NodePosition position) throws BadPositionCategoryException {
        if (position.parent != null) {
            position.parent = null;
            position.isDeleted = true;
            this.partitioner.removePosition(position);
            List<NodePosition> children = position.children;
            int childIdx = 0;
            while (childIdx < children.size()) {
                this.doDelete(children.get(childIdx));
                ++childIdx;
            }
        }
    }

    void markDirtyRegion(int offset, int length) {
        this.markDirtyStart(offset);
        this.markDirtyEnd(offset + length);
    }

    public void markDirtyStart(int offset) {
        if (offset < this.dirtyStartOffset) {
            this.dirtyStartOffset = offset;
        }
    }

    @Override
    public void markDirtyEnd(int offset) {
        if (offset > this.dirtyEndOffset) {
            this.dirtyEndOffset = offset;
        }
    }

    @Nullable IRegion createDirtyRegion() {
        if (this.dirtyEndOffset < 0 || this.dirtyStartOffset == Integer.MAX_VALUE) {
            return null;
        }
        return new Region(this.dirtyStartOffset, Math.min(this.getDocument().getLength(), this.dirtyEndOffset) - this.dirtyStartOffset);
    }

    public boolean canBreak() {
        return this.equalTypeEndOffset >= this.dirtyEndOffset;
    }

    @Override
    public void checkBreak() {
        if (this.canBreak()) {
            throw new TreePartitionNodeScan.BreakException();
        }
    }
}

