/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.conn;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.db.TriggerExecutionContext;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.LanguageFactory;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.compile.ASTVisitor;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.OptTrace;
import org.apache.derby.iapi.sql.compile.OptimizerFactory;
import org.apache.derby.iapi.sql.compile.TypeCompilerFactory;
import org.apache.derby.iapi.sql.conn.Authorizer;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.iapi.sql.conn.SQLSessionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.CursorActivation;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.ExecutionStmtValidator;
import org.apache.derby.iapi.sql.execute.RunTimeStatistics;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.XATransactionController;
import org.apache.derby.iapi.transaction.TransactionControl;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.sql.GenericPreparedStatement;
import org.apache.derby.impl.sql.GenericStatement;
import org.apache.derby.impl.sql.compile.CompilerContextImpl;
import org.apache.derby.impl.sql.conn.CachedStatement;
import org.apache.derby.impl.sql.conn.GenericAuthorizer;
import org.apache.derby.impl.sql.conn.GenericStatementContext;
import org.apache.derby.impl.sql.conn.SQLSessionContextImpl;
import org.apache.derby.impl.sql.conn.TempTableInfo;
import org.apache.derby.impl.sql.execute.AutoincrementCounter;
import org.apache.derby.impl.sql.execute.DeferredConstraintsMemory;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derby.shared.common.stream.HeaderPrintWriter;

public class GenericLanguageConnectionContext
extends ContextImpl
implements LanguageConnectionContext {
    private static final int NON_XA = 0;
    private static final int XA_ONE_PHASE = 1;
    private static final int XA_TWO_PHASE = 2;
    private final ArrayList<Activation> acts;
    private volatile boolean unusedActs = false;
    private int maxActsSize;
    protected int bindCount;
    private boolean ddWriteMode;
    private boolean runTimeStatisticsSetting;
    private boolean statisticsTiming;
    private boolean xplainOnlyMode = false;
    private String xplain_schema = null;
    private Map<Object, Object> xplain_statements = new HashMap<Object, Object>();
    private ArrayList<TempTableInfo> allDeclaredGlobalTempTables;
    private int currentSavepointLevel = 0;
    protected long nextCursorId;
    protected int nextSavepointId;
    private RunTimeStatistics runTimeStatisticsObject;
    private StringBuffer sb;
    private Database db;
    private final int instanceNumber;
    private String drdaID;
    private String dbname;
    private Object lastQueryTree;
    private final TransactionController tran;
    private TransactionController readOnlyNestedTransaction;
    private int queryNestingDepth;
    protected DataValueFactory dataFactory;
    protected LanguageFactory langFactory;
    protected TypeCompilerFactory tcf;
    protected OptimizerFactory of;
    protected LanguageConnectionFactory connFactory;
    private final StatementContext[] statementContexts = new StatementContext[2];
    private int statementDepth;
    protected int outermostTrigger = -1;
    protected Authorizer authorizer;
    protected String userName = null;
    private SQLSessionContext topLevelSSC;
    private SchemaDescriptor cachedInitialDefaultSchemaDescr = null;
    private int defaultIsolationLevel;
    protected int isolationLevel = this.defaultIsolationLevel = 2;
    private boolean isolationLevelExplicitlySet = false;
    private boolean isolationLevelSetUsingSQLorJDBC = false;
    protected int prepareIsolationLevel = 0;
    private boolean logStatementText;
    private boolean logQueryPlan;
    private HeaderPrintWriter istream;
    private int lockEscalationThreshold;
    private ArrayList<ExecutionStmtValidator> stmtValidators;
    private ArrayList<TriggerExecutionContext> triggerExecutionContexts;
    private ArrayList<TableDescriptor> triggerTables;
    private OptTrace optimizerTracer;
    private HashMap<String, Long> autoincrementHT;
    private boolean autoincrementUpdate;
    private long identityVal;
    private boolean identityNotNull;
    private HashMap<String, AutoincrementCounter> autoincrementCacheHashtable;
    private ASTVisitor astWalker;
    private StandardException interruptedException;
    private WeakHashMap<TableDescriptor, FormatableBitSet> referencedColumnMap;
    private HashMap<UUID, DeferredConstraintsMemory.ValidationInfo> deferredHashTables;
    private String sessionUser = null;
    Map<Object, Object> printedObjectsMap = null;

    public GenericLanguageConnectionContext(ContextManager cm, TransactionController tranCtrl, LanguageFactory lf, LanguageConnectionFactory lcf, Database db, String userName, int instanceNumber, String drdaID, String dbname) throws StandardException {
        super(cm, "LanguageConnectionContext");
        this.acts = new ArrayList();
        this.tran = tranCtrl;
        this.dataFactory = lcf.getDataValueFactory();
        this.tcf = lcf.getTypeCompilerFactory();
        this.of = lcf.getOptimizerFactory();
        this.langFactory = lf;
        this.connFactory = lcf;
        this.db = db;
        this.userName = userName;
        this.instanceNumber = instanceNumber;
        this.drdaID = drdaID;
        this.dbname = dbname;
        String logStatementProperty = PropertyUtil.getServiceProperty(this.getTransactionCompile(), "derby.language.logStatementText");
        this.logStatementText = Boolean.valueOf(logStatementProperty);
        String logQueryPlanProperty = PropertyUtil.getServiceProperty(this.getTransactionCompile(), "derby.language.logQueryPlan");
        this.logQueryPlan = Boolean.valueOf(logQueryPlanProperty);
        this.setRunTimeStatisticsMode(this.logQueryPlan);
        this.lockEscalationThreshold = PropertyUtil.getServiceInt(tranCtrl, "derby.locks.escalationThreshold", 100, Integer.MAX_VALUE, 5000);
        this.stmtValidators = new ArrayList();
        this.triggerExecutionContexts = new ArrayList();
        this.triggerTables = new ArrayList();
    }

    @Override
    public void initialize() throws StandardException {
        this.interruptedException = null;
        this.sessionUser = IdUtil.getUserAuthorizationId(this.userName);
        this.authorizer = new GenericAuthorizer(this);
        if (this.getSessionUserId() == null) {
            SanityManager.THROWASSERT("User name is null, check the connection manager to make sure it is set reasonably");
        }
        this.setDefaultSchema(this.initDefaultSchemaDescriptor());
        this.referencedColumnMap = new WeakHashMap();
    }

    protected SchemaDescriptor initDefaultSchemaDescriptor() throws StandardException {
        if (this.cachedInitialDefaultSchemaDescr == null) {
            DataDictionary dd = this.getDataDictionary();
            SchemaDescriptor sd = dd.getSchemaDescriptor(this.getSessionUserId(), this.getTransactionCompile(), false);
            if (sd == null) {
                sd = new SchemaDescriptor(dd, this.getSessionUserId(), this.getSessionUserId(), null, false);
            }
            this.cachedInitialDefaultSchemaDescr = sd;
        }
        return this.cachedInitialDefaultSchemaDescr;
    }

    private SchemaDescriptor getInitialDefaultSchemaDescriptor() {
        return this.cachedInitialDefaultSchemaDescr;
    }

    @Override
    public boolean getLogStatementText() {
        return this.logStatementText;
    }

    @Override
    public void setLogStatementText(boolean logStatementText) {
        this.logStatementText = logStatementText;
    }

    @Override
    public boolean getLogQueryPlan() {
        return this.logQueryPlan;
    }

    @Override
    public boolean usesSqlAuthorization() {
        return this.getDataDictionary().usesSqlAuthorization();
    }

    @Override
    public int getLockEscalationThreshold() {
        return this.lockEscalationThreshold;
    }

    @Override
    public void addActivation(Activation a) throws StandardException {
        this.acts.add(a);
        if (this.acts.size() > this.maxActsSize) {
            this.maxActsSize = this.acts.size();
        }
    }

    @Override
    public void closeUnusedActivations() throws StandardException {
        if (this.unusedActs && this.acts.size() > 20) {
            this.unusedActs = false;
            for (int i = this.acts.size() - 1; i >= 0; --i) {
                Activation a1;
                if (i >= this.acts.size() || (a1 = this.acts.get(i)).isInUse()) continue;
                a1.close();
            }
        }
        if (SanityManager.DEBUG_ON("memoryLeakTrace") && this.acts.size() > 20) {
            System.out.println("memoryLeakTrace:GenericLanguageContext:activations " + this.acts.size());
        }
    }

    @Override
    public void notifyUnusedActivation() {
        this.unusedActs = true;
    }

    @Override
    public boolean checkIfAnyDeclaredGlobalTempTablesForThisConnection() {
        return this.allDeclaredGlobalTempTables != null;
    }

    @Override
    public void addDeclaredGlobalTempTable(TableDescriptor td) throws StandardException {
        if (this.findDeclaredGlobalTempTable(td.getName()) != null) {
            throw StandardException.newException("X0Y32.S", "Declared global temporary table", td.getName(), "Schema", "SESSION");
        }
        TempTableInfo tempTableInfo = new TempTableInfo(td, this.currentSavepointLevel);
        if (this.allDeclaredGlobalTempTables == null) {
            this.allDeclaredGlobalTempTables = new ArrayList();
        }
        this.allDeclaredGlobalTempTables.add(tempTableInfo);
    }

    @Override
    public boolean dropDeclaredGlobalTempTable(String tableName) {
        TempTableInfo tempTableInfo = this.findDeclaredGlobalTempTable(tableName);
        if (tempTableInfo != null) {
            if (tempTableInfo.getDeclaredInSavepointLevel() > this.currentSavepointLevel) {
                SanityManager.THROWASSERT("declared in savepoint level (" + tempTableInfo.getDeclaredInSavepointLevel() + ") can not be higher than current savepoint level (" + this.currentSavepointLevel + ").");
            }
            if (tempTableInfo.getDeclaredInSavepointLevel() == this.currentSavepointLevel) {
                this.allDeclaredGlobalTempTables.remove(this.allDeclaredGlobalTempTables.indexOf(tempTableInfo));
                if (this.allDeclaredGlobalTempTables.isEmpty()) {
                    this.allDeclaredGlobalTempTables = null;
                }
            } else {
                tempTableInfo.setDroppedInSavepointLevel(this.currentSavepointLevel);
            }
            return true;
        }
        return false;
    }

    private void tempTablesReleaseSavepointLevels() {
        for (int i = 0; i < this.allDeclaredGlobalTempTables.size(); ++i) {
            TempTableInfo tempTableInfo = this.allDeclaredGlobalTempTables.get(i);
            if (tempTableInfo.getDroppedInSavepointLevel() > this.currentSavepointLevel) {
                tempTableInfo.setDroppedInSavepointLevel(this.currentSavepointLevel);
            }
            if (tempTableInfo.getDeclaredInSavepointLevel() > this.currentSavepointLevel) {
                tempTableInfo.setDeclaredInSavepointLevel(this.currentSavepointLevel);
            }
            if (tempTableInfo.getModifiedInSavepointLevel() <= this.currentSavepointLevel) continue;
            tempTableInfo.setModifiedInSavepointLevel(this.currentSavepointLevel);
        }
    }

    private void tempTablesAndCommit(boolean in_xa_transaction) throws StandardException {
        int i;
        for (i = this.allDeclaredGlobalTempTables.size() - 1; i >= 0; --i) {
            TempTableInfo tempTableInfo = this.allDeclaredGlobalTempTables.get(i);
            if (tempTableInfo.getDroppedInSavepointLevel() != -1) {
                this.allDeclaredGlobalTempTables.remove(i);
                continue;
            }
            tempTableInfo.setDeclaredInSavepointLevel(-1);
            tempTableInfo.setModifiedInSavepointLevel(-1);
        }
        for (i = 0; i < this.allDeclaredGlobalTempTables.size(); ++i) {
            TableDescriptor td = this.allDeclaredGlobalTempTables.get(i).getTableDescriptor();
            if (!td.isOnCommitDeleteRows() || this.checkIfAnyActivationHasHoldCursor(td.getName())) continue;
            this.getDataDictionary().getDependencyManager().invalidateFor(td, 1, this);
            if (in_xa_transaction) continue;
            this.cleanupTempTableOnCommitOrRollback(td, true);
        }
    }

    private void tempTablesXApostCommit() throws StandardException {
        TransactionController tc = this.getTransactionExecute();
        for (int i = 0; i < this.allDeclaredGlobalTempTables.size(); ++i) {
            TableDescriptor td = this.allDeclaredGlobalTempTables.get(i).getTableDescriptor();
            tc.dropConglomerate(td.getHeapConglomerateId());
            this.allDeclaredGlobalTempTables.remove(i);
        }
        tc.commit();
    }

    @Override
    public void resetFromPool() throws StandardException {
        this.interruptedException = null;
        this.identityNotNull = false;
        this.dropAllDeclaredGlobalTempTables();
        this.setDefaultSchema(null);
        this.getCurrentSQLSessionContext().setRole(null);
        this.getCurrentSQLSessionContext().setUser(this.getSessionUserId());
        this.referencedColumnMap = new WeakHashMap();
    }

    @Override
    public void setLastQueryTree(Object queryTree) {
        this.lastQueryTree = queryTree;
    }

    @Override
    public Object getLastQueryTree() {
        return this.lastQueryTree;
    }

    private void dropAllDeclaredGlobalTempTables() throws StandardException {
        if (this.allDeclaredGlobalTempTables == null) {
            return;
        }
        DependencyManager dm = this.getDataDictionary().getDependencyManager();
        StandardException topLevelStandardException = null;
        for (int i = 0; i < this.allDeclaredGlobalTempTables.size(); ++i) {
            try {
                TempTableInfo tempTableInfo = this.allDeclaredGlobalTempTables.get(i);
                TableDescriptor td = tempTableInfo.getTableDescriptor();
                dm.invalidateFor(td, 1, this);
                this.tran.dropConglomerate(td.getHeapConglomerateId());
                continue;
            }
            catch (StandardException e) {
                if (topLevelStandardException == null) {
                    topLevelStandardException = e;
                    continue;
                }
                try {
                    e.initCause(topLevelStandardException);
                    topLevelStandardException = e;
                    continue;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
        this.allDeclaredGlobalTempTables = null;
        try {
            this.internalCommit(true);
        }
        catch (StandardException e) {
            if (topLevelStandardException == null) {
                topLevelStandardException = e;
            }
            try {
                e.initCause(topLevelStandardException);
                topLevelStandardException = e;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (topLevelStandardException != null) {
            throw topLevelStandardException;
        }
    }

    private void tempTablesAndRollback() throws StandardException {
        for (int i = this.allDeclaredGlobalTempTables.size() - 1; i >= 0; --i) {
            TableDescriptor td;
            TempTableInfo tempTableInfo = this.allDeclaredGlobalTempTables.get(i);
            if (tempTableInfo.getDeclaredInSavepointLevel() >= this.currentSavepointLevel) {
                if (tempTableInfo.getDroppedInSavepointLevel() == -1) {
                    td = tempTableInfo.getTableDescriptor();
                    this.invalidateCleanupDroppedTable(td);
                    this.tran.dropConglomerate(td.getHeapConglomerateId());
                    this.allDeclaredGlobalTempTables.remove(i);
                    continue;
                }
                if (tempTableInfo.getDroppedInSavepointLevel() < this.currentSavepointLevel) continue;
                this.allDeclaredGlobalTempTables.remove(i);
                continue;
            }
            if (tempTableInfo.getDroppedInSavepointLevel() >= this.currentSavepointLevel) {
                td = tempTableInfo.getTableDescriptor();
                td = this.cleanupTempTableOnCommitOrRollback(td, false);
                tempTableInfo.setTableDescriptor(td);
                tempTableInfo.setDroppedInSavepointLevel(-1);
                tempTableInfo.setModifiedInSavepointLevel(-1);
                this.allDeclaredGlobalTempTables.set(i, tempTableInfo);
                continue;
            }
            if (tempTableInfo.getModifiedInSavepointLevel() < this.currentSavepointLevel) continue;
            tempTableInfo.setModifiedInSavepointLevel(-1);
            td = tempTableInfo.getTableDescriptor();
            this.invalidateCleanupDroppedTable(td);
        }
        if (this.allDeclaredGlobalTempTables.isEmpty()) {
            this.allDeclaredGlobalTempTables = null;
        }
    }

    private void invalidateCleanupDroppedTable(TableDescriptor td) throws StandardException {
        this.getDataDictionary().getDependencyManager().invalidateFor(td, 1, this);
        this.cleanupTempTableOnCommitOrRollback(td, true);
    }

    private void replaceDeclaredGlobalTempTable(String tableName, TableDescriptor td) {
        TempTableInfo tempTableInfo = this.findDeclaredGlobalTempTable(tableName);
        tempTableInfo.setDroppedInSavepointLevel(-1);
        tempTableInfo.setDeclaredInSavepointLevel(-1);
        tempTableInfo.setTableDescriptor(td);
        this.allDeclaredGlobalTempTables.set(this.allDeclaredGlobalTempTables.indexOf(tempTableInfo), tempTableInfo);
    }

    @Override
    public TableDescriptor getTableDescriptorForDeclaredGlobalTempTable(String tableName) {
        TempTableInfo tempTableInfo = this.findDeclaredGlobalTempTable(tableName);
        if (tempTableInfo == null) {
            return null;
        }
        return tempTableInfo.getTableDescriptor();
    }

    private TempTableInfo findDeclaredGlobalTempTable(String tableName) {
        if (this.allDeclaredGlobalTempTables == null) {
            return null;
        }
        for (int i = 0; i < this.allDeclaredGlobalTempTables.size(); ++i) {
            if (!this.allDeclaredGlobalTempTables.get(i).matches(tableName)) continue;
            return this.allDeclaredGlobalTempTables.get(i);
        }
        return null;
    }

    @Override
    public void markTempTableAsModifiedInUnitOfWork(String tableName) {
        TempTableInfo tempTableInfo = this.findDeclaredGlobalTempTable(tableName);
        tempTableInfo.setModifiedInSavepointLevel(this.currentSavepointLevel);
    }

    @Override
    public PreparedStatement prepareInternalStatement(SchemaDescriptor compilationSchema, String sqlText, boolean isForReadOnly, boolean forMetaData) throws StandardException {
        if (forMetaData) {
            compilationSchema = this.getDataDictionary().getSystemSchemaDescriptor();
        }
        return this.connFactory.getStatement(compilationSchema, sqlText, isForReadOnly).prepare(this, forMetaData);
    }

    @Override
    public PreparedStatement prepareInternalStatement(String sqlText) throws StandardException {
        return this.connFactory.getStatement(this.getDefaultSchema(), sqlText, true).prepare(this);
    }

    @Override
    public void removeActivation(Activation a) {
        SanityManager.ASSERT(a.isClosed(), "Activation is not closed");
        this.acts.remove(a);
        if (this.maxActsSize > 20 && this.maxActsSize > 2 * this.acts.size()) {
            this.acts.trimToSize();
            this.maxActsSize = this.acts.size();
        }
    }

    @Override
    public int getActivationCount() {
        return this.acts.size();
    }

    @Override
    public CursorActivation lookupCursorActivation(String cursorName) {
        int size = this.acts.size();
        if (size > 0) {
            int cursorHash = cursorName.hashCode();
            for (int i = 0; i < size; ++i) {
                ResultSet rs;
                String executingCursorName;
                Activation a = this.acts.get(i);
                if (!a.isInUse() || (executingCursorName = a.getCursorName()) == null || executingCursorName.hashCode() != cursorHash || !cursorName.equals(executingCursorName) || (rs = a.getResultSet()) == null || rs.isClosed()) continue;
                return (CursorActivation)a;
            }
        }
        return null;
    }

    public void removeStatement(GenericStatement statement) throws StandardException {
        CacheManager statementCache = this.getLanguageConnectionFactory().getStatementCache();
        if (statementCache == null) {
            return;
        }
        Cacheable cachedItem = statementCache.findCached(statement);
        if (cachedItem != null) {
            CachedStatement cs = (CachedStatement)cachedItem;
            if (statement.getPreparedStatement() != cs.getPreparedStatement()) {
                statementCache.release(cachedItem);
            } else {
                statementCache.remove(cachedItem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement lookupStatement(GenericStatement statement) throws StandardException {
        GenericPreparedStatement ps;
        CacheManager statementCache = this.getLanguageConnectionFactory().getStatementCache();
        if (statementCache == null) {
            return null;
        }
        if (this.dataDictionaryInWriteMode()) {
            return null;
        }
        Cacheable cachedItem = statementCache.find(statement);
        CachedStatement cs = (CachedStatement)cachedItem;
        GenericPreparedStatement genericPreparedStatement = ps = cs.getPreparedStatement();
        synchronized (genericPreparedStatement) {
            if (ps.upToDate()) {
                GeneratedClass ac = ps.getActivationClass();
                int currentClasses = this.getLanguageConnectionFactory().getClassFactory().getClassLoaderVersion();
                if (ac.getClassLoaderVersion() != currentClasses) {
                    ps.makeInvalid(23, this);
                }
            }
        }
        statementCache.release(cachedItem);
        return ps;
    }

    @Override
    public String getUniqueCursorName() {
        return this.getNameString("SQLCUR", this.nextCursorId++);
    }

    @Override
    public String getUniqueSavepointName() {
        return this.getNameString("SAVEPT", this.nextSavepointId++);
    }

    @Override
    public int getUniqueSavepointID() {
        return this.nextSavepointId - 1;
    }

    private String getNameString(String prefix, long number) {
        if (this.sb != null) {
            this.sb.setLength(0);
        } else {
            this.sb = new StringBuffer();
        }
        this.sb.append(prefix).append(number);
        return this.sb.toString();
    }

    @Override
    public void internalCommit(boolean commitStore) throws StandardException {
        this.doCommit(commitStore, true, 0, false);
    }

    @Override
    public void userCommit() throws StandardException {
        this.doCommit(true, true, 0, true);
    }

    @Override
    public final void internalCommitNoSync(int commitflag) throws StandardException {
        this.doCommit(true, false, commitflag, false);
    }

    @Override
    public final void xaCommit(boolean onePhase) throws StandardException {
        this.doCommit(true, true, onePhase ? 1 : 2, true);
    }

    protected void doCommit(boolean commitStore, boolean sync, int commitflag, boolean requestedByUser) throws StandardException {
        TransactionController tc;
        StatementContext statementContext = this.getStatementContext();
        if (requestedByUser && statementContext != null && statementContext.inUse() && statementContext.isAtomic()) {
            throw StandardException.newException("X0Y66.S", new Object[0]);
        }
        this.checkIntegrity();
        if (this.logStatementText) {
            if (this.istream == null) {
                this.istream = Monitor.getStream();
            }
            String xactId = this.tran.getTransactionIdString();
            this.istream.printlnWithHeader("(XID = " + xactId + "), (SESSIONID = " + this.instanceNumber + "), (DATABASE = " + this.dbname + "), (DRDAID = " + this.drdaID + "), Committing");
        }
        this.endTransactionActivationHandling(false);
        if (this.allDeclaredGlobalTempTables != null) {
            this.tempTablesAndCommit(commitflag != 0);
        }
        this.currentSavepointLevel = 0;
        if (sync) {
            this.finishDDTransaction();
        }
        if (this.readOnlyNestedTransaction != null) {
            SanityManager.THROWASSERT("Nested transaction active!");
        }
        if ((tc = this.getTransactionExecute()) != null && commitStore) {
            if (sync) {
                if (commitflag == 0) {
                    tc.commit();
                } else {
                    SanityManager.ASSERT(commitflag == 1 || commitflag == 2, "invalid commit flag");
                    ((XATransactionController)tc).xa_commit(commitflag == 1);
                }
            } else {
                tc.commitNoSync(commitflag);
            }
            this.resetSavepoints();
            if (this.allDeclaredGlobalTempTables != null && commitflag != 0) {
                this.tempTablesXApostCommit();
            }
        }
    }

    private TableDescriptor cleanupTempTableOnCommitOrRollback(TableDescriptor td, boolean dropAndRedeclare) throws StandardException {
        TransactionController tc = this.getTransactionExecute();
        long conglomId = tc.createConglomerate("heap", td.getEmptyExecRow().getRowArray(), null, td.getColumnCollationIds(), null, 3);
        long cid = td.getHeapConglomerateId();
        ConglomerateDescriptor cgd = td.getConglomerateDescriptor(cid);
        td.getConglomerateDescriptorList().dropConglomerateDescriptorByUUID(cgd.getUUID());
        cgd = this.getDataDictionary().getDataDescriptorGenerator().newConglomerateDescriptor(conglomId, null, false, null, false, null, td.getUUID(), td.getSchemaDescriptor().getUUID());
        ConglomerateDescriptorList conglomList = td.getConglomerateDescriptorList();
        conglomList.add(cgd);
        td.resetHeapConglomNumber();
        if (dropAndRedeclare) {
            tc.dropConglomerate(cid);
            this.replaceDeclaredGlobalTempTable(td.getName(), td);
        }
        return td;
    }

    @Override
    public void internalRollback() throws StandardException {
        this.doRollback(false, false);
    }

    @Override
    public void userRollback() throws StandardException {
        this.doRollback(false, true);
    }

    @Override
    public void xaRollback() throws StandardException {
        this.doRollback(true, true);
    }

    private void doRollback(boolean xa, boolean requestedByUser) throws StandardException {
        TransactionController tc;
        StatementContext statementContext = this.getStatementContext();
        if (requestedByUser && statementContext != null && statementContext.inUse() && statementContext.isAtomic()) {
            throw StandardException.newException("X0Y67.S", new Object[0]);
        }
        this.clearDeferreds();
        if (this.logStatementText) {
            if (this.istream == null) {
                this.istream = Monitor.getStream();
            }
            String xactId = this.tran.getTransactionIdString();
            this.istream.printlnWithHeader("(XID = " + xactId + "), (SESSIONID = " + this.instanceNumber + "), (DATABASE = " + this.dbname + "), (DRDAID = " + this.drdaID + "), Rolling back");
        }
        this.endTransactionActivationHandling(true);
        this.currentSavepointLevel = 0;
        if (this.allDeclaredGlobalTempTables != null) {
            this.tempTablesAndRollback();
        }
        this.finishDDTransaction();
        if (this.readOnlyNestedTransaction != null) {
            this.readOnlyNestedTransaction.destroy();
            this.readOnlyNestedTransaction = null;
            this.queryNestingDepth = 0;
        }
        if ((tc = this.getTransactionExecute()) != null) {
            if (xa) {
                ((XATransactionController)tc).xa_rollback();
            } else {
                tc.abort();
            }
            this.resetSavepoints();
        }
    }

    private void resetSavepoints() throws StandardException {
        ContextManager cm = this.getContextManager();
        List<Context> stmts = cm.getContextStack("StatementContext");
        for (Context c : stmts) {
            ((StatementContext)c).resetSavePoint();
        }
    }

    @Override
    public void internalRollbackToSavepoint(String savepointName, boolean refreshStyle, Object kindOfSavepoint) throws StandardException {
        TransactionController tc = this.getTransactionExecute();
        if (tc != null) {
            boolean closeConglomerates;
            if (refreshStyle) {
                closeConglomerates = true;
                this.endTransactionActivationHandling(true);
            } else {
                closeConglomerates = false;
            }
            this.currentSavepointLevel = tc.rollbackToSavePoint(savepointName, closeConglomerates, kindOfSavepoint);
        }
        if (tc != null && refreshStyle && this.allDeclaredGlobalTempTables != null) {
            this.tempTablesAndRollback();
        }
    }

    @Override
    public void releaseSavePoint(String savepointName, Object kindOfSavepoint) throws StandardException {
        TransactionController tc = this.getTransactionExecute();
        if (tc != null) {
            this.currentSavepointLevel = tc.releaseSavePoint(savepointName, kindOfSavepoint);
            if (this.allDeclaredGlobalTempTables != null) {
                this.tempTablesReleaseSavepointLevels();
            }
        }
    }

    @Override
    public void languageSetSavePoint(String savepointName, Object kindOfSavepoint) throws StandardException {
        TransactionController tc = this.getTransactionExecute();
        if (tc != null) {
            this.currentSavepointLevel = tc.setSavePoint(savepointName, kindOfSavepoint);
        }
    }

    @Override
    public void beginNestedTransaction(boolean readOnly) throws StandardException {
        SanityManager.ASSERT(readOnly, "Routine not yet coded to support non-readonly transactions.");
        if (this.readOnlyNestedTransaction == null) {
            this.readOnlyNestedTransaction = this.tran.startNestedUserTransaction(readOnly, true);
        }
        ++this.queryNestingDepth;
    }

    @Override
    public void commitNestedTransaction() throws StandardException {
        if (--this.queryNestingDepth == 0) {
            this.readOnlyNestedTransaction.commit();
            this.readOnlyNestedTransaction.destroy();
            this.readOnlyNestedTransaction = null;
        }
    }

    @Override
    public final TransactionController getTransactionCompile() {
        return this.readOnlyNestedTransaction != null ? this.readOnlyNestedTransaction : this.tran;
    }

    @Override
    public TransactionController getTransactionExecute() {
        return this.tran;
    }

    @Override
    public DataValueFactory getDataValueFactory() {
        return this.dataFactory;
    }

    @Override
    public LanguageFactory getLanguageFactory() {
        return this.langFactory;
    }

    @Override
    public OptimizerFactory getOptimizerFactory() {
        return this.of;
    }

    @Override
    public LanguageConnectionFactory getLanguageConnectionFactory() {
        return this.connFactory;
    }

    private boolean checkIfAnyActivationHasHoldCursor(String tableName) throws StandardException {
        for (int i = this.acts.size() - 1; i >= 0; --i) {
            Activation a = this.acts.get(i);
            if (!a.checkIfThisActivationHasHoldCursor(tableName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean verifyAllHeldResultSetsAreClosed() throws StandardException {
        ResultSet rs;
        Activation a;
        int i;
        boolean seenOpenResultSets = false;
        for (i = this.acts.size() - 1; i >= 0; --i) {
            a = this.acts.get(i);
            SanityManager.ASSERT(a instanceof CursorActivation, "a is not a CursorActivation");
            if (!a.isInUse() || !a.getResultSetHoldability() || (rs = ((CursorActivation)a).getResultSet()) == null || rs.isClosed() || !rs.returnsRows()) continue;
            seenOpenResultSets = true;
            break;
        }
        if (!seenOpenResultSets) {
            return true;
        }
        System.gc();
        System.runFinalization();
        for (i = this.acts.size() - 1; i >= 0; --i) {
            a = this.acts.get(i);
            SanityManager.ASSERT(a instanceof CursorActivation, "a is not a CursorActivation");
            if (!a.isInUse() || !a.getResultSetHoldability() || (rs = ((CursorActivation)a).getResultSet()) == null || rs.isClosed() || !rs.returnsRows()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean verifyNoOpenResultSets(PreparedStatement pStmt, Provider provider, int action) throws StandardException {
        ResultSet rs;
        Activation a;
        int i;
        boolean seenOpenResultSets = false;
        for (i = this.acts.size() - 1; i >= 0; --i) {
            a = this.acts.get(i);
            if (!a.isInUse() || pStmt != a.getPreparedStatement() || (rs = a.getResultSet()) == null || rs.isClosed() || !rs.returnsRows()) continue;
            seenOpenResultSets = true;
            break;
        }
        if (!seenOpenResultSets) {
            return false;
        }
        System.gc();
        System.runFinalization();
        for (i = this.acts.size() - 1; i >= 0; --i) {
            a = this.acts.get(i);
            if (!a.isInUse() || pStmt != a.getPreparedStatement() || (rs = a.getResultSet()) == null || rs.isClosed()) continue;
            if (provider != null && rs.returnsRows()) {
                DependencyManager dmgr = this.getDataDictionary().getDependencyManager();
                throw StandardException.newException("X0X95.S", dmgr.getActionString(action), provider.getObjectName());
            }
            return true;
        }
        return false;
    }

    @Override
    public String getSessionUserId() {
        return this.sessionUser;
    }

    @Override
    public SchemaDescriptor getDefaultSchema() {
        return this.getCurrentSQLSessionContext().getDefaultSchema();
    }

    @Override
    public SchemaDescriptor getDefaultSchema(Activation a) {
        return this.getCurrentSQLSessionContext(a).getDefaultSchema();
    }

    @Override
    public String getCurrentSchemaName() {
        SchemaDescriptor s = this.getDefaultSchema();
        if (null == s) {
            return null;
        }
        return s.getSchemaName();
    }

    @Override
    public String getCurrentSchemaName(Activation a) {
        SchemaDescriptor s = this.getDefaultSchema(a);
        if (null == s) {
            return null;
        }
        return s.getSchemaName();
    }

    @Override
    public boolean isInitialDefaultSchema(String schemaName) {
        return this.cachedInitialDefaultSchemaDescr.getSchemaName().equals(schemaName);
    }

    @Override
    public void setDefaultSchema(SchemaDescriptor sd) throws StandardException {
        if (sd == null) {
            sd = this.getInitialDefaultSchemaDescriptor();
        }
        this.getCurrentSQLSessionContext().setDefaultSchema(sd);
    }

    @Override
    public void setDefaultSchema(Activation a, SchemaDescriptor sd) throws StandardException {
        if (sd == null) {
            sd = this.getInitialDefaultSchemaDescriptor();
        }
        this.getCurrentSQLSessionContext(a).setDefaultSchema(sd);
    }

    @Override
    public void resetSchemaUsages(Activation activation, String schemaName) throws StandardException {
        SchemaDescriptor defaultSchema = this.getInitialDefaultSchemaDescriptor();
        for (Activation parent = activation.getParentActivation(); parent != null; parent = parent.getParentActivation()) {
            SQLSessionContext ssc = parent.getSQLSessionContextForChildren();
            SchemaDescriptor s = ssc.getDefaultSchema();
            SanityManager.ASSERT(s != null, "s should not be empty here");
            if (!schemaName.equals(s.getSchemaName())) continue;
            ssc.setDefaultSchema(defaultSchema);
        }
        SQLSessionContext top = this.getTopLevelSQLSessionContext();
        SchemaDescriptor sd = top.getDefaultSchema();
        SanityManager.ASSERT(sd != null, "sd should not be empty here");
        if (schemaName.equals(sd.getSchemaName())) {
            top.setDefaultSchema(defaultSchema);
        }
    }

    @Override
    public Long getIdentityValue() {
        return this.identityNotNull ? Long.valueOf(this.identityVal) : null;
    }

    @Override
    public void setIdentityValue(long val) {
        this.identityVal = val;
        this.identityNotNull = true;
    }

    @Override
    public final CompilerContext pushCompilerContext() {
        return this.pushCompilerContext(null);
    }

    @Override
    public CompilerContext pushCompilerContext(SchemaDescriptor sd) {
        boolean firstCompilerContext = false;
        CompilerContext cc = (CompilerContext)this.getContextManager().getContext("CompilerContext");
        if (cc == null) {
            firstCompilerContext = true;
        }
        if (cc == null || cc.getInUse()) {
            cc = new CompilerContextImpl(this.getContextManager(), this, this.tcf);
            if (firstCompilerContext) {
                cc.firstOnStack();
            }
        } else {
            cc.resetContext();
        }
        cc.setInUse(true);
        StatementContext sc = this.getStatementContext();
        if (sc.getSystemCode()) {
            cc.setReliability(0);
        }
        if (sd != null && sd.getUUID() != null) {
            cc.setCompilationSchema(sd);
        }
        return cc;
    }

    @Override
    public void popCompilerContext(CompilerContext cc) {
        cc.setCurrentDependent(null);
        cc.setInUse(false);
        if (!cc.isFirstOnStack()) {
            cc.popMe();
        } else {
            cc.setCompilationSchema(null);
        }
    }

    @Override
    public StatementContext pushStatementContext(boolean isAtomic, boolean isForReadOnly, String stmtText, ParameterValueSet pvs, boolean rollbackParentContext, long timeoutMillis) {
        int parentStatementDepth = this.statementDepth;
        boolean inTrigger = false;
        boolean parentIsAtomic = false;
        StatementContext statementContext = this.statementContexts[0];
        if (statementContext == null) {
            statementContext = this.statementContexts[0] = new GenericStatementContext(this);
            statementContext.setSQLSessionContext(this.getTopLevelSQLSessionContext());
        } else if (this.statementDepth > 0) {
            StatementContext parentStatementContext;
            if (this.statementDepth == 1) {
                statementContext = this.statementContexts[1];
                if (statementContext == null) {
                    statementContext = this.statementContexts[1] = new GenericStatementContext(this);
                } else {
                    statementContext.pushMe();
                }
                parentStatementContext = this.statementContexts[0];
            } else {
                parentStatementContext = this.getStatementContext();
                statementContext = new GenericStatementContext(this);
            }
            statementContext.setSQLSessionContext(parentStatementContext.getSQLSessionContext());
            inTrigger = parentStatementContext.inTrigger() || this.outermostTrigger == parentStatementDepth;
            parentIsAtomic = parentStatementContext.isAtomic();
            statementContext.setSQLAllowed(parentStatementContext.getSQLAllowed(), false);
            if (parentStatementContext.getSystemCode()) {
                statementContext.setSystemCode();
            }
        } else {
            statementContext.setSQLSessionContext(this.getTopLevelSQLSessionContext());
        }
        this.incrementStatementDepth();
        statementContext.setInUse(inTrigger, isAtomic || parentIsAtomic, isForReadOnly, stmtText, pvs, timeoutMillis);
        if (rollbackParentContext) {
            statementContext.setParentRollback();
        }
        return statementContext;
    }

    @Override
    public void popStatementContext(StatementContext statementContext, Throwable error) {
        if (statementContext != null) {
            if (!statementContext.inUse()) {
                return;
            }
            statementContext.clearInUse();
        }
        this.decrementStatementDepth();
        if (this.statementDepth == -1) {
            int severity = error instanceof StandardException ? ((StandardException)error).getSeverity() : 0;
            SanityManager.ASSERT(error != null, "Must have error to try popStatementContext with 0 depth");
            SanityManager.ASSERT(severity == 40000, "Must have session severity error to try popStatementContext with 0 depth");
            SanityManager.ASSERT(statementContext == this.statementContexts[0], "statementContext is expected to equal statementContexts[0]");
            this.resetStatementDepth();
        } else if (this.statementDepth == 0) {
            int severity;
            int n = severity = error instanceof StandardException ? ((StandardException)error).getSeverity() : 0;
            if (error == null || severity != 40000) {
                SanityManager.ASSERT(statementContext == this.statementContexts[0], "statementContext is expected to equal statementContexts[0]");
            }
        } else {
            SanityManager.ASSERT(statementContext != this.statementContexts[0], "statementContext is not expected to equal statementContexts[0]");
            if (this.statementDepth <= 0) {
                SanityManager.THROWASSERT("statement depth expected to be >0, was " + this.statementDepth);
            }
            if (this.getContextManager().getContext(statementContext.getIdName()) != statementContext) {
                SanityManager.THROWASSERT("trying to pop statement context from middle of stack");
            }
            statementContext.popMe();
        }
    }

    @Override
    public void pushExecutionStmtValidator(ExecutionStmtValidator validator) {
        this.stmtValidators.add(validator);
    }

    @Override
    public void popExecutionStmtValidator(ExecutionStmtValidator validator) throws StandardException {
        boolean foundElement = this.stmtValidators.remove(validator);
        if (!foundElement) {
            SanityManager.THROWASSERT("statement validator " + validator + " not found");
        }
    }

    @Override
    public void pushTriggerExecutionContext(TriggerExecutionContext tec) throws StandardException {
        if (this.outermostTrigger == -1) {
            this.outermostTrigger = this.statementDepth;
        }
        if (this.triggerExecutionContexts.size() >= 16) {
            throw StandardException.newException("54038", new Object[0]);
        }
        this.triggerExecutionContexts.add(tec);
    }

    @Override
    public void popTriggerExecutionContext(TriggerExecutionContext tec) throws StandardException {
        boolean foundElement;
        if (this.outermostTrigger == this.statementDepth) {
            this.outermostTrigger = -1;
        }
        if (!(foundElement = this.triggerExecutionContexts.remove(tec))) {
            SanityManager.THROWASSERT("trigger execution context " + tec + " not found");
        }
    }

    @Override
    public TriggerExecutionContext getTriggerExecutionContext() {
        return this.triggerExecutionContexts.isEmpty() ? null : this.triggerExecutionContexts.get(this.triggerExecutionContexts.size() - 1);
    }

    @Override
    public void validateStmtExecution(ConstantAction constantAction) throws StandardException {
        SanityManager.ASSERT(constantAction != null, "constantAction is null");
        if (this.stmtValidators.size() > 0) {
            Iterator<ExecutionStmtValidator> it = this.stmtValidators.iterator();
            while (it.hasNext()) {
                it.next().validateStatement(constantAction);
            }
        }
    }

    @Override
    public void pushTriggerTable(TableDescriptor td) {
        this.triggerTables.add(td);
    }

    @Override
    public void popTriggerTable(TableDescriptor td) {
        boolean foundElement = this.triggerTables.remove(td);
        if (!foundElement) {
            SanityManager.THROWASSERT("trigger table not found: " + td);
        }
    }

    @Override
    public TableDescriptor getTriggerTable() {
        return this.triggerTables.isEmpty() ? (TableDescriptor)null : this.triggerTables.get(this.triggerTables.size() - 1);
    }

    @Override
    public Database getDatabase() {
        return this.db;
    }

    @Override
    public int incrementBindCount() {
        ++this.bindCount;
        return this.bindCount;
    }

    @Override
    public int decrementBindCount() {
        --this.bindCount;
        if (this.bindCount < 0) {
            SanityManager.THROWASSERT("Level of nested binding == " + this.bindCount);
        }
        return this.bindCount;
    }

    @Override
    public int getBindCount() {
        return this.bindCount;
    }

    @Override
    public final void setDataDictionaryWriteMode() {
        this.ddWriteMode = true;
    }

    @Override
    public final boolean dataDictionaryInWriteMode() {
        return this.ddWriteMode;
    }

    @Override
    public final void setRunTimeStatisticsMode(boolean onOrOff) {
        this.runTimeStatisticsSetting = onOrOff;
    }

    @Override
    public boolean getRunTimeStatisticsMode() {
        return this.runTimeStatisticsSetting;
    }

    @Override
    public void setStatisticsTiming(boolean onOrOff) {
        this.statisticsTiming = onOrOff;
    }

    @Override
    public boolean getStatisticsTiming() {
        return this.statisticsTiming;
    }

    @Override
    public void setRunTimeStatisticsObject(RunTimeStatistics runTimeStatisticsObject) {
        this.runTimeStatisticsObject = runTimeStatisticsObject;
    }

    @Override
    public RunTimeStatistics getRunTimeStatisticsObject() {
        return this.runTimeStatisticsObject;
    }

    @Override
    public int getStatementDepth() {
        return this.statementDepth;
    }

    @Override
    public boolean isIsolationLevelSetUsingSQLorJDBC() {
        return this.isolationLevelSetUsingSQLorJDBC;
    }

    @Override
    public void resetIsolationLevelFlagUsedForSQLandJDBC() {
        this.isolationLevelSetUsingSQLorJDBC = false;
    }

    @Override
    public void setIsolationLevel(int isolationLevel) throws StandardException {
        StatementContext stmtCtxt = this.getStatementContext();
        if (stmtCtxt != null && stmtCtxt.inTrigger()) {
            throw StandardException.newException("X0Y71.S", this.getTriggerExecutionContext().toString());
        }
        if (this.isolationLevel != isolationLevel && !this.verifyAllHeldResultSetsAreClosed()) {
            throw StandardException.newException("X0X03.S", new Object[0]);
        }
        TransactionController tc = this.getTransactionExecute();
        if (!tc.isIdle()) {
            if (tc.isGlobal()) {
                throw StandardException.newException("X0Y77.S", new Object[0]);
            }
            this.userCommit();
        }
        this.isolationLevel = isolationLevel;
        this.isolationLevelExplicitlySet = true;
        this.isolationLevelSetUsingSQLorJDBC = true;
    }

    @Override
    public int getCurrentIsolationLevel() {
        return this.isolationLevel == 0 ? this.defaultIsolationLevel : this.isolationLevel;
    }

    @Override
    public String getCurrentIsolationLevelStr() {
        if (this.isolationLevel >= 0 && this.isolationLevel < TransactionControl.isolationMapCount()) {
            return TransactionControl.isolationTextNames(this.isolationLevel)[0];
        }
        return TransactionControl.isolationTextNames(0)[0];
    }

    @Override
    public void setPrepareIsolationLevel(int level) {
        this.prepareIsolationLevel = level;
    }

    @Override
    public int getPrepareIsolationLevel() {
        if (!this.isolationLevelExplicitlySet) {
            return this.prepareIsolationLevel;
        }
        return 0;
    }

    @Override
    public StatementContext getStatementContext() {
        return (StatementContext)this.getContextManager().getContext("StatementContext");
    }

    @Override
    public void setOptimizerTracer(OptTrace tracer) {
        this.optimizerTracer = tracer;
    }

    @Override
    public OptTrace getOptimizerTracer() {
        return this.optimizerTracer;
    }

    @Override
    public boolean optimizerTracingIsOn() {
        return this.optimizerTracer != null;
    }

    @Override
    public boolean isTransactionPristine() {
        return this.getTransactionExecute().isPristine();
    }

    @Override
    public void cleanupOnError(Throwable error) throws StandardException {
        int severity;
        int n = severity = error instanceof StandardException ? ((StandardException)error).getSeverity() : 40000;
        if (this.statementContexts[0] != null) {
            this.statementContexts[0].clearInUse();
            if (severity >= 40000) {
                this.statementContexts[0].popMe();
            }
        }
        if (this.statementContexts[1] != null) {
            this.statementContexts[1].clearInUse();
        }
        if (severity >= 40000) {
            for (int i = this.acts.size() - 1; i >= 0; --i) {
                if (i >= this.acts.size()) continue;
                Activation a = this.acts.get(i);
                a.reset();
                a.close();
            }
            this.popMe();
            InterruptStatus.saveInfoFromLcc(this);
        } else if (severity >= 30000) {
            this.internalRollback();
        }
    }

    @Override
    public boolean isLastHandler(int severity) {
        return false;
    }

    private void endTransactionActivationHandling(boolean forRollback) throws StandardException {
        for (int i = this.acts.size() - 1; i >= 0; --i) {
            boolean resultsetReturnsRows;
            if (i >= this.acts.size()) continue;
            Activation a = this.acts.get(i);
            if (!a.isInUse()) {
                a.close();
                continue;
            }
            ResultSet activationResultSet = a.getResultSet();
            boolean bl = resultsetReturnsRows = activationResultSet != null && activationResultSet.returnsRows();
            if (forRollback) {
                ExecPreparedStatement ps;
                if (resultsetReturnsRows) {
                    a.reset();
                }
                if (!this.dataDictionaryInWriteMode() || (ps = a.getPreparedStatement()) == null) continue;
                ps.makeInvalid(4, this);
                continue;
            }
            if (resultsetReturnsRows) {
                if (!a.getResultSetHoldability()) {
                    activationResultSet.close();
                } else {
                    activationResultSet.clearCurrentRow();
                }
            }
            a.clearHeapConglomerateController();
        }
    }

    private void finishDDTransaction() throws StandardException {
        if (this.ddWriteMode) {
            DataDictionary dd = this.getDataDictionary();
            dd.transactionFinished();
            this.ddWriteMode = false;
        }
    }

    private void incrementStatementDepth() {
        ++this.statementDepth;
    }

    private void decrementStatementDepth() {
        --this.statementDepth;
    }

    protected void resetStatementDepth() {
        this.statementDepth = 0;
    }

    @Override
    public DataDictionary getDataDictionary() {
        return this.getDatabase().getDataDictionary();
    }

    @Override
    public void setReadOnly(boolean on) throws StandardException {
        if (!this.tran.isPristine()) {
            throw StandardException.newException("25501", new Object[0]);
        }
        this.authorizer.setReadOnlyConnection(on, true);
    }

    @Override
    public boolean isReadOnly() {
        return this.authorizer.isReadOnlyConnection();
    }

    @Override
    public Authorizer getAuthorizer() {
        return this.authorizer;
    }

    @Override
    public Long lastAutoincrementValue(String schemaName, String tableName, String columnName) {
        String aiKey = AutoincrementCounter.makeIdentity(schemaName, tableName, columnName);
        int size = this.triggerExecutionContexts.size();
        for (int i = size - 1; i >= 0; --i) {
            TriggerExecutionContext itec = this.triggerExecutionContexts.get(i);
            Long value = itec.getAutoincrementValue(aiKey);
            if (value == null) continue;
            return value;
        }
        if (this.autoincrementHT == null) {
            return null;
        }
        return this.autoincrementHT.get(aiKey);
    }

    @Override
    public void setAutoincrementUpdate(boolean flag) {
        this.autoincrementUpdate = flag;
    }

    @Override
    public boolean getAutoincrementUpdate() {
        return this.autoincrementUpdate;
    }

    @Override
    public void autoincrementCreateCounter(String s, String t, String c, Long initialValue, long increment, int position) {
        AutoincrementCounter aic;
        String key = AutoincrementCounter.makeIdentity(s, t, c);
        if (this.autoincrementCacheHashtable == null) {
            this.autoincrementCacheHashtable = new HashMap();
        }
        if ((aic = this.autoincrementCacheHashtable.get(key)) != null) {
            SanityManager.THROWASSERT("Autoincrement Counter already exists:" + key);
            return;
        }
        aic = new AutoincrementCounter(initialValue, increment, 0L, s, t, c, position);
        this.autoincrementCacheHashtable.put(key, aic);
    }

    @Override
    public long nextAutoincrementValue(String schemaName, String tableName, String columnName) throws StandardException {
        String key = AutoincrementCounter.makeIdentity(schemaName, tableName, columnName);
        AutoincrementCounter aic = this.autoincrementCacheHashtable.get(key);
        if (aic == null) {
            SanityManager.THROWASSERT("counter doesn't exist:" + key);
            return 0L;
        }
        return aic.update();
    }

    @Override
    public void autoincrementFlushCache(UUID tableUUID) throws StandardException {
        if (this.autoincrementCacheHashtable == null) {
            return;
        }
        if (this.autoincrementHT == null) {
            this.autoincrementHT = new HashMap();
        }
        DataDictionary dd = this.getDataDictionary();
        for (String key : this.autoincrementCacheHashtable.keySet()) {
            AutoincrementCounter aic = this.autoincrementCacheHashtable.get(key);
            Long value = aic.getCurrentValue();
            aic.flushToDisk(this.getTransactionExecute(), dd, tableUUID);
            if (value == null) continue;
            this.autoincrementHT.put(key, value);
        }
        this.autoincrementCacheHashtable.clear();
    }

    @Override
    public void copyHashtableToAIHT(Map<String, Long> from) {
        if (from.isEmpty()) {
            return;
        }
        if (this.autoincrementHT == null) {
            this.autoincrementHT = new HashMap();
        }
        this.autoincrementHT.putAll(from);
    }

    @Override
    public int getInstanceNumber() {
        return this.instanceNumber;
    }

    @Override
    public String getDrdaID() {
        return this.drdaID;
    }

    @Override
    public void setDrdaID(String drdaID) {
        this.drdaID = drdaID;
    }

    @Override
    public String getDbname() {
        return this.dbname;
    }

    @Override
    public Activation getLastActivation() {
        return this.acts.get(this.acts.size() - 1);
    }

    @Override
    public StringBuffer appendErrorInfo() {
        TransactionController tc = this.getTransactionExecute();
        if (tc == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(200);
        sb.append("(XID = ");
        sb.append(tc.getTransactionIdString());
        sb.append("), ");
        sb.append("(SESSIONID = ");
        sb.append(Integer.toString(this.getInstanceNumber()));
        sb.append("), ");
        sb.append("(DATABASE = ");
        sb.append(this.getDbname());
        sb.append("), ");
        sb.append("(DRDAID = ");
        sb.append(this.getDrdaID());
        sb.append("), ");
        return sb;
    }

    @Override
    public void setCurrentRole(Activation a, String role) {
        this.getCurrentSQLSessionContext(a).setRole(role);
    }

    @Override
    public String getCurrentRoleId(Activation a) {
        return this.getCurrentSQLSessionContext(a).getRole();
    }

    @Override
    public String getCurrentUserId(Activation a) {
        return this.getCurrentSQLSessionContext(a).getCurrentUser();
    }

    @Override
    public String getCurrentRoleIdDelimited(Activation a) throws StandardException {
        String role = this.getCurrentSQLSessionContext(a).getRole();
        if (role != null) {
            this.beginNestedTransaction(true);
            try {
                if (!this.roleIsSettable(a, role)) {
                    this.setCurrentRole(a, null);
                    role = null;
                }
            }
            finally {
                this.commitNestedTransaction();
            }
        }
        if (role != null) {
            role = IdUtil.normalToDelimited(role);
        }
        return role;
    }

    @Override
    public boolean roleIsSettable(Activation a, String role) throws StandardException {
        RoleGrantDescriptor grantDesc;
        DataDictionary dd = this.getDataDictionary();
        String dbo = dd.getAuthorizationDatabaseOwner();
        String currentUser = this.getCurrentUserId(a);
        if (currentUser.equals(dbo)) {
            grantDesc = dd.getRoleDefinitionDescriptor(role);
        } else {
            grantDesc = dd.getRoleGrantDescriptor(role, currentUser, dbo);
            if (grantDesc == null) {
                grantDesc = dd.getRoleGrantDescriptor(role, "PUBLIC", dbo);
            }
        }
        return grantDesc != null;
    }

    @Override
    public SQLSessionContext getCurrentSQLSessionContext(Activation activation) {
        Activation parent = activation.getParentActivation();
        SQLSessionContext curr = parent == null ? this.getTopLevelSQLSessionContext() : parent.getSQLSessionContextForChildren();
        return curr;
    }

    private SQLSessionContext getCurrentSQLSessionContext() {
        SQLSessionContext curr;
        StatementContext ctx = this.getStatementContext();
        if (ctx == null || !ctx.inUse()) {
            curr = this.getTopLevelSQLSessionContext();
        } else {
            curr = ctx.getSQLSessionContext();
            SanityManager.ASSERT(curr != null, "SQL session context should never be empty here");
        }
        return curr;
    }

    @Override
    public void pushNestedSessionContext(Activation a, boolean definersRights, String definer) throws StandardException {
        this.setupSessionContextMinion(a, true, definersRights, definer);
    }

    private void setupSessionContextMinion(Activation a, boolean push, boolean definersRights, String definer) throws StandardException {
        if (definersRights) {
            SanityManager.ASSERT(push);
        }
        SQLSessionContext sc = a.setupSQLSessionContextForChildren(push);
        if (definersRights) {
            sc.setUser(definer);
        } else {
            sc.setUser(this.getCurrentUserId(a));
        }
        if (definersRights) {
            sc.setRole(null);
        } else {
            sc.setRole(this.getCurrentRoleId(a));
        }
        if (definersRights) {
            SchemaDescriptor sd = this.getDataDictionary().getSchemaDescriptor(definer, this.getTransactionExecute(), false);
            if (sd == null) {
                sd = new SchemaDescriptor(this.getDataDictionary(), definer, definer, null, false);
            }
            sc.setDefaultSchema(sd);
        } else {
            sc.setDefaultSchema(this.getDefaultSchema(a));
        }
        SQLSessionContext ssc = this.getCurrentSQLSessionContext(a);
        sc.setDeferredAll(ssc.getDeferredAll());
        sc.setConstraintModes(ssc.getConstraintModes());
        StatementContext stmctx = this.getStatementContext();
        stmctx.setSQLSessionContext(sc);
    }

    @Override
    public void popNestedSessionContext(Activation a) throws StandardException {
        SQLSessionContext nested = a.getSQLSessionContextForChildren();
        SQLSessionContext caller = this.getCurrentSQLSessionContext(a);
        this.compareConstraintModes(nested, caller);
    }

    private void compareConstraintModes(SQLSessionContext nested, SQLSessionContext caller) throws StandardException {
        if (this.deferredHashTables == null) {
            return;
        }
        for (DeferredConstraintsMemory.ValidationInfo info : this.deferredHashTables.values()) {
            info.possiblyValidateOnReturn(this, nested, caller);
        }
    }

    @Override
    public boolean isEffectivelyDeferred(SQLSessionContext sc, UUID constraintId) throws StandardException {
        boolean effectivelyDeferred;
        Boolean deferred = sc.isDeferred(constraintId);
        DataDictionary dd = this.getDataDictionary();
        if (deferred != null) {
            effectivelyDeferred = deferred;
        } else {
            ConstraintDescriptor conDesc = dd.getConstraintDescriptor(constraintId);
            effectivelyDeferred = conDesc.initiallyDeferred();
        }
        return effectivelyDeferred;
    }

    @Override
    public void setupSubStatementSessionContext(Activation a) throws StandardException {
        this.setupSessionContextMinion(a, false, false, null);
    }

    @Override
    public SQLSessionContext getTopLevelSQLSessionContext() {
        if (this.topLevelSSC == null) {
            this.topLevelSSC = new SQLSessionContextImpl(this.getInitialDefaultSchemaDescriptor(), this.getSessionUserId());
        }
        return this.topLevelSSC;
    }

    @Override
    public SQLSessionContext createSQLSessionContext() {
        return new SQLSessionContextImpl(this.getInitialDefaultSchemaDescriptor(), this.getSessionUserId());
    }

    @Override
    public Map<Object, Object> getPrintedObjectsMap() {
        if (this.printedObjectsMap == null) {
            this.printedObjectsMap = new IdentityHashMap<Object, Object>();
        }
        return this.printedObjectsMap;
    }

    @Override
    public boolean getXplainOnlyMode() {
        return this.xplainOnlyMode;
    }

    @Override
    public void setXplainOnlyMode(boolean onOrOff) {
        this.xplainOnlyMode = onOrOff;
    }

    @Override
    public String getXplainSchema() {
        return this.xplain_schema;
    }

    @Override
    public void setXplainSchema(String s) {
        this.xplain_schema = s;
    }

    @Override
    public void setXplainStatement(Object key, Object stmt) {
        this.xplain_statements.put(key, stmt);
    }

    @Override
    public Object getXplainStatement(Object key) {
        return this.xplain_statements.get(key);
    }

    @Override
    public void setASTVisitor(ASTVisitor visitor) {
        this.astWalker = visitor;
    }

    @Override
    public ASTVisitor getASTVisitor() {
        return this.astWalker;
    }

    @Override
    public void setInterruptedException(StandardException e) {
        this.interruptedException = e;
    }

    @Override
    public StandardException getInterruptedException() {
        return this.interruptedException;
    }

    @Override
    public FormatableBitSet getReferencedColumnMap(TableDescriptor td) {
        return this.referencedColumnMap.get(td);
    }

    @Override
    public void setReferencedColumnMap(TableDescriptor td, FormatableBitSet map) {
        this.referencedColumnMap.put(td, map);
    }

    @Override
    public void setConstraintDeferred(Activation a, ConstraintDescriptor cd, boolean deferred) throws StandardException {
        if (!deferred) {
            this.validateDeferredConstraint(cd);
        }
        this.getCurrentSQLSessionContext(a).setDeferred(cd.getUUID(), deferred);
    }

    @Override
    public void checkIntegrity() throws StandardException {
        this.validateDeferredConstraints(true);
        this.clearDeferreds();
    }

    private void clearDeferreds() {
        this.deferredHashTables = null;
        this.getCurrentSQLSessionContext().resetConstraintModes();
    }

    @Override
    public void setDeferredAll(Activation a, boolean deferred) throws StandardException {
        if (!deferred) {
            this.validateDeferredConstraints(false);
        }
        this.getCurrentSQLSessionContext(a).setDeferredAll(deferred);
    }

    @Override
    public HashMap<UUID, DeferredConstraintsMemory.ValidationInfo> getDeferredHashTables() {
        if (this.deferredHashTables == null) {
            this.deferredHashTables = new HashMap();
        }
        return this.deferredHashTables;
    }

    private void validateDeferredConstraints(boolean rollbackOnError) throws StandardException {
        if (this.deferredHashTables == null) {
            return;
        }
        for (DeferredConstraintsMemory.ValidationInfo info : this.deferredHashTables.values()) {
            info.validateConstraint(this, null, rollbackOnError);
        }
    }

    private void validateDeferredConstraint(ConstraintDescriptor cd) throws StandardException {
        if (this.deferredHashTables == null) {
            return;
        }
        UUID key = cd.hasBackingIndex() ? cd.getUUID() : cd.getTableId();
        DeferredConstraintsMemory.ValidationInfo vi = this.deferredHashTables.get(key);
        if (vi == null) {
            return;
        }
        vi.validateConstraint(this, cd.getUUID(), false);
    }
}

