/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.UnaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class IsNullNode
extends UnaryComparisonOperatorNode
implements RelationalOperator {
    private DataValueDescriptor nullValue;
    private boolean notNull;

    IsNullNode(ValueNode operand, boolean notNull, ContextManager cm) throws StandardException {
        super(operand, cm);
        this.notNull = notNull;
        this.updateOperatorDetails();
    }

    private void updateOperatorDetails() {
        this.setOperator(this.notNull ? "is not null" : "is null");
        this.setMethodName(this.notNull ? "isNotNull" : "isNullOp");
    }

    @Override
    UnaryOperatorNode getNegation(ValueNode operand) throws StandardException {
        SanityManager.ASSERT(this.getTypeServices() != null, "dataTypeServices is expected to be non-null");
        this.notNull = !this.notNull;
        this.updateOperatorDetails();
        return this;
    }

    @Override
    void bindParameter() throws StandardException {
        this.operand.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), true));
    }

    @Override
    public boolean usefulStartKey(Optimizable optTable) {
        return this.isNullNode();
    }

    @Override
    public boolean usefulStopKey(Optimizable optTable) {
        return this.isNullNode();
    }

    @Override
    public int getStartOperator(Optimizable optTable) {
        if (this.notNull) {
            SanityManager.THROWASSERT("NOT NULL not expected here");
        }
        return 1;
    }

    @Override
    public int getStopOperator(Optimizable optTable) {
        if (this.notNull) {
            SanityManager.THROWASSERT("NOT NULL not expected here");
        }
        return -1;
    }

    @Override
    public void generateOperator(MethodBuilder mb, Optimizable optTable) {
        mb.push(2);
    }

    @Override
    public void generateNegate(MethodBuilder mb, Optimizable optTable) {
        mb.push(this.notNull);
    }

    @Override
    public int getOperator() {
        return this.notNull ? 8 : 7;
    }

    @Override
    public boolean compareWithKnownConstant(Optimizable optTable, boolean considerParameters) {
        return true;
    }

    @Override
    public DataValueDescriptor getCompareValue(Optimizable optTable) throws StandardException {
        if (this.nullValue == null) {
            this.nullValue = this.operand.getTypeServices().getNull();
        }
        return this.nullValue;
    }

    @Override
    public boolean equalsComparisonWithConstantExpression(Optimizable optTable) {
        if (this.notNull) {
            return false;
        }
        boolean retval = false;
        if (this.operand instanceof ColumnReference) {
            int tabNum = ((ColumnReference)this.operand).getTableNumber();
            if (optTable.hasTableNumber() && optTable.getTableNumber() == tabNum) {
                retval = true;
            }
        }
        return retval;
    }

    @Override
    public RelationalOperator getTransitiveSearchClause(ColumnReference otherCR) throws StandardException {
        return new IsNullNode(otherCR, this.notNull, this.getContextManager());
    }

    @Override
    String getReceiverInterfaceName() {
        return "org.apache.derby.iapi.types.DataValueDescriptor";
    }

    @Override
    public double selectivity(Optimizable optTable) {
        if (this.notNull) {
            return 0.9;
        }
        return 0.1;
    }

    boolean isNullNode() {
        return !this.notNull;
    }

    @Override
    boolean isRelationalOperator() {
        return true;
    }

    @Override
    boolean optimizableEqualityNode(Optimizable optTable, int columnNumber, boolean isNullOkay) {
        if (!this.isNullNode() || !isNullOkay) {
            return false;
        }
        ColumnReference cr = this.getColumnOperand(optTable, columnNumber);
        return cr != null;
    }
}

