/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.Statement;
import org.apache.derby.iapi.sql.StorablePreparedStatement;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.sql.CursorInfo;
import org.apache.derby.impl.sql.GenericPreparedStatement;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.util.ArrayUtil;

public class GenericStorablePreparedStatement
extends GenericPreparedStatement
implements Formatable,
StorablePreparedStatement {
    private ByteArray byteCode;
    private String className;

    public GenericStorablePreparedStatement() {
    }

    GenericStorablePreparedStatement(Statement stmt) {
        super(stmt);
    }

    @Override
    ByteArray getByteCodeSaver() {
        if (this.byteCode == null) {
            this.byteCode = new ByteArray();
        }
        return this.byteCode;
    }

    @Override
    public GeneratedClass getActivationClass() throws StandardException {
        if (this.activationClass == null) {
            this.loadGeneratedClass();
        }
        return this.activationClass;
    }

    @Override
    void setActivationClass(GeneratedClass ac) {
        super.setActivationClass(ac);
        if (ac != null) {
            this.className = ac.getName();
            if (this.byteCode != null && this.byteCode.getArray() == null) {
                this.byteCode = null;
            }
        }
    }

    @Override
    public void loadGeneratedClass() throws StandardException {
        LanguageConnectionContext lcc = (LanguageConnectionContext)GenericStorablePreparedStatement.getContext("LanguageConnectionContext");
        ClassFactory classFactory = lcc.getLanguageConnectionFactory().getClassFactory();
        GeneratedClass gc = classFactory.loadGeneratedClass(this.className, this.byteCode);
        this.setActivationClass(gc);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getCursorInfo());
        out.writeBoolean(this.needsSavepoint());
        out.writeBoolean(this.isAtomic);
        out.writeObject(this.executionConstants);
        out.writeObject(this.resultDesc);
        if (this.savedObjects == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            ArrayUtil.writeArrayLength(out, this.savedObjects);
            ArrayUtil.writeArrayItems(out, this.savedObjects);
        }
        out.writeObject(this.className);
        out.writeBoolean(this.byteCode != null);
        if (this.byteCode != null) {
            this.byteCode.writeExternal(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setCursorInfo((CursorInfo)in.readObject());
        this.setNeedsSavepoint(in.readBoolean());
        this.isAtomic = in.readBoolean();
        this.executionConstants = (ConstantAction)in.readObject();
        this.resultDesc = (ResultDescription)in.readObject();
        if (in.readBoolean()) {
            this.savedObjects = new Object[ArrayUtil.readArrayLength(in)];
            ArrayUtil.readArrayItems(in, this.savedObjects);
        }
        this.className = (String)in.readObject();
        if (in.readBoolean()) {
            this.byteCode = new ByteArray();
            this.byteCode.readExternal(in);
        } else {
            this.byteCode = null;
        }
    }

    @Override
    public int getTypeFormatId() {
        return 225;
    }

    @Override
    public boolean isStorable() {
        return true;
    }

    @Override
    public String toString() {
        String acn = this.activationClass == null ? "null" : this.activationClass.getName();
        return "GSPS " + System.identityHashCode(this) + " activationClassName=" + acn + " className=" + this.className;
    }

    private static Context getContext(String contextID) {
        return ContextService.getContext(contextID);
    }
}

