/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.sql.Clob;
import java.text.RuleBasedCollator;
import org.apache.derby.iapi.types.CollatorSQLVarchar;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class SQLVarchar
extends SQLChar {
    @Override
    public String getTypeName() {
        return "VARCHAR";
    }

    @Override
    public DataValueDescriptor cloneValue(boolean forceMaterialization) {
        try {
            return new SQLVarchar(this.getString());
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT("Unexpected exception", se);
            return null;
        }
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLVarchar();
    }

    @Override
    public StringDataValue getValue(RuleBasedCollator collatorForComparison) {
        if (collatorForComparison == null) {
            return this;
        }
        CollatorSQLVarchar s = new CollatorSQLVarchar(collatorForComparison);
        s.copyState(this);
        return s;
    }

    @Override
    public int getTypeFormatId() {
        return 85;
    }

    public SQLVarchar() {
    }

    public SQLVarchar(String val) {
        super(val);
    }

    public SQLVarchar(Clob val) {
        super(val);
    }

    public SQLVarchar(char[] val) {
        super(val);
    }

    @Override
    public void normalize(DataTypeDescriptor desiredType, DataValueDescriptor source) throws StandardException {
        this.normalize(desiredType, source.getString());
    }

    @Override
    protected void normalize(DataTypeDescriptor desiredType, String sourceValue) throws StandardException {
        int desiredWidth = desiredType.getMaximumWidth();
        int sourceWidth = sourceValue.length();
        if (sourceWidth > desiredWidth) {
            this.hasNonBlankChars(sourceValue, desiredWidth, sourceWidth);
            sourceValue = sourceValue.substring(0, desiredWidth);
        }
        this.setValue(sourceValue);
    }

    @Override
    public int typePrecedence() {
        return 10;
    }

    @Override
    protected final int growBy() {
        return 4096;
    }
}

