/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.debug.ui.config;

import com.ibm.icu.text.Collator;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.ecommons.debug.ui.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public class LaunchConfigUtils {
    public static boolean isActiveTabGroup(ILaunchConfigurationDialog dialog, ILaunchConfigurationTab tab) {
        ILaunchConfigurationTab[] tabs = dialog.getTabs();
        if (tabs != null) {
            int i = 0;
            while (i < tabs.length) {
                if (tabs[i] == tab) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static void launchResourceRefresh(ILaunchConfiguration configuration, IProcess process, IProgressMonitor monitor) throws CoreException {
        block7: {
            if (!CommonTab.isLaunchInBackground((ILaunchConfiguration)configuration)) ** GOTO lbl13
            if (RefreshTab.getRefreshScope((ILaunchConfiguration)configuration) == null) break block7;
            new BackgroundResourceRefresher(configuration, process);
            break block7;
lbl-1000:
            // 1 sources

            {
                try {
                    if (monitor.isCanceled()) {
                        process.terminate();
                        break;
                    }
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException var3_3) {
                    // empty catch block
                }
lbl13:
                // 3 sources

                ** while (!process.isTerminated())
            }
lbl14:
            // 2 sources

            RefreshTab.refreshResources((ILaunchConfiguration)configuration, (IProgressMonitor)monitor);
        }
    }

    private LaunchConfigUtils() {
    }

    private static class BackgroundResourceRefresher
    implements IDebugEventSetListener {
        private final ILaunchConfiguration configuration;
        private @Nullable IProcess process;

        public BackgroundResourceRefresher(ILaunchConfiguration configuration, IProcess process) {
            this.configuration = configuration;
            this.process = process;
            this.initialize();
        }

        private synchronized void initialize() {
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
            IProcess process = this.process;
            if (process != null && process.isTerminated()) {
                this.sheduleRefresh();
            }
        }

        public void handleDebugEvents(DebugEvent[] events) {
            int i = 0;
            while (i < events.length) {
                DebugEvent event = events[i];
                if (event.getSource() == this.process && event.getKind() == 8) {
                    this.sheduleRefresh();
                    return;
                }
                ++i;
            }
        }

        protected synchronized void sheduleRefresh() {
            if (this.process != null) {
                DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                this.process = null;
                Job job = new Job(Messages.BackgroundResourceRefresher_Job_name){

                    public IStatus run(IProgressMonitor monitor) {
                        try {
                            RefreshTab.refreshResources((ILaunchConfiguration)configuration, (IProgressMonitor)monitor);
                        }
                        catch (CoreException e) {
                            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.debug.ui", 0, NLS.bind((String)"An error occurred when refreshing resources for launch configuration ''{0}''.", (Object)configuration.getName()), (Throwable)e));
                            return e.getStatus();
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        }
    }

    public static class LaunchConfigurationComparator
    implements Comparator<ILaunchConfiguration> {
        private final Collator collator = Collator.getInstance();

        @Override
        public int compare(ILaunchConfiguration c1, ILaunchConfiguration c2) {
            return this.collator.compare(c1.getName(), c2.getName());
        }
    }
}

