/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.io;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.statet.jcommons.io.ArchiveUrl;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public abstract class AbstractArchiveUriUrl
implements ArchiveUrl {
    private final URI url;
    private volatile @Nullable URI outerArchiveUrl;
    private volatile @Nullable String pathString;

    public AbstractArchiveUriUrl(URI url) {
        this.url = url;
    }

    @Override
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public final String getUrlString() {
        return this.url.toString();
    }

    @Override
    public final URI getOuterArchiveUrl() throws URISyntaxException {
        URI url = this.outerArchiveUrl;
        if (url == null) {
            this.outerArchiveUrl = url = this.createOuterArchiveUrl(this.url);
        }
        return url;
    }

    protected abstract URI createOuterArchiveUrl(URI var1) throws URISyntaxException;

    @Override
    public final String getOuterArchiveUrlString() throws URISyntaxException {
        return this.getOuterArchiveUrl().toString();
    }

    @Override
    public final String getInnerEntryPathString() {
        String s = this.pathString;
        if (s == null) {
            this.pathString = s = this.createEntryPath(this.url);
        }
        return s;
    }

    protected abstract String createEntryPath(URI var1);

    public String toString() {
        return this.getUrlString();
    }
}

