/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.print;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.statet.ecommons.waltable.Messages;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.core.layer.ClientAreaProvider;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerPainter;
import org.eclipse.statet.ecommons.waltable.core.swt.SwtUtils;
import org.eclipse.statet.ecommons.waltable.print.PrintEntireGridCommand;
import org.eclipse.statet.ecommons.waltable.print.TurnViewportOffCommand;
import org.eclipse.statet.ecommons.waltable.print.TurnViewportOnCommand;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LayerPrinter {
    private final ConfigRegistry configRegistry;
    private final Layer layer;
    private final ClientAreaProvider originalClientAreaProvider;
    public static final int FOOTER_HEIGHT_IN_PRINTER_DPI = 300;
    final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm a");
    private final String footerDate;

    public LayerPrinter(Layer layer, ConfigRegistry configRegistry) {
        this.layer = layer;
        this.configRegistry = configRegistry;
        this.originalClientAreaProvider = layer.getClientAreaProvider();
        this.footerDate = this.dateFormat.format(new Date());
    }

    private Point computeScaleFactor(Printer printer) {
        Point screenDPI = Display.getDefault().getDPI();
        Point printerDPI = printer.getDPI();
        int scaleFactorX = printerDPI.x / screenDPI.x;
        int scaleFactorY = printerDPI.y / screenDPI.y;
        return new Point(scaleFactorX, scaleFactorY);
    }

    private LRectangle getTotalArea() {
        return new LRectangle(0L, 0L, this.layer.getWidth(), this.layer.getHeight());
    }

    private Point getPageCount(Printer printer) {
        LRectangle layerArea = this.getTotalArea();
        LRectangle printArea = this.computePrintArea(printer);
        Point scaleFactor = this.computeScaleFactor(printer);
        int numOfHorizontalPages = (int)(layerArea.width / (printArea.width / (long)scaleFactor.x));
        int numOfVerticalPages = (int)(layerArea.height / (printArea.height / (long)scaleFactor.y));
        return new Point(numOfHorizontalPages + 1, numOfVerticalPages + 1);
    }

    public void print(Shell shell) {
        this.layer.doCommand(new TurnViewportOffCommand());
        Printer printer = this.setupPrinter(shell);
        if (printer == null) {
            return;
        }
        this.layer.doCommand(new TurnViewportOnCommand());
        Display.getDefault().asyncExec((Runnable)new PrintJob(printer));
    }

    private boolean shouldPrint(PrinterData printerData, int totalPageCount) {
        if (printerData.scope == 1) {
            return totalPageCount >= printerData.startPage && totalPageCount <= printerData.endPage;
        }
        return true;
    }

    private Printer setupPrinter(Shell shell) {
        Printer defaultPrinter = new Printer();
        Point pageCount = this.getPageCount(defaultPrinter);
        defaultPrinter.dispose();
        PrintDialog printDialog = new PrintDialog(shell);
        printDialog.setStartPage(1);
        printDialog.setEndPage(pageCount.x * pageCount.y);
        printDialog.setScope(0);
        PrinterData printerData = printDialog.open();
        if (printerData == null) {
            return null;
        }
        return new Printer(printerData);
    }

    private LRectangle computePrintArea(Printer printer) {
        int bottom;
        int top;
        int right;
        Rectangle rect = printer.getClientArea();
        Rectangle trim = printer.computeTrim(0, 0, 0, 0);
        Point dpi = printer.getDPI();
        dpi.x /= 2;
        dpi.y /= 2;
        int left = trim.x + dpi.x;
        if (left < rect.x) {
            left = rect.x;
        }
        if ((right = rect.width + trim.x + trim.width - dpi.x) > rect.width) {
            right = rect.width;
        }
        if ((top = trim.y + dpi.y) < rect.y) {
            top = rect.y;
        }
        if ((bottom = rect.height + trim.y + trim.height - dpi.y) > rect.height) {
            bottom = rect.height;
        }
        return new LRectangle(left, top, right - left, bottom - top);
    }

    private class PrintJob
    implements Runnable {
        private final Printer printer;

        private PrintJob(Printer printer) {
            this.printer = printer;
        }

        @Override
        public void run() {
            if (this.printer.startJob("NatTable")) {
                LayerPrinter.this.layer.doCommand(new TurnViewportOffCommand());
                this.setLayerSize(this.printer.getPrinterData());
                LRectangle printerClientArea = LayerPrinter.this.computePrintArea(this.printer);
                Point scaleFactor = LayerPrinter.this.computeScaleFactor(this.printer);
                Point pageCount = LayerPrinter.this.getPageCount(this.printer);
                GC gc = new GC((Drawable)this.printer);
                int currentPage = 1;
                int verticalPageNumber = 0;
                while (verticalPageNumber < pageCount.y) {
                    int horizontalPageNumber = 0;
                    while (horizontalPageNumber < pageCount.x) {
                        Rectangle printBounds = SwtUtils.toSWT(new LRectangle(printerClientArea.width / (long)scaleFactor.x * (long)horizontalPageNumber, (printerClientArea.height - 300L) / (long)scaleFactor.y * (long)verticalPageNumber, printerClientArea.width / (long)scaleFactor.x, (printerClientArea.height - 300L) / (long)scaleFactor.y));
                        if (LayerPrinter.this.shouldPrint(this.printer.getPrinterData(), currentPage)) {
                            this.printer.startPage();
                            Transform printerTransform = new Transform((Device)this.printer);
                            printerTransform.scale((float)scaleFactor.x, (float)scaleFactor.y);
                            printerTransform.translate((float)(printerClientArea.x / (long)scaleFactor.x), (float)(printerClientArea.y / (long)scaleFactor.y));
                            printerTransform.translate((float)(-1 * printBounds.x), (float)(-1 * printBounds.y));
                            gc.setTransform(printerTransform);
                            this.printLayer(gc, printBounds);
                            this.printFooter(gc, currentPage, printBounds);
                            this.printer.endPage();
                            printerTransform.dispose();
                        }
                        ++currentPage;
                        ++horizontalPageNumber;
                    }
                    ++verticalPageNumber;
                }
                this.printer.endJob();
                gc.dispose();
                this.printer.dispose();
            }
            this.restoreLayerState();
        }

        private void setLayerSize(PrinterData printerData) {
            if (printerData.scope == 2) {
                LayerPrinter.this.layer.setClientAreaProvider(LayerPrinter.this.originalClientAreaProvider);
            } else {
                final LRectangle fullLayerSize = LayerPrinter.this.getTotalArea();
                LayerPrinter.this.layer.setClientAreaProvider(new ClientAreaProvider(){

                    @Override
                    public LRectangle getClientArea() {
                        return fullLayerSize;
                    }
                });
                LayerPrinter.this.layer.doCommand(new PrintEntireGridCommand());
            }
        }

        private void printLayer(GC gc, Rectangle printBounds) {
            LayerPainter layerPainter = LayerPrinter.this.layer.getLayerPainter();
            layerPainter.paintLayer(LayerPrinter.this.layer, gc, 0, 0, printBounds, LayerPrinter.this.configRegistry);
        }

        private void printFooter(GC gc, int totalPageCount, Rectangle printBounds) {
            gc.setForeground(Display.getCurrent().getSystemColor(2));
            gc.setBackground(Display.getCurrent().getSystemColor(1));
            gc.drawLine(printBounds.x, printBounds.y + printBounds.height + 10, printBounds.x + printBounds.width, printBounds.y + printBounds.height + 10);
            gc.drawText(Messages.getString("Printer.page") + " " + totalPageCount, printBounds.x, printBounds.y + printBounds.height + 15);
            gc.drawText(LayerPrinter.this.footerDate, printBounds.x + printBounds.width - 140, printBounds.y + printBounds.height + 15);
        }

        private void restoreLayerState() {
            LayerPrinter.this.layer.setClientAreaProvider(LayerPrinter.this.originalClientAreaProvider);
            LayerPrinter.this.layer.doCommand(new TurnViewportOnCommand());
        }
    }
}

