/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.core.layer.events;

import java.util.List;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerDim;
import org.eclipse.statet.ecommons.waltable.core.layer.events.VisualChangeEvent;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class DimPositionsVisualChangeEvent
implements VisualChangeEvent {
    private final LayerDim layerDim;
    private final List<LRange> positions;

    public DimPositionsVisualChangeEvent(LayerDim layerDim, List<LRange> positions) {
        this.layerDim = layerDim;
        this.positions = positions;
    }

    public DimPositionsVisualChangeEvent(LayerDim layerDim, LRange positionRanges) {
        this.layerDim = layerDim;
        this.positions = ImCollections.newList((Object)positionRanges);
    }

    @Override
    public @Nullable DimPositionsVisualChangeEvent toLayer(Layer targetLayer) {
        LayerDim targetLayerDim = targetLayer.getDim(this.getOrientation());
        if (targetLayerDim == this.layerDim) {
            return this;
        }
        List<LRange> positionRanges = targetLayerDim.underlyingToLocalPositions(this.layerDim, this.positions);
        return positionRanges != null && positionRanges.size() > 0 ? this.toLayer(targetLayerDim, positionRanges) : null;
    }

    protected @Nullable DimPositionsVisualChangeEvent toLayer(LayerDim targetLayerDim, List<LRange> positionRanges) {
        return new DimPositionsVisualChangeEvent(targetLayerDim, positionRanges);
    }

    public final LayerDim getLayerDim() {
        return this.layerDim;
    }

    public final Orientation getOrientation() {
        return this.layerDim.getOrientation();
    }

    @Override
    public final Layer getLayer() {
        return this.layerDim.getLayer();
    }

    public List<LRange> getPositionRanges() {
        return this.positions;
    }

    public ImList<LRectangle> getChangedPositionRectangles() {
        List<LRange> columnPositionRanges = this.getPositionRanges();
        Object[] positionRectangles = new LRectangle[columnPositionRanges.size()];
        switch (this.getOrientation()) {
            case HORIZONTAL: {
                long positionCount = this.getLayer().getDim(Orientation.VERTICAL).getPositionCount();
                int i = 0;
                while (i < positionRectangles.length) {
                    LRange range = columnPositionRanges.get(i);
                    positionRectangles[i] = new LRectangle(range.start, 0L, range.end - range.start, positionCount);
                    ++i;
                }
                break;
            }
            case VERTICAL: {
                long positionCount = this.getLayer().getDim(Orientation.HORIZONTAL).getPositionCount();
                int i = 0;
                while (i < positionRectangles.length) {
                    LRange range = columnPositionRanges.get(i);
                    positionRectangles[i] = new LRectangle(0L, range.start, positionCount, range.end - range.start);
                    ++i;
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return ImCollections.newList((Object[])positionRectangles);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

