/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.dsl.dcf.core.source;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.ltk.core.source.StatusDetail;

@NonNullByDefault
public class DcfLexer {
    public static final byte EOF = -1;
    protected static final byte NONE = 0;
    public static final byte LINEBREAK = 1;
    public static final byte UNKNOWN = 2;
    public static final byte BLANK_LINE = 3;
    public static final byte FIELD_NAME = 4;
    public static final byte VALUE = 5;
    public static final byte VALUE_EMPTY_LINE = 6;
    private TextParserInput input;
    private byte foundType;
    private int foundFlags;
    private @Nullable StatusDetail foundDetail;
    private int foundOffset;
    private int foundNum;
    private int foundTextNum;
    private int foundLength;
    private boolean isCol0;
    private int col0Offset;

    public DcfLexer(TextParserInput input) {
        this();
        this.reset(input);
    }

    public DcfLexer() {
    }

    public void reset() {
        this.foundType = 0;
        this.foundFlags = 0;
        this.foundDetail = null;
        this.foundOffset = this.input.getIndex();
        this.foundNum = 0;
        this.foundLength = 0;
        this.isCol0 = true;
    }

    public void reset(TextParserInput input) {
        this.input = input;
        this.reset();
    }

    public final TextParserInput getInput() {
        return this.input;
    }

    private void foundEOF(TextParserInput in, int startOffset) {
        this.foundType = (byte)-1;
        this.foundFlags = 0;
        this.foundDetail = null;
        if (startOffset > 0) {
            this.input.consume(startOffset);
            this.foundOffset = this.input.getIndex();
        }
        this.foundNum = 0;
        this.foundLength = in.getLengthInSource(0);
    }

    private void foundLinebreak(TextParserInput in, int startOffset, int n) {
        this.foundType = 1;
        this.foundFlags = 0;
        this.foundDetail = null;
        if (startOffset > 0) {
            this.input.consume(startOffset);
            this.foundOffset = this.input.getIndex();
        }
        this.foundNum = n;
        this.foundLength = in.getLengthInSource(this.foundNum);
        this.isCol0 = true;
    }

    private void foundBlankLine(TextParserInput in, int n) {
        this.foundType = (byte)3;
        this.foundFlags = 0;
        this.foundDetail = null;
        this.foundNum = n;
        this.foundLength = in.getLengthInSource(this.foundNum);
        this.isCol0 = true;
    }

    private void foundUnknown(TextParserInput in, int n) {
        this.foundType = (byte)2;
        this.foundFlags = 0;
        this.foundDetail = null;
        this.foundNum = n;
        this.foundLength = in.getLengthInSource(this.foundNum);
    }

    private void foundName(TextParserInput in, int n) {
        this.foundType = (byte)4;
        this.foundFlags = 0;
        this.foundDetail = null;
        this.foundNum = n;
        this.foundLength = in.getLengthInSource(this.foundNum);
    }

    private void foundName(TextParserInput in, int flags, int n) {
        this.foundType = (byte)4;
        this.foundFlags = flags;
        this.foundDetail = null;
        this.foundNum = n;
        this.foundLength = in.getLengthInSource(this.foundNum);
    }

    private void foundValue(TextParserInput in, byte type, int startOffset, int endOffset, int n) {
        this.foundType = type;
        this.foundFlags = 0;
        this.foundDetail = null;
        if (startOffset > 0) {
            in.consume(startOffset);
            int diff = in.getIndex() - this.foundOffset;
            this.foundOffset += diff;
            endOffset -= diff;
            n -= diff;
        }
        this.foundNum = n;
        this.foundTextNum = endOffset;
        this.foundLength = in.getLengthInSource(this.foundTextNum);
    }

    public byte next() {
        this.foundType = 0;
        while (this.foundType == 0) {
            this.input.consume(this.foundNum);
            this.foundOffset = this.input.getIndex();
            if (this.isCol0) {
                this.searchRoot0();
                continue;
            }
            this.searchCont();
        }
        return this.foundType;
    }

    public final int getType() {
        return this.foundType;
    }

    public final int getFlags() {
        return this.foundFlags;
    }

    public final @Nullable StatusDetail getStatusDetail() {
        return this.foundDetail;
    }

    public final int getOffset() {
        return this.foundOffset;
    }

    public final int getLength() {
        return this.foundLength;
    }

    public final int getEndOffset() {
        return this.foundOffset + this.foundLength;
    }

    public final int getLineStartOffset() {
        return this.col0Offset;
    }

    public final @Nullable String getText() {
        switch (this.foundType) {
            case 1: {
                return "\n";
            }
            case 4: {
                return switch (this.foundFlags & 0x700FF0) {
                    case 4195088 -> null;
                    default -> this.input.getString(0, this.foundNum - 1);
                };
            }
            case 5: {
                return this.input.getString(0, this.foundTextNum);
            }
            case 6: {
                return "";
            }
            case 2: {
                return this.input.getString(0, this.foundNum);
            }
        }
        return null;
    }

    private final void searchRoot0() {
        TextParserInput in = this.input;
        this.isCol0 = false;
        this.col0Offset = in.getIndex();
        int n = 0;
        block6: while (true) {
            switch (this.input.get(n)) {
                case -1: {
                    this.foundEOF(in, n);
                    return;
                }
                case 13: {
                    if (this.input.get(n + 1) == 10) {
                        this.foundBlankLine(in, n + 2);
                        return;
                    }
                }
                case 10: {
                    this.foundBlankLine(in, n + 1);
                    return;
                }
                case 9: 
                case 32: {
                    ++n;
                    continue block6;
                }
            }
            break;
        }
        if (n == 0) {
            this.readFieldName(in);
            return;
        }
        this.readFieldValue(in, n, true);
    }

    private void searchCont() {
        TextParserInput in = this.input;
        int n = 0;
        block6: while (true) {
            switch (in.get(n)) {
                case -1: {
                    this.foundEOF(in, n);
                    return;
                }
                case 13: {
                    if (in.get(n + 1) == 10) {
                        this.foundLinebreak(in, n, 2);
                        return;
                    }
                }
                case 10: {
                    this.foundLinebreak(in, n, 1);
                    return;
                }
                case 9: 
                case 32: {
                    ++n;
                    continue block6;
                }
            }
            break;
        }
        this.readFieldValue(in, n, false);
    }

    private void readFieldName(TextParserInput in) {
        int n = 0;
        while (true) {
            switch (this.input.get(n++)) {
                case -1: 
                case 10: 
                case 13: {
                    this.foundUnknown(in, n - 1);
                    return;
                }
                case 58: {
                    if (n == 1) {
                        this.foundName(in, 4653840, 1);
                        return;
                    }
                    this.foundName(in, n);
                    return;
                }
            }
        }
    }

    private void readFieldValue(TextParserInput in, int start, boolean contLine) {
        int n;
        int end = n = start;
        if (contLine) {
            block14: while (true) {
                switch (this.input.get(n)) {
                    case 9: 
                    case 32: {
                        ++n;
                        continue block14;
                    }
                    case 11: 
                    case 12: {
                        end = ++n;
                        continue block14;
                    }
                    case 46: {
                        int dot = n++;
                        end = n;
                        block15: while (true) {
                            switch (this.input.get(n++)) {
                                case -1: 
                                case 10: 
                                case 13: {
                                    this.foundValue(in, (byte)6, dot, dot + 1, n - 1);
                                    return;
                                }
                                case 9: 
                                case 32: {
                                    continue block15;
                                }
                                case 11: 
                                case 12: {
                                    end = n;
                                    continue block15;
                                }
                            }
                            break;
                        }
                        end = n;
                        break block14;
                    }
                }
                break;
            }
        }
        block16: while (true) {
            switch (this.input.get(n++)) {
                case -1: 
                case 10: 
                case 13: {
                    this.foundValue(in, (byte)5, start, end, n - 1);
                    return;
                }
                case 9: 
                case 32: {
                    continue block16;
                }
            }
            end = n;
        }
    }
}

