/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.dsl.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.dsl.core.source.ast.DslAstNode;
import org.eclipse.statet.dsl.core.source.ast.DslAstVisitor;
import org.eclipse.statet.dsl.core.source.ast.NodeType;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.ltk.ast.core.Asts;

@NonNullByDefault
public abstract class KeyValuePair
extends DslAstNode {
    DslAstNode keyChild;
    DslAstNode valueChild;

    protected KeyValuePair(int statusCode, DslAstNode parent) {
        super(statusCode, parent);
    }

    protected KeyValuePair(DslAstNode parent) {
        super(parent);
    }

    protected final void doSetKeyChild(DslAstNode node) {
        this.keyChild = node;
    }

    protected final void doSetValueChild(DslAstNode node) {
        this.valueChild = node;
    }

    @Override
    protected void finish(int endOffset) {
        super.finish(endOffset);
        this.doSetEndOffsetMin(Math.max(endOffset, this.valueChild.getEndOffset()));
    }

    @Override
    protected boolean hasErrorInChild() {
        return Asts.hasErrors((AstNode)this.keyChild) || Asts.hasErrors((AstNode)this.valueChild);
    }

    @Override
    public final NodeType getNodeType() {
        return NodeType.KEY_VALUE_ENTRY;
    }

    public abstract int getKeyIndicatorOffset();

    public abstract int getValueIndicatorOffset();

    @Override
    public final boolean hasChildren() {
        return true;
    }

    @Override
    public final int getChildCount() {
        return 2;
    }

    public final DslAstNode getKey() {
        return this.keyChild;
    }

    public final DslAstNode getValue() {
        return this.valueChild;
    }

    @Override
    public final DslAstNode getChild(int index) {
        return switch (index) {
            case 0 -> this.keyChild;
            case 1 -> this.valueChild;
            default -> throw new IndexOutOfBoundsException(Integer.toString(index));
        };
    }

    @Override
    public final int getChildIndex(AstNode child) {
        if (child == this.keyChild) {
            return 0;
        }
        if (child == this.valueChild) {
            return 1;
        }
        return -1;
    }

    public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        visitor.visit((AstNode)this.keyChild);
        visitor.visit((AstNode)this.valueChild);
    }

    @Override
    public final void acceptInDsl(DslAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public final void acceptInDslChildren(DslAstVisitor visitor) throws InvocationTargetException {
        this.keyChild.acceptInDsl(visitor);
        this.valueChild.acceptInDsl(visitor);
    }
}

