/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.debug.ui.util;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.statet.ecommons.debug.core.util.LaunchUtils;
import org.eclipse.statet.ecommons.debug.ui.util.ProcessOutputCollector;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.ecommons.debug.ui.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class HelpRequestor
implements IRunnableWithProgress {
    private final TrayDialog fDialog;
    private final ProcessBuilder fBuilder;
    boolean fIsRunning;

    public static void closeHelpTray(TrayDialog dialog) {
        if (dialog.getTray() instanceof InfoTray) {
            dialog.closeTray();
        }
    }

    public HelpRequestor(ProcessBuilder processBuilder, TrayDialog dialog) {
        this.fBuilder = processBuilder;
        this.fDialog = dialog;
    }

    public ProcessBuilder getProcessBuilder() {
        return this.fBuilder;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        final String cmdInfo = LaunchUtils.generateCommandLine(this.fBuilder.command());
        monitor.beginTask(Messages.HelpRequestor_Task_name + cmdInfo, 10);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            try {
                this.fBuilder.redirectErrorStream(true);
                monitor.worked(1);
                ProcessOutputCollector reader = new ProcessOutputCollector(this.fBuilder, "'--help'", monitor);
                final String helpText = reader.collect();
                UIAccess.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        InfoTray tray = null;
                        if (HelpRequestor.this.fDialog.getTray() instanceof InfoTray) {
                            tray = (InfoTray)HelpRequestor.this.fDialog.getTray();
                        } else {
                            if (HelpRequestor.this.fDialog.getTray() != null) {
                                HelpRequestor.this.fDialog.closeTray();
                            }
                            tray = new InfoTray(HelpRequestor.this.fDialog);
                            HelpRequestor.this.fDialog.openTray((DialogTray)tray);
                        }
                        tray.update(cmdInfo, helpText);
                    }
                });
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    private static class InfoTray
    extends DialogTray {
        private final TrayDialog fDialog;
        private Text fTextControl;
        private Label fCmdInfo;

        private InfoTray(TrayDialog dialog) {
            this.fDialog = dialog;
        }

        protected Control createContents(Composite parent) {
            final FormToolkit toolkit = new FormToolkit(parent.getDisplay());
            Composite container = new Composite(parent, 0);
            container.addListener(12, new Listener(){

                public void handleEvent(Event event) {
                    toolkit.dispose();
                }
            });
            container.setLayout((Layout)new FillLayout(512));
            Form form = toolkit.createForm(container);
            toolkit.decorateFormHeading(form);
            form.setText("'--help'");
            form.getToolBarManager().add((IContributionItem)new ContributionItem(){

                public void fill(ToolBar parent, int index) {
                    ToolItem item = new ToolItem(parent, 8);
                    item.setImage(SharedUIResources.getImages().get("org.eclipse.statet.ecommons.uimisc/images/loctool/close"));
                    item.setHotImage(SharedUIResources.getImages().get("org.eclipse.statet.ecommons.uimisc/images/loctoolh/close"));
                    item.setToolTipText(Messages.HelpRequestor_Close_tooltip);
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            fDialog.closeTray();
                            fDialog.getShell().setFocus();
                        }
                    });
                }
            });
            form.getToolBarManager().update(true);
            Composite content = form.getBody();
            content.setLayout((Layout)new GridLayout());
            this.fCmdInfo = toolkit.createLabel(content, ">");
            this.fCmdInfo.setLayoutData((Object)new GridData(4, 4, true, false));
            this.fTextControl = toolkit.createText(content, "", 778);
            this.fTextControl.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
            GridData gd = new GridData(4, 4, true, true);
            gd.widthHint = new PixelConverter((Control)this.fTextControl).convertWidthInCharsToPixels(50);
            this.fTextControl.setLayoutData((Object)gd);
            return container;
        }

        public void update(String cmdInfo, String text) {
            this.fCmdInfo.setText(cmdInfo);
            this.fTextControl.setText(text);
        }
    }
}

