/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io.vfmem;

import java.io.InputStream;
import org.apache.derby.impl.io.vfmem.BlockedByteArray;

class BlockedByteArrayInputStream
extends InputStream {
    private BlockedByteArray src;
    private long pos;

    public BlockedByteArrayInputStream(BlockedByteArray src, long pos) {
        if (src == null) {
            throw new IllegalArgumentException("BlockedByteArray cannot be null");
        }
        this.src = src;
        this.pos = pos;
    }

    void setPosition(long newPos) {
        this.pos = newPos;
    }

    long getPosition() {
        return this.pos;
    }

    @Override
    public int read() {
        int ret = this.src.read(this.pos);
        if (ret != -1) {
            ++this.pos;
        }
        return ret;
    }

    @Override
    public int read(byte[] buf, int offset, int len) {
        int ret = this.src.read(this.pos, buf, offset, len);
        if (ret != -1) {
            this.pos += (long)ret;
        }
        return ret;
    }

    @Override
    public void close() {
        this.src = null;
    }
}

