/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql;

import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.shared.common.error.StandardException;

public class StatementUtil {
    private static final String[] TypeNames = new String[]{"", "INSERT", "INSERT", "UPDATE", "DELETE", "ENABLED", "DISABLED"};

    private StatementUtil() {
    }

    public static String typeName(int typeNumber) {
        return switch (typeNumber) {
            case 1, 2, 3, 4, 5, 6 -> TypeNames[typeNumber];
            default -> "UNKNOWN";
        };
    }

    public static SchemaDescriptor getSchemaDescriptor(String schemaName, boolean raiseError, DataDictionary dataDictionary, LanguageConnectionContext lcc, CompilerContext cc) throws StandardException {
        SchemaDescriptor sd = null;
        boolean isCurrent = false;
        boolean isCompilation = false;
        if (schemaName == null) {
            sd = cc.getCompilationSchema();
            if (sd == null) {
                sd = lcc.getDefaultSchema();
                isCurrent = true;
                cc.setCompilationSchema(sd);
            } else {
                isCompilation = true;
            }
            schemaName = sd.getSchemaName();
        }
        SchemaDescriptor sdCatalog = dataDictionary.getSchemaDescriptor(schemaName, lcc.getTransactionCompile(), raiseError);
        if (isCurrent || isCompilation) {
            if (sdCatalog != null && sdCatalog.getUUID() != null) {
                if (!sdCatalog.getUUID().equals(sd.getUUID())) {
                    if (isCurrent) {
                        lcc.setDefaultSchema(sdCatalog);
                    }
                    cc.setCompilationSchema(sdCatalog);
                }
            } else {
                sd.setUUID(null);
                sdCatalog = sd;
            }
        }
        return sdCatalog;
    }
}

