/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.statet.docmlet.wikitext.core.source.SourceElementAttributes;
import org.eclipse.statet.docmlet.wikitext.core.source.SourceListAttributes;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonmarkLocator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.FilterLineSequence;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.LineSequence;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockNode;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockType;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlocks;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks.BlockWithNestedBlocks;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks.ParagraphBlock;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks.ThematicBreakBlock;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class ListBlock
extends BlockWithNestedBlocks<ListBlockNode> {
    public static final Pattern PATTERN = Pattern.compile("([*+-]|([0-9]{1,9})[.)])(?:([ \t]+)(.+)?)?", 32);
    private static final int MARKER_GROUP = 1;
    private static final int ORDERED_NUM_GROUP = 2;
    private static final int WHITESPACE_GROUP = 3;
    private static final int CONTENT_GROUP = 4;
    private final Matcher matcher = PATTERN.matcher("");
    private final ThematicBreakBlock thematicBreakBlock = new ThematicBreakBlock();

    public static int computeItemLineIndent(Line line, Matcher matcher) {
        int contentStartColumn;
        int markerEndColumn = line.getColumn(matcher.end(1));
        if (matcher.start(3) != -1 && matcher.start(4) != -1 && (contentStartColumn = line.getColumn(matcher.start(4))) - markerEndColumn <= 4) {
            return contentStartColumn - line.getColumn();
        }
        return markerEndColumn + 1 - line.getColumn();
    }

    @Override
    public boolean canStart(LineSequence lineSequence, @Nullable SourceBlockNode<?> currentNode) {
        Matcher matcher;
        Line currentLine = lineSequence.getCurrentLine();
        return currentLine != null && !currentLine.isBlank() && currentLine.getIndent() < 4 && (matcher = currentLine.setupIndent(this.matcher)).matches() && (currentNode == null || this.canInterrupt(currentLine, matcher, currentNode));
    }

    private boolean canInterrupt(Line startLine, Matcher matcher, SourceBlockNode<?> currentNode) {
        SourceBlockNode<?> parent = currentNode.getParent();
        if (parent != null && parent.getType() instanceof ListItemBlock) {
            return true;
        }
        return this.listStart(startLine, matcher) == null && matcher.start(4) != -1;
    }

    @Override
    public void createNodes(SourceBlocks.SourceBlockBuilder builder) {
        ListBlockNode node = new ListBlockNode(this, builder);
        LineSequence lineSequence = builder.getLineSequence();
        Line startLine = lineSequence.getCurrentLine();
        Matcher matcher = startLine.setupIndent(this.matcher);
        ListBlock.assertMatches(matcher);
        node.bulletType = this.bulletType(startLine, matcher);
        node.listStart = this.listStart(startLine, matcher);
        ListItemBlock itemBlock = new ListItemBlock(node);
        builder.createNestedNodes(new ListLines(lineSequence, builder, itemBlock), ImCollections.newList((Object)itemBlock));
    }

    @Override
    public void emit(ProcessingContext context, ListBlockNode node, CommonmarkLocator locator, DocumentBuilder builder) {
        SourceListAttributes listAttributes = new SourceListAttributes(256);
        listAttributes.setStart(node.listStart);
        ListMode listMode = context.getMode() == 3 ? ListMode.LOOSE : this.calculateListMode(node);
        locator.setBlockBegin(node);
        builder.beginBlock(this.toBlockType(node.bulletType), (Attributes)listAttributes);
        for (SourceBlockNode<ListItemBlock> sourceBlockNode : node.getNested()) {
            ((ListItemBlock)sourceBlockNode.getType()).emit(context, sourceBlockNode, listMode, locator, builder);
        }
        locator.setBlockEnd(node);
        builder.endBlock();
    }

    private ListMode calculateListMode(ListBlockNode listNode) {
        ListMode listMode = ListMode.TIGHT;
        for (SourceBlockNode<?> itemNode : listNode.getNested()) {
            switch (listMode) {
                case LOOSE: 
                case TIGHT_WITH_TRAILING_EMPTY_LINE: {
                    return ListMode.LOOSE;
                }
                case TIGHT: {
                    listMode = this.getListItemListMode(itemNode);
                }
            }
        }
        return listMode == ListMode.TIGHT_WITH_TRAILING_EMPTY_LINE ? ListMode.TIGHT : listMode;
    }

    private ListMode getListItemListMode(SourceBlockNode<?> itemNode) {
        List<SourceBlockNode<?>> contentNodes = itemNode.getNested();
        if (contentNodes.isEmpty()) {
            return ListMode.TIGHT;
        }
        SourceBlockNode<?> block = contentNodes.get(0);
        if (block.isEmpty() && block.getLines().size() > 1) {
            return ListMode.LOOSE;
        }
        int idx = 1;
        while (idx < contentNodes.size() - 1) {
            SourceBlockNode<?> block2 = contentNodes.get(idx);
            if (block2.isEmpty()) {
                return ListMode.LOOSE;
            }
            ++idx;
        }
        if (contentNodes.size() > 1 && (block = contentNodes.get(contentNodes.size() - 1)).isEmpty()) {
            return ListMode.TIGHT_WITH_TRAILING_EMPTY_LINE;
        }
        return ListMode.TIGHT;
    }

    private char bulletType(Line line, Matcher matcher) {
        return line.getText().charAt(matcher.end(1) - 1);
    }

    private @Nullable String listStart(Line line, Matcher matcher) {
        String number = matcher.group(2);
        if (number != null) {
            int startIdx = 0;
            while (startIdx < number.length() - 1) {
                if (number.charAt(startIdx) != '0') break;
                ++startIdx;
            }
            if (startIdx > 0) {
                number = number.substring(startIdx, number.length());
            }
            if (number.equals("1")) {
                return null;
            }
            return number;
        }
        return null;
    }

    private DocumentBuilder.BlockType toBlockType(char bulletType) {
        switch (bulletType) {
            case '*': 
            case '+': 
            case '-': {
                return DocumentBuilder.BlockType.BULLETED_LIST;
            }
        }
        return DocumentBuilder.BlockType.NUMERIC_LIST;
    }

    static final class ListBlockNode
    extends SourceBlockNode<ListBlock> {
        private char bulletType;
        private @Nullable String listStart;

        private ListBlockNode(ListBlock type, SourceBlocks.SourceBlockBuilder builder) {
            super(type, builder);
        }
    }

    private static class ListItemBlock
    extends BlockWithNestedBlocks<SourceBlockNode<ListItemBlock>> {
        private final ListBlockNode listNode;
        private int itemIdent = 4;

        public ListItemBlock(ListBlockNode listNode) {
            this.listNode = listNode;
        }

        @Override
        public boolean canStart(LineSequence lineSequence, @Nullable SourceBlockNode<?> currentNode) {
            return this.canStart(lineSequence.getCurrentLine());
        }

        public boolean canStart(@Nullable Line startLine) {
            if (startLine != null && !startLine.isBlank() && startLine.getIndent() < 4) {
                ListBlock listType = (ListBlock)this.listNode.getType();
                Matcher matcher = startLine.setupIndent(listType.matcher);
                return matcher.matches() && listType.bulletType(startLine, matcher) == this.listNode.bulletType && !listType.thematicBreakBlock.canStart(startLine);
            }
            return false;
        }

        @Override
        public void createNodes(SourceBlocks.SourceBlockBuilder builder) {
            SourceBlockNode<ListItemBlock> node = new SourceBlockNode<ListItemBlock>(this, builder);
            ListBlock listType = (ListBlock)this.listNode.getType();
            Line startLine = (Line)ObjectUtils.nonNullAssert((Object)builder.getLineSequence().getCurrentLine());
            this.itemIdent = ListBlock.computeItemLineIndent(startLine, listType.matcher);
            ListItemLines itemLineSequence = new ListItemLines(builder, node, startLine.getLineNumber(), this.itemIdent);
            builder.createNestedNodes(itemLineSequence, null);
        }

        @Override
        public void emit(ProcessingContext context, SourceBlockNode<ListItemBlock> node, CommonmarkLocator locator, DocumentBuilder builder) {
            throw new UnsupportedOperationException();
        }

        public void emit(ProcessingContext context, SourceBlockNode<ListItemBlock> node, ListMode listMode, CommonmarkLocator locator, DocumentBuilder builder) {
            SourceElementAttributes attributes = new SourceElementAttributes(256);
            locator.setBlockBegin(node);
            builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, (Attributes)attributes);
            for (SourceBlockNode<?> contentNode : node.getNested()) {
                if (listMode == ListMode.TIGHT && contentNode.isParagraph()) {
                    ParagraphBlock.ParagraphBlockNode paragraphNode = (ParagraphBlock.ParagraphBlockNode)contentNode;
                    ((ParagraphBlock)paragraphNode.getType()).emitParagraph(context, paragraphNode, false, locator, builder);
                    continue;
                }
                ((SourceBlockType)contentNode.getType()).emit(context, contentNode, locator, builder);
            }
            locator.setBlockEnd(node);
            builder.endBlock();
        }
    }

    private static class ListItemLines
    extends FilterLineSequence {
        private final SourceBlocks.SourceBlockBuilder builder;
        private final SourceBlockNode<ListItemBlock> node;
        private final int markerLineNumber;
        private final int indent;

        public ListItemLines(SourceBlocks.SourceBlockBuilder builder, SourceBlockNode<ListItemBlock> node, int markerLineNumber, int indent) {
            super(builder.getLineSequence());
            this.builder = builder;
            this.node = node;
            this.markerLineNumber = markerLineNumber;
            this.indent = indent;
        }

        protected ListItemLines(ListItemLines from) {
            super(from.getDelegate().lookAhead());
            this.builder = from.builder;
            this.node = from.node;
            this.markerLineNumber = from.markerLineNumber;
            this.indent = from.indent;
        }

        @Override
        public ListItemLines lookAhead() {
            return new ListItemLines(this);
        }

        @Override
        protected @Nullable Line filter(Line line) {
            List<SourceBlockNode<?>> contentNodes = this.node.getNested();
            if (contentNodes.size() == 1 && contentNodes.get(0).isEmpty() && line.getLineNumber() > this.markerLineNumber + 1) {
                return null;
            }
            if (line.isLazy()) {
                return line;
            }
            if (line.getLineNumber() == this.markerLineNumber || line.isBlank() || line.getIndent() >= this.indent) {
                return line.segmentByIndent(this.indent);
            }
            return null;
        }
    }

    private static class ListLines
    extends FilterLineSequence {
        private final SourceBlocks.SourceBlockBuilder builder;
        private final ListItemBlock type;

        public ListLines(LineSequence delegate, SourceBlocks.SourceBlockBuilder builder, ListItemBlock type) {
            super(delegate);
            this.builder = builder;
            this.type = type;
        }

        public ListLines(ListLines from) {
            super(from.getDelegate().lookAhead());
            this.builder = from.builder;
            this.type = from.type;
        }

        @Override
        public LineSequence lookAhead() {
            return new ListLines(this);
        }

        @Override
        protected @Nullable Line filter(Line line) {
            if (!line.isBlank()) {
                if (line.getIndent() >= this.type.itemIdent || this.type.canStart(line)) {
                    return line;
                }
                if (this.isLazyContinuation(line)) {
                    return line.lazy();
                }
            } else if (this.lookAheadSafeLine(this.getDelegate().lookAhead(line.getLineNumber())) != Integer.MIN_VALUE) {
                return line;
            }
            return null;
        }

        private boolean isLazyContinuation(Line line) {
            SourceBlockNode<?> activeNode = this.builder.getActiveNode();
            if (activeNode != null && activeNode.getParent() != this.type.listNode && activeNode.isParagraph()) {
                ParagraphBlock.ParagraphBlockNode paragraphNode = (ParagraphBlock.ParagraphBlockNode)activeNode;
                if (!this.type.canStart(line) && !((ParagraphBlock)paragraphNode.getType()).isAnotherBlockStart(this.getDelegate().lookAhead(line.getLineNumber()), this.builder.getSourceBlocks(), paragraphNode)) {
                    return true;
                }
            }
            return false;
        }

        private int lookAheadSafeLine(LineSequence lineSequence) {
            Line line;
            while ((line = lineSequence.getCurrentLine()) != null) {
                if (line.isBlank()) {
                    lineSequence.advance();
                    continue;
                }
                if (line.getIndent() < this.type.itemIdent && !this.type.canStart(line)) break;
                return line.getLineNumber();
            }
            return Integer.MIN_VALUE;
        }
    }

    private static enum ListMode {
        TIGHT,
        LOOSE,
        TIGHT_WITH_TRAILING_EMPTY_LINE;

    }
}

