/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.setup;

import java.util.regex.Matcher;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.eplatform.EStatusUtils;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolCommandData;
import org.eclipse.statet.jcommons.util.StringUtils;
import org.eclipse.statet.nico.core.NicoCoreMessages;
import org.eclipse.statet.nico.core.runtime.ConsoleService;
import org.eclipse.statet.nico.core.runtime.ToolStreamMonitor;
import org.eclipse.statet.nico.core.util.AbstractConsoleCommandHandler;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public class ReportStatusHandler
extends AbstractConsoleCommandHandler {
    private static final String INDENT = "    ";

    public Status execute(String id, ConsoleService service, ToolCommandData data, ProgressMonitor m) {
        Status status = (Status)data.get("status", Status.class);
        if (status != null) {
            String br = service.getWorkspace().getLineSeparator();
            String br1 = br + INDENT;
            String br2 = br1 + INDENT;
            StringBuilder msg = new StringBuilder(br);
            boolean details = false;
            switch (status.getSeverity()) {
                case 1: {
                    msg.append("[INFO   ] ");
                    break;
                }
                case 2: {
                    msg.append("[WARNING] ");
                    break;
                }
                case 4: {
                    msg.append("[ERROR  ] ");
                    break;
                }
                case 8: {
                    msg.append("[CANCEL ] ");
                }
            }
            msg.append(status.getMessage());
            ImList subList = null;
            if (status.isMultiStatus()) {
                details |= status.getException() != null;
                subList = status.getChildren();
            } else {
                Throwable exception = status.getException();
                if (exception instanceof StatusException) {
                    subList = ImCollections.newList((Object)((StatusException)exception).getStatus());
                } else if (exception instanceof CoreException) {
                    subList = ImCollections.newList((Object)EStatusUtils.convert((IStatus)((CoreException)exception).getStatus()));
                } else if (exception != null) {
                    details = true;
                }
            }
            if (subList != null && !subList.isEmpty()) {
                Matcher linebreakMatcher = StringUtils.U_LINEBREAK_PATTERN.matcher("");
                for (Status subStatus : subList) {
                    msg.append(br1);
                    msg.append(linebreakMatcher.reset(subStatus.getMessage()).replaceAll(br2));
                    details |= subStatus.isMultiStatus() || subStatus.getException() != null;
                }
            }
            if (details) {
                msg.append(br);
                msg.append("(more details available in Eclipse error log)");
            }
            msg.append(br);
            try {
                ToolStreamMonitor infoStream = service.getController().getStreams().getInfoStreamMonitor();
                infoStream.append(msg.toString(), service.getController().getCurrentSubmitType(), 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ((status.getSeverity() & 6) != 0) {
                StatusManager.getManager().handle((IStatus)new MultiStatus("org.eclipse.statet.nico.core", 0, new IStatus[]{EStatusUtils.convert((Status)status)}, NicoCoreMessages.format_ProblemWhileRunningTask_message((String)service.getCurrentRunnable().getLabel(), (Tool)service.getTool()), null), status.getSeverity() == 4 ? 3 : 1);
            }
        }
        return Status.OK_STATUS;
    }
}

