/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui.console;

import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.nico.ui.console.NIConsolePartition;
import org.eclipse.statet.internal.nico.ui.console.NIConsolePartitioner;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.swt.widgets.Display;

final class StreamProcessor {
    private static final char BEL = '\u0007';
    private static final char BS = '\b';
    private static final char LF = '\n';
    private static final char VT = '\u000b';
    private static final char FF = '\f';
    private static final char CR = '\r';
    private static final int CHAR_BUFFER_SIZE = 8192;
    private static final byte S_CREATED = 1;
    private static final byte S_APPLIED = 2;
    private static final byte S_DONE = 4;
    private final NIConsolePartitioner partitioner;
    private byte state;
    private String docLF;
    private String docVT;
    private boolean finish;
    private int docLength;
    private final StringBuilder text = new StringBuilder(8192);
    private int textOffsetInDoc;
    private int lineStartInText;
    private int lastPartitionInsertGap;
    private final char[] charBuffer = new char[8192];

    public StreamProcessor(NIConsolePartitioner partitioner) {
        this.partitioner = partitioner;
    }

    public void prepareUpdate(ImList<NIConsolePartitioner.PendingPartition> pendingPartitions, int pendingLength) {
        this.text.setLength(0);
        if ((this.state & 2) == 0) {
            this.lastPartitionInsertGap = 0;
        }
        this.clear();
        AbstractDocument document = this.partitioner.getDocument();
        if (document != null) {
            this.docLength = document.getLength();
            boolean mayCombineLast = true;
            this.textOffsetInDoc = this.docLength;
            this.lineStartInText = 0;
            this.text.ensureCapacity(pendingLength);
            for (NIConsolePartitioner.PendingPartition pp : pendingPartitions) {
                if (pp != null) {
                    this.processPartition(pp, mayCombineLast);
                    mayCombineLast = false;
                    continue;
                }
                this.finish = true;
            }
            this.state = (byte)(this.state | 1);
        } else {
            for (NIConsolePartitioner.PendingPartition pp : pendingPartitions) {
                if (pp != null) continue;
                this.finish = true;
                break;
            }
        }
    }

    public void updateApplied() {
        this.state = (byte)(this.state | 2);
    }

    public void updateDone() {
        this.state = (byte)(this.state | 4);
        if (this.finish ? this.text.capacity() > 16384 : this.text.capacity() > 0x100000 && this.text.capacity() / 2 > this.text.length()) {
            if (this.text.length() < 8192) {
                this.text.append(this.charBuffer, 0, 8192 - this.text.length());
            } else {
                this.text.setLength(8192);
            }
            this.text.trimToSize();
        }
    }

    public void clear() {
        this.state = 0;
    }

    public String getText() {
        return this.text.toString();
    }

    public int getTextOffsetInDoc() {
        return this.textOffsetInDoc;
    }

    public int getTextReplaceLengthInDoc() {
        return this.docLength - this.textOffsetInDoc;
    }

    public boolean wasFinished() {
        return this.finish;
    }

    private void processPartition(NIConsolePartitioner.PendingPartition pp, boolean mayCombineLast) {
        int pOffset;
        StringBuilder pText = pp.getText();
        StringBuilder text = this.text;
        int insertIdx = pOffset = text.length();
        int readIdx = 0;
        int doneIdx = 0;
        int pLineStart = pOffset;
        if (mayCombineLast && pLineStart == 0 && this.lastPartitionInsertGap > 0) {
            mayCombineLast = false;
            this.prependLastDocLine(pp, text);
            insertIdx = Math.max(text.length() - this.lastPartitionInsertGap, pLineStart);
        }
        while (readIdx < pText.length()) {
            char c = pText.charAt(readIdx);
            switch (c) {
                case '\u0007': {
                    insertIdx += this.copy(pText, doneIdx, readIdx, text, insertIdx);
                    this.bell();
                    doneIdx = ++readIdx;
                    break;
                }
                case '\b': {
                    insertIdx += this.copy(pText, doneIdx, readIdx, text, insertIdx);
                    if (mayCombineLast && pLineStart == 0) {
                        mayCombineLast = false;
                        insertIdx += this.prependLastDocLine(pp, text);
                    }
                    if (insertIdx > pLineStart) {
                        --insertIdx;
                    }
                    doneIdx = ++readIdx;
                    break;
                }
                case '\n': {
                    if (insertIdx < text.length()) {
                        this.copy(pText, doneIdx, readIdx, text, insertIdx);
                        insertIdx = text.length();
                        doneIdx = readIdx;
                    }
                    pLineStart = insertIdx + ++readIdx - doneIdx;
                    break;
                }
                case '\u000b': {
                    this.copy(pText, doneIdx, readIdx, text, insertIdx);
                    if (this.docVT == null) {
                        this.initDocTemplates();
                    }
                    text.append(this.docVT);
                    pLineStart = insertIdx = text.length();
                    doneIdx = ++readIdx;
                    break;
                }
                case '\f': {
                    int count;
                    insertIdx += this.copy(pText, doneIdx, readIdx, text, insertIdx);
                    if (this.docLF == null) {
                        this.initDocTemplates();
                    }
                    if (pLineStart == pOffset) {
                        count = insertIdx - this.lineStartInText;
                        if (this.lineStartInText == 0) {
                            count += this.getLastDocLineLength();
                        }
                    } else {
                        count = insertIdx - pLineStart;
                    }
                    text.append(this.docLF);
                    pLineStart = insertIdx = text.length();
                    insertIdx += this.append(' ', count, text);
                    doneIdx = ++readIdx;
                    break;
                }
                case '\r': {
                    if (readIdx + 1 < pText.length() && pText.charAt(readIdx + 1) == '\n') {
                        if (insertIdx < text.length()) {
                            this.copy(pText, doneIdx, readIdx, text, insertIdx);
                            insertIdx = text.length();
                            doneIdx = readIdx;
                        }
                        ++readIdx;
                        break;
                    }
                    this.copy(pText, doneIdx, readIdx, text, insertIdx);
                    if (mayCombineLast && pLineStart == 0) {
                        mayCombineLast = false;
                        this.prependLastDocLine(pp, text);
                    }
                    insertIdx = pLineStart;
                    doneIdx = ++readIdx;
                    break;
                }
                default: {
                    ++readIdx;
                }
            }
        }
        this.lineStartInText = pLineStart;
        if (doneIdx == 0 && text.length() == pOffset) {
            text.append((CharSequence)pText);
            this.lastPartitionInsertGap = 0;
        } else {
            insertIdx += this.copy(pText, doneIdx, readIdx, text, insertIdx);
            pText.setLength(0);
            this.copy(text, pOffset, text.length(), pText, 0);
            this.lastPartitionInsertGap = text.length() - insertIdx;
        }
    }

    /*
     * Unable to fully structure code
     */
    private int copy(StringBuilder src, int srcStart, int srcEnd, StringBuilder dest, int destIdx) {
        block9: {
            block7: {
                block8: {
                    length = srcEnd - srcStart;
                    if (length == 0) {
                        return 0;
                    }
                    if (destIdx != dest.length()) break block7;
                    if (length != 1) break block8;
                    dest.append(src.charAt(srcStart));
                    break block9;
                }
                if (length > 16) ** GOTO lbl18
                dest.append(src, srcStart, srcEnd);
                break block9;
lbl-1000:
                // 1 sources

                {
                    src.getChars(srcStart, srcStart + n, this.charBuffer, 0);
                    dest.append(this.charBuffer, 0, n);
                    srcStart += n;
lbl18:
                    // 2 sources

                    ** while ((n = Math.min((int)(srcEnd - srcStart), (int)8192)) != 0)
                }
lbl19:
                // 1 sources

                break block9;
            }
            if (length == 1) {
                dest.setCharAt(destIdx, src.charAt(srcStart));
            } else if (destIdx + length < dest.length()) {
                dest.replace(destIdx, destIdx + length, src.substring(srcStart, srcEnd));
            } else {
                dest.setLength(destIdx);
                while ((n = Math.min(srcEnd - srcStart, 8192)) != 0) {
                    src.getChars(srcStart, srcStart + n, this.charBuffer, 0);
                    dest.append(this.charBuffer, 0, n);
                    srcStart += n;
                }
            }
        }
        return length;
    }

    private int append(char c, int count, StringBuilder dest) {
        int i = 0;
        while (i < count) {
            dest.append(c);
            ++i;
        }
        return count;
    }

    private void bell() {
        final Display display = UIAccess.getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                display.beep();
            }
        });
    }

    private int prependLastDocLine(NIConsolePartitioner.PendingPartition pp, StringBuilder dest) {
        NIConsolePartition lastPartition = this.partitioner.getLastPartition();
        if (lastPartition != null && lastPartition.getStream() == pp.getStream() && lastPartition.getOffset() + lastPartition.getLength() == this.docLength) {
            try {
                AbstractDocument document = this.partitioner.getDocument();
                int start = Math.max(lastPartition.getOffset(), document.getLineOffset(document.getNumberOfLines() - 1));
                int length = this.docLength - start;
                if (length > 0) {
                    dest.insert(0, document.get(start, length));
                    this.textOffsetInDoc = start;
                    return length;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return 0;
    }

    private int getLastDocLineLength() {
        try {
            AbstractDocument document = this.partitioner.getDocument();
            int start = document.getLineOffset(document.getNumberOfLines() - 1);
            int length = this.textOffsetInDoc - start;
            if (length > 0) {
                return length;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return 0;
    }

    private void initDocTemplates() {
        this.docLF = this.partitioner.getConsole().getProcess().getWorkspace().getLineSeparator();
        StringBuilder sb = new StringBuilder();
        sb.append(this.docLF);
        sb.append(this.docLF);
        sb.append(this.docLF);
        sb.append(this.docLF);
        this.docVT = sb.toString();
    }
}

