/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core.server.jetty;

import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rhelp.core.http.MediaTypeProvider;

@NonNullByDefault
public class ExtMimeTypes
extends MimeTypes {
    private final MediaTypeProvider defaultMediaTypes;
    private @Nullable MediaTypeProvider specialMediaTypes;

    public ExtMimeTypes(MediaTypeProvider mimeTypes) {
        this.defaultMediaTypes = mimeTypes;
    }

    public @Nullable MediaTypeProvider getSpecialMediaTypes() {
        return this.specialMediaTypes;
    }

    public void setSpecialMediaTypes(@Nullable MediaTypeProvider specialMediaTypes) {
        this.specialMediaTypes = specialMediaTypes;
    }

    public @Nullable String getMimeByExtension(String filename) {
        int idx = Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92));
        if (idx >= 0) {
            filename = filename.substring(idx + 1);
        }
        String type = null;
        MediaTypeProvider specialMediaTypes = this.getSpecialMediaTypes();
        if (specialMediaTypes != null) {
            type = specialMediaTypes.getMediaTypeString(filename);
        }
        if (type == null) {
            type = this.defaultMediaTypes.getMediaTypeString(filename);
        }
        if (type == null) {
            type = super.getMimeByExtension(filename);
        }
        return type;
    }
}

