/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core.server;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.statet.internal.rhelp.core.server.ServerREnvHelpAccess;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rhelp.core.REnvHelpConfiguration;

@NonNullByDefault
public abstract class ServerClientSupport {
    private static @Nullable ServerClientSupport instance;

    public static synchronized ServerClientSupport getInstance() throws StatusException {
        ServerClientSupport impl = instance;
        if (impl == null) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", "R-help server support not available."));
        }
        return impl;
    }

    public static synchronized void init(ServerClientSupport impl) {
        if (instance != null) {
            throw new IllegalStateException();
        }
        instance = impl;
    }

    public URI checkServerUri(@Nullable URI uri) throws URISyntaxException {
        return this.checkServerUri(uri, "https");
    }

    protected URI checkServerUri(@Nullable URI uri, String defaultScheme) throws URISyntaxException {
        String host;
        if (uri == null) {
            throw new UnsupportedOperationException("The uri is missing.");
        }
        String scheme = uri.getScheme();
        if (scheme == null) {
            scheme = defaultScheme;
        }
        if ((host = uri.getHost()) == null) {
            throw new UnsupportedOperationException(String.format("The uri '%1$s' is invalid: missing host.", uri));
        }
        String path = uri.getPath();
        if (path == null || path.length() <= 1) {
            throw new UnsupportedOperationException(String.format("The url '%1$s' is invalid: missing R environment id.", uri));
        }
        return new URI(scheme, uri.getUserInfo(), host, uri.getPort(), path, null, null);
    }

    public URI toServerBrowseUrl(REnvHelpConfiguration rEnvConfig, String path) throws URISyntaxException {
        URI uri = this.checkServerUri(rEnvConfig.getStateSharedServerUri());
        String uriPath = (String)ObjectUtils.nonNullAssert((Object)uri.getPath());
        int idStart = uriPath.lastIndexOf(47);
        StringBuilder pathBuilder = new StringBuilder(uriPath.length() + path.length() + 13);
        pathBuilder.append(uriPath, 0, idStart);
        pathBuilder.append("/rhelp/browse");
        pathBuilder.append(uriPath, idStart, uriPath.length());
        pathBuilder.append(path);
        return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), pathBuilder.toString(), null, null);
    }

    protected abstract ServerREnvHelpAccess newREnvHelpAccess(URI var1) throws Exception;

    public ServerREnvHelpAccess getREnvHelpAccess(REnvHelpConfiguration rEnvConfig) throws StatusException {
        try {
            URI url = this.checkServerUri(rEnvConfig.getStateSharedServerUri());
            return this.newREnvHelpAccess(url);
        }
        catch (Exception e) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", "An error occured when initializing access to R help server", (Throwable)e));
        }
    }
}

