/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core.index;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.core.QueryNodeParseException;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.queryparser.flexible.standard.config.StandardQueryConfigHandler;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.eclipse.statet.internal.rhelp.core.RHelpCoreInternals;
import org.eclipse.statet.internal.rhelp.core.index.DefaultAnalyzer;
import org.eclipse.statet.internal.rhelp.core.index.REnvIndexReader;
import org.eclipse.statet.internal.rhelp.core.index.REnvIndexSchema;
import org.eclipse.statet.internal.rhelp.core.index.REnvIndexUtils;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rhelp.core.RHelpSearchQuery;

@NonNullByDefault
public final class REnvIndexSearchQuery
implements REnvIndexSchema {
    private static final ImList<String> TOPIC_SEARCH_FIELDS = ImCollections.newList((Object)"alias");
    private static final ImList<String> DOC_SEARCH_FIELDS = ImCollections.newList((Object[])new String[]{"title.txt", "descr.txt", "doc.txt", "examples.txt"});
    private static final Map<String, Float> FIELD_BOOSTS = new HashMap<String, Float>();
    private static final Analyzer QUERY_ANALYZER;
    public final ImList<String> fieldNames;
    private final @Nullable Query query;
    private final ImList<Query> filters;

    static {
        FIELD_BOOSTS.put("alias.txt", Float.valueOf(2.0f));
        FIELD_BOOSTS.put("title.txt", Float.valueOf(2.0f));
        FIELD_BOOSTS.put("descr.txt", Float.valueOf(1.5f));
        FIELD_BOOSTS.put("examples.txt", Float.valueOf(0.5f));
        QUERY_ANALYZER = new DefaultAnalyzer();
    }

    public static REnvIndexSearchQuery compile(RHelpSearchQuery searchQuery) throws StatusException {
        try {
            ImList<String> keywords;
            Query query = null;
            ImList<String> fields = ImCollections.emptyList();
            if (searchQuery.getSearchString().length() > 0) {
                switch (searchQuery.getSearchType()) {
                    case 1: {
                        fields = TOPIC_SEARCH_FIELDS;
                        query = REnvIndexSearchQuery.createMainQuery(searchQuery.getSearchString(), fields, null);
                        break;
                    }
                    case 2: {
                        fields = REnvIndexSearchQuery.sortFields(searchQuery.getEnabledFields());
                        if (fields.isEmpty()) break;
                        query = REnvIndexSearchQuery.createMainQuery(searchQuery.getSearchString(), fields, FIELD_BOOSTS);
                        break;
                    }
                    case 3: {
                        fields = DOC_SEARCH_FIELDS;
                        query = REnvIndexSearchQuery.createMainQuery(searchQuery.getSearchString(), fields, FIELD_BOOSTS);
                        break;
                    }
                }
            }
            ArrayList<Query> filters = new ArrayList<Query>(4);
            ImList<String> packages = searchQuery.getPackages();
            if (!packages.isEmpty()) {
                filters.add((Query)new TermInSetQuery("pkg", REnvIndexUtils.toByteRefTerms(packages)));
            }
            if (!(keywords = searchQuery.getKeywords()).isEmpty()) {
                filters.add((Query)new TermInSetQuery("keyword", REnvIndexUtils.toByteRefTerms(keywords)));
            }
            filters.add(REnvIndexReader.DOCTYPE_PAGE_FILTER);
            return new REnvIndexSearchQuery(query, (List<String>)fields, (List<Query>)filters);
        }
        catch (QueryNodeParseException e) {
            RHelpCoreInternals.log((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", String.format("An error occurred when creating the Lucene query for: %1$s.", searchQuery.toString()), (Throwable)e));
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", "The search string is invalid: " + e.getLocalizedMessage()));
        }
        catch (Exception e) {
            RHelpCoreInternals.log((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", String.format("An error occurred when creating the Lucene query for %1$s.", searchQuery.toString()), (Throwable)e));
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", "An error occurred when preparing the R help query."));
        }
    }

    private static ImList<String> sortFields(List<String> fields) {
        return ImCollections.toList(fields, (Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return REnvIndexSearchQuery.getRank(o1) - REnvIndexSearchQuery.getRank(o2);
            }
        });
    }

    static Query createMainQuery(String queryText, ImList<String> fields, @Nullable Map<String, Float> fieldBoosts) throws QueryNodeException {
        StandardQueryParser p = new StandardQueryParser(QUERY_ANALYZER);
        p.setDefaultOperator(StandardQueryConfigHandler.Operator.AND);
        p.setAllowLeadingWildcard(true);
        p.setMultiFields((CharSequence[])fields.toArray((Object[])new String[fields.size()]));
        if (fieldBoosts != null) {
            p.setFieldsBoost(fieldBoosts);
        }
        return p.parse(queryText, null);
    }

    private static int getRank(String o) {
        if (o == "page") {
            return 1;
        }
        if (o == "alias" || o == "alias.txt") {
            return 2;
        }
        if (o == "title.txt") {
            return 3;
        }
        if (o == "concept.txt") {
            return 4;
        }
        if (o == "descr.txt") {
            return 5;
        }
        if (o == "doc.txt" || o == "doc.html") {
            return 6;
        }
        if (o == "examples.txt") {
            return 15;
        }
        return 10;
    }

    private REnvIndexSearchQuery(@Nullable Query mainQuery, List<String> fieldNames, List<Query> filters) {
        this.fieldNames = ImCollections.toList(fieldNames);
        this.query = mainQuery;
        this.filters = ImCollections.toList(filters);
    }

    public @Nullable Query getQuery() {
        return this.query;
    }

    public ImList<Query> getFilters() {
        return this.filters;
    }
}

