/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core;

import org.eclipse.statet.internal.rhelp.core.RHelpCoreInternals;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rhelp.core.RHelpPage;
import org.eclipse.statet.rhelp.core.RPkgHelp;

@NonNullByDefault
public final class RHelpPageImpl
implements RHelpPage {
    public static final String INTERNAL_KEYWORD = "internal";
    public static final byte INTERNAL_FLAG = 1;
    private final RPkgHelp pkg;
    private final String name;
    private final byte flags;
    private final ImList<String> topics;
    private final String title;

    public static byte createFlags(boolean isInternal) {
        byte flags = 0;
        if (isInternal) {
            flags = (byte)(flags | 1);
        }
        return flags;
    }

    public RHelpPageImpl(RPkgHelp pkgHelp, String name, byte flags, ImList<String> topics, String title) {
        this.pkg = pkgHelp;
        this.name = name;
        this.flags = flags;
        this.topics = topics;
        this.title = title;
    }

    @Override
    public RPkgHelp getPackage() {
        return this.pkg;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public byte getFlags() {
        return this.flags;
    }

    @Override
    public boolean isInternal() {
        return (this.flags & 1) != 0;
    }

    @Override
    public ImList<String> getTopics() {
        return this.topics;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public int hashCode() {
        return this.pkg.hashCode() + this.name.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        RHelpPage other;
        return this == obj || obj instanceof RHelpPage && this.name.equals((other = (RHelpPage)obj).getName()) && this.pkg.equals(other.getPackage());
    }

    @Override
    public int compareTo(RHelpPage o) {
        return RHelpCoreInternals.R_NAMES_COLLATOR.compare(this.name, o.getName());
    }

    public String toString() {
        return this.pkg.getName() + "::" + this.name;
    }
}

