/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.rmodel;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.statet.internal.r.core.rmodel.BuildSourceFrameElement;
import org.eclipse.statet.internal.r.core.rmodel.ElementAccess;
import org.eclipse.statet.internal.r.core.rmodel.RSourceModel;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.model.core.LtkModelUtils;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.r.core.model.RElementAccess;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.rlang.RLangSrcStrElement;
import org.eclipse.statet.r.core.model.rlang.RSrcStrFrame;

@NonNullByDefault
abstract class BuildSourceFrame
implements RSrcStrFrame {
    static final int CREATED_NO = 0;
    static final int CREATED_SEARCH = 1;
    static final int CREATED_RESOLVED = 2;
    static final int CREATED_EXPLICIT = 3;
    static final int CREATED_IMPORTED = 4;
    private static final ImList<BuildSourceFrame> NO_PARENTS = ImCollections.emptyList();
    protected final Map<@Nullable String, ElementAccessList> data;
    protected final int type;
    protected final String id;
    ImList<BuildSourceFrame> parents;
    private List<BuildSourceFrameElement> elements = Collections.emptyList();
    private @Nullable WeakReference<List<RLangSrcStrElement>> modelChildren;

    public static String createId(int type, @Nullable String name, int alt) {
        if (type == 2 && name != null) {
            return "package:" + name;
        }
        return name != null ? Integer.toHexString(type) + ":`" + name + "`" : Integer.toHexString(type) + ":#" + Integer.toHexString(alt);
    }

    BuildSourceFrame(int type, String id, BuildSourceFrame @Nullable [] parents) {
        this.type = type;
        this.id = id;
        this.parents = parents != null ? ImCollections.newList((Object[])parents) : NO_PARENTS;
        this.data = new HashMap<String, ElementAccessList>();
    }

    void addFrameElement(BuildSourceFrameElement element) {
        int length = this.elements.size();
        Object[] elements = this.elements.toArray(new BuildSourceFrameElement[length + 1]);
        elements[length] = element;
        this.elements = ImCollections.newList((Object[])elements);
    }

    abstract void add(@Nullable String var1, ElementAccess var2);

    abstract void addLateResolve(@Nullable String var1, ElementAccess var2);

    abstract void addRunResolve(@Nullable String var1, ElementAccess var2);

    abstract void addClass(@Nullable String var1, ElementAccess var2);

    abstract void runLateResolve(boolean var1);

    protected BuildSourceFrame[] createSearchList() {
        ArrayList<BuildSourceFrame> list = new ArrayList<BuildSourceFrame>();
        int idx = 0;
        list.add(this);
        while (idx < list.size()) {
            ImList<BuildSourceFrame> ps = ((BuildSourceFrame)list.get((int)idx++)).parents;
            for (BuildSourceFrame p : ps) {
                if (list.contains(p)) continue;
                list.add(p);
            }
        }
        return list.toArray(new BuildSourceFrame[list.size()]);
    }

    @Override
    public int getFrameType() {
        return this.type;
    }

    @Override
    public String getFrameId() {
        return this.id;
    }

    @Override
    public List<? extends RSrcStrFrame> getPotentialParents() {
        return this.parents;
    }

    @Override
    public Set<@Nullable String> getAllAccessNames() {
        return Collections.unmodifiableSet(this.data.keySet());
    }

    @Override
    public ImList<? extends RElementAccess> getAllAccessOf(@Nullable String name, boolean includeSlaves) {
        ElementAccessList list = this.data.get(name);
        if (list == null) {
            return ImCollections.emptyList();
        }
        return list.getAll(includeSlaves);
    }

    @Override
    public boolean isResolved(String name) {
        ElementAccessList accessList = this.data.get(name);
        return accessList != null && accessList.isCreated >= 2;
    }

    @Override
    public List<? extends RLangSrcStrElement> getModelElements() {
        return this.elements;
    }

    @Override
    public boolean hasModelChildren(@Nullable LtkModelElementFilter<? super RLangSrcStrElement> filter) {
        for (ElementAccessList list : this.data.values()) {
            for (ElementAccess access : list.entries) {
                RLangSrcStrElement element = access.modelElement;
                if (element == null || filter != null && !filter.include((LtkModelElement)element)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<? extends RLangSrcStrElement> getModelChildren(@Nullable LtkModelElementFilter<? super RLangSrcStrElement> filter) {
        List<RLangSrcStrElement> children;
        if (this.data.isEmpty()) {
            return RSourceModel.NO_R_SOURCE_STRUCT_CHILDREN;
        }
        WeakReference<List<RLangSrcStrElement>> childrenRef = this.modelChildren;
        List list = children = childrenRef != null ? (ArrayList)childrenRef.get() : null;
        if (children != null) {
            if (filter == null) {
                return children;
            }
            return LtkModelUtils.getChildren(children, filter);
        }
        children = new ArrayList();
        for (ElementAccessList list2 : this.data.values()) {
            for (ElementAccess access : list2.entries) {
                RLangSrcStrElement element = access.modelElement;
                if (element == null || filter != null && !filter.include((LtkModelElement)element)) continue;
                children.add(element);
            }
        }
        children = Collections.unmodifiableList(children);
        if (filter == null) {
            this.modelChildren = new WeakReference(children);
        }
        return children;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        RElementName elementName = this.getElementName();
        if (elementName != null) {
            sb.append(' ').append(elementName);
        } else {
            sb.append(" <unnamed>");
        }
        return sb.toString();
    }

    static class DefScope
    extends BuildSourceFrame {
        private Map<String, ElementAccessList> lateWrite = new HashMap<String, ElementAccessList>();
        private Map<String, ElementAccessList> lateRead = new HashMap<String, ElementAccessList>();
        private @Nullable Map<@Nullable String, ElementAccessList> classes;
        private @Nullable RElementName elementName;

        DefScope(int type, String id, @Nullable String name, BuildSourceFrame @Nullable [] parents) {
            super(type, id, parents);
            switch (type) {
                case 1: {
                    this.elementName = null;
                    this.classes = new HashMap<String, ElementAccessList>();
                    break;
                }
                case 2: {
                    this.elementName = RElementName.create(38, name);
                    this.classes = new HashMap<String, ElementAccessList>();
                    break;
                }
                default: {
                    this.classes = null;
                }
            }
        }

        @Override
        public @Nullable RElementName getElementName() {
            return this.elementName;
        }

        @Override
        void add(@Nullable String name, ElementAccess access) {
            ElementAccessList detail = (ElementAccessList)this.data.get(name);
            if (detail == null) {
                detail = new ElementAccessList(name);
                detail.frame = this;
                this.data.put(name, detail);
            }
            detail.entries.add(access);
            if (access.isWriteAccess() && !access.isDeletion()) {
                detail.isCreated = 3;
            } else if (access.isImport()) {
                detail.isCreated = 4;
            }
            access.shared = detail;
            access.fullNode.addAttachment(access);
        }

        @Override
        void addLateResolve(@Nullable String name, ElementAccess access) {
            Map<String, ElementAccessList> late;
            if (name == null) {
                this.add(null, access);
                return;
            }
            ElementAccessList detail = (ElementAccessList)this.data.get(name);
            if (detail != null && detail.isCreated <= 0) {
                detail = null;
            }
            if (detail == null && (detail = (late = (access.flags & 0x10F) == 2 ? this.lateWrite : this.lateRead).get(name)) == null) {
                detail = new ElementAccessList(name);
                late.put(name, detail);
            }
            detail.entries.add(access);
            access.shared = detail;
            access.fullNode.addAttachment(access);
        }

        @Override
        void addClass(@Nullable String name, ElementAccess access) {
            Map<@Nullable String, ElementAccessList> classes = this.classes;
            if (classes == null) {
                ((BuildSourceFrame)this.parents.getFirst()).addClass(name, access);
                return;
            }
            ElementAccessList detail = classes.get(name);
            if (detail == null) {
                detail = new ElementAccessList(name);
                detail.frame = this;
                classes.put(name, detail);
            }
            detail.entries.add(access);
            access.shared = detail;
            access.fullNode.addAttachment(access);
        }

        @Override
        void addRunResolve(@Nullable String name, ElementAccess access) {
        }

        @Override
        void runLateResolve(boolean onlyWrite) {
            ElementAccessList exist;
            int i;
            int requiredCreation;
            BuildSourceFrame defaultScope;
            BuildSourceFrame[] searchList = this.createSearchList();
            Map<String, ElementAccessList> map = this.lateWrite;
            if (map != null) {
                defaultScope = this;
                block0: for (ElementAccessList detail : map.values()) {
                    requiredCreation = 1;
                    while (requiredCreation >= 0) {
                        i = 0;
                        while (i < searchList.length) {
                            exist = searchList[i].data.get(detail.getName());
                            if (exist != null && exist.isCreated >= requiredCreation) {
                                for (ElementAccess access : detail.entries) {
                                    access.shared = exist;
                                }
                                exist.entries.addAll(detail.entries);
                                continue block0;
                            }
                            ++i;
                        }
                        --requiredCreation;
                    }
                    detail.frame = defaultScope;
                    detail.isCreated = 1;
                    this.data.put(detail.getName(), detail);
                }
                this.lateWrite = null;
            }
            if (onlyWrite) {
                return;
            }
            map = this.lateRead;
            if (map != null) {
                defaultScope = this;
                int i2 = 0;
                while (i2 < searchList.length) {
                    if (searchList[i2].type <= 2) {
                        defaultScope = searchList[i2];
                        break;
                    }
                    ++i2;
                }
                block5: for (ElementAccessList detail : map.values()) {
                    requiredCreation = 1;
                    while (requiredCreation >= 0) {
                        i = 0;
                        while (i < searchList.length) {
                            exist = searchList[i].data.get(detail.getName());
                            if (exist != null && exist.isCreated >= requiredCreation) {
                                for (ElementAccess access : detail.entries) {
                                    access.shared = exist;
                                }
                                exist.entries.addAll(detail.entries);
                                continue block5;
                            }
                            ++i;
                        }
                        --requiredCreation;
                    }
                    detail.frame = defaultScope;
                    defaultScope.data.put(detail.getName(), detail);
                }
                this.lateRead = null;
            }
        }
    }

    static final class ElementAccessList {
        private final @Nullable String name;
        final List<ElementAccess> entries;
        RSrcStrFrame frame;
        int isCreated;

        public ElementAccessList(@Nullable String name) {
            this.name = name;
            this.entries = new ArrayList<ElementAccess>(4);
            this.isCreated = 0;
        }

        public @Nullable String getName() {
            return this.name;
        }

        public void postAdd(ElementAccess access) {
            access.shared = this;
            this.entries.add(access);
            access.fullNode.addAttachment(access);
        }

        public ImList<ElementAccess> getAll(boolean includeSlaves) {
            if (!includeSlaves) {
                int counter = 0;
                for (ElementAccess element : this.entries) {
                    if (!element.isSlave()) continue;
                    ++counter;
                }
                if (counter > 0) {
                    Object[] elements = new ElementAccess[this.entries.size() - counter];
                    counter = 0;
                    for (ElementAccess element : this.entries) {
                        if (!element.isMaster()) continue;
                        elements[counter++] = element;
                    }
                    Arrays.sort(elements, RElementAccess.NAME_POSITION_COMPARATOR);
                    return ImCollections.newList((Object[])elements);
                }
            }
            Object[] elements = this.entries.toArray(new ElementAccess[this.entries.size()]);
            Arrays.sort(elements, RElementAccess.NAME_POSITION_COMPARATOR);
            return ImCollections.newList((Object[])elements);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name != null ? this.name : "<null>");
            sb.append(" (").append(this.entries.size()).append(')');
            return sb.toString();
        }
    }

    static class RunScope
    extends BuildSourceFrame {
        public RunScope(int type, String id, BuildSourceFrame parent) {
            super(type, id, new BuildSourceFrame[]{parent});
        }

        @Override
        public @Nullable RElementName getElementName() {
            return null;
        }

        @Override
        public void add(@Nullable String name, ElementAccess access) {
            ((BuildSourceFrame)this.parents.getFirst()).add(name, access);
        }

        @Override
        public void addLateResolve(@Nullable String name, ElementAccess access) {
            ((BuildSourceFrame)this.parents.getFirst()).addLateResolve(name, access);
        }

        @Override
        public void addRunResolve(@Nullable String name, ElementAccess access) {
            ElementAccessList detail = (ElementAccessList)this.data.get(name);
            if (detail == null) {
                detail = new ElementAccessList(name);
                detail.frame = this;
                this.data.put(name, detail);
            }
            detail.entries.add(access);
            if (access.isWriteAccess() && !access.isDeletion()) {
                detail.isCreated = 3;
            } else if (access.isImport()) {
                detail.isCreated = 4;
            }
            access.shared = detail;
            access.fullNode.addAttachment(access);
        }

        @Override
        void addClass(@Nullable String name, ElementAccess access) {
            ((BuildSourceFrame)this.parents.getFirst()).addClass(name, access);
        }

        @Override
        void runLateResolve(boolean onlyWrite) {
        }
    }
}

