/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.redocs.tex.r.core.source.doc;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.statet.ecommons.text.core.sections.BasicDocContentSections;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNode;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.source.doc.RDocumentConstants;
import org.eclipse.statet.redocs.r.core.source.DocContentSectionsRweaveExtension;
import org.eclipse.statet.redocs.r.core.source.RweaveDocSectionTreePartImpl;
import org.eclipse.statet.redocs.tex.r.core.source.doc.TexRweaveDocumentConstants;

@NonNullByDefault
public class LtxRweaveDocumentContentInfo
extends BasicDocContentSections
implements DocContentSectionsRweaveExtension {
    public static final String LTX = "org.eclipse.statet.Ltx";
    public static final String R_CHUNK_CONTROL = "org.eclipse.statet.LtxR-ChunkControl";
    public static final String R = "org.eclipse.statet.R";
    public static final DocContentSectionsRweaveExtension INSTANCE = new LtxRweaveDocumentContentInfo();
    private final RweaveDocSectionTreePartImpl rweaveImpl = new RweaveDocSectionTreePartImpl((DocContentSections)this);

    public LtxRweaveDocumentContentInfo() {
        super("org.eclipse.statet.LtxRweave", ImCollections.newList((Object[])new String[]{LTX, R_CHUNK_CONTROL, R}));
    }

    public final String getTypeByPartition(String contentType) {
        if (RDocumentConstants.R_ANY_CONTENT_CONSTRAINT.matches(contentType)) {
            return R;
        }
        if (TexRweaveDocumentConstants.RCHUNK_PARTITION_CONSTRAINT.matches(contentType)) {
            return R_CHUNK_CONTROL;
        }
        return LTX;
    }

    public @Nullable TreePartitionNode getRChunkRegion(IDocument document, int offset) throws BadLocationException {
        return this.rweaveImpl.getRChunkRegion(document, offset);
    }

    public List<TreePartitionNode> getRChunkRegions(IDocument document, int offset, int length) throws BadLocationException {
        return this.rweaveImpl.getRChunkCodeRegions(document, offset, length);
    }

    public @Nullable IRegion getRChunkContentRegion(IDocument document, int offset) throws BadLocationException {
        return this.rweaveImpl.getRChunkContentRegion(document, offset);
    }

    public @Nullable TreePartitionNode getRCodeRegion(IDocument document, int offset) throws BadLocationException {
        return this.rweaveImpl.getRCodeRegion(document, offset);
    }

    public List<TreePartitionNode> getRChunkCodeRegions(IDocument document, int offset, int length) throws BadLocationException {
        return this.rweaveImpl.getRChunkCodeRegions(document, offset, length);
    }
}

