/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.swt;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Widget;

@NonNullByDefault
public abstract class AutoDisposeReference<TResource>
implements AutoCloseable {
    private final TResource resource;

    public static <T extends Resource> AutoDisposeReference<T> autoDispose(T resource) {
        return new AutoDisposeReference<T>(resource){

            @Override
            public void close() {
                ((Resource)this.get()).dispose();
            }
        };
    }

    public static <T extends Widget> AutoDisposeReference<T> autoDispose(T resource) {
        return new AutoDisposeReference<T>(resource){

            @Override
            public void close() {
                ((Widget)this.get()).dispose();
            }
        };
    }

    private AutoDisposeReference(TResource resource) {
        this.resource = resource;
    }

    public final TResource get() {
        return this.resource;
    }

    @Override
    public abstract void close();
}

