/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.statet.ecommons.ui.util.DNDUtils;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.r.debug.ui.actions.AbstractDebugHandler;
import org.eclipse.statet.jcommons.collections.CollectionUtils;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.debug.core.RElementVariable;
import org.eclipse.statet.r.debug.core.RVariable;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IWorkbenchPart;

public class CopyQualifiedNameHandler
extends AbstractDebugHandler {
    public void setEnabled(Object evaluationContext) {
        IWorkbenchPart part = WorkbenchUIUtils.getActivePart((Object)evaluationContext);
        ISelection selection = WorkbenchUIUtils.getCurrentSelection((Object)evaluationContext);
        if (part != null && selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection structSelection = (IStructuredSelection)selection;
            for (Object obj : structSelection.toList()) {
                RVariable rVariable;
                RElementVariable elementVariable;
                if (obj instanceof RVariable && (elementVariable = this.getElementVariable(rVariable = (RVariable)obj)) != null && elementVariable.getFQElementName() != null) continue;
                this.setBaseEnabled(false);
                return;
            }
            this.setBaseEnabled(true);
            return;
        }
        this.setBaseEnabled(false);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = WorkbenchUIUtils.getActivePart((Object)event.getApplicationContext());
        ISelection selection = WorkbenchUIUtils.getCurrentSelection((Object)event.getApplicationContext());
        if (part != null && selection != null && !selection.isEmpty()) {
            ArrayList<String> names = new ArrayList<String>();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structSelection = (IStructuredSelection)selection;
                for (Object obj : structSelection.toList()) {
                    String name = this.getName(obj);
                    if (name == null) continue;
                    names.add(name);
                }
            }
            if (names.size() == 1) {
                this.copy((String)names.get(0), part);
            } else if (names.size() > 1) {
                this.copy(CollectionUtils.toString(names, (String)", "), part);
            } else {
                this.copy("", part);
            }
        }
        return null;
    }

    private String getName(Object obj) {
        RElementName elementName;
        RVariable rVariable;
        RElementVariable elementVariable;
        if (obj instanceof RVariable && (elementVariable = this.getElementVariable(rVariable = (RVariable)obj)) != null && (elementName = elementVariable.getFQElementName()) != null) {
            return this.addIndex(elementName.getDisplayName(3), this.getVariableItemIndex(rVariable));
        }
        return null;
    }

    private void copy(String text, IWorkbenchPart part) {
        Clipboard clipboard = new Clipboard(part.getSite().getShell().getDisplay());
        try {
            DNDUtils.setContent((Clipboard)clipboard, (Object[])new String[]{text}, (Transfer[])new Transfer[]{TextTransfer.getInstance()});
        }
        finally {
            clipboard.dispose();
        }
    }
}

