/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.string;

import java.util.concurrent.ForkJoinPool;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.string.CharArrayString;
import org.eclipse.statet.jcommons.string.StringFactory;

@NonNullByDefault
public final class BasicStringFactory
implements StringFactory {
    public static final BasicStringFactory INSTANCE = new BasicStringFactory();
    static final int CHARTABLE_SIZE = 256;
    private static final @NonNull String[] CHARTABLE = new String[256];
    private static final @Nullable String[] PAIRTABLE = new String[65536];

    static {
        byte[] bytes = new byte[1];
        int c0 = 0;
        while (c0 < 256) {
            bytes[0] = (byte)(c0 & 0xFF);
            BasicStringFactory.CHARTABLE[c0] = new String(bytes, 0, 0, 1).intern();
            c0 = (char)(c0 + 1);
        }
        ForkJoinPool.commonPool().execute(() -> {
            int c0 = 32;
            while (c0 < 127) {
                int c1 = 32;
                while (c1 < 127) {
                    BasicStringFactory.getPairString(c0 * 256 + c1);
                    c1 = (char)(c1 + 1);
                }
                c0 = (char)(c0 + 1);
            }
        });
    }

    static final String getCharString(int c) {
        return CHARTABLE[c];
    }

    static final String getPairString(int i) {
        String s = PAIRTABLE[i];
        if (s == null) {
            BasicStringFactory.PAIRTABLE[i] = s = new String(new byte[]{(byte)(i / 256 & 0xFF), (byte)(i % 256 & 0xFF)}, 0, 0, 2).intern();
        }
        return s;
    }

    @Override
    public String get(CharSequence s) {
        switch (s.length()) {
            case 0: {
                return "";
            }
            case 1: {
                char c0 = s.charAt(0);
                if (c0 >= '\u0100') break;
                return BasicStringFactory.getCharString(c0);
            }
            case 2: {
                char c1;
                char c0 = s.charAt(0);
                if (c0 >= '\u0100' || (c1 = s.charAt(1)) >= '\u0100') break;
                return BasicStringFactory.getPairString(c0 * 256 + c1);
            }
        }
        return s.toString();
    }

    @Override
    public String get(CharArrayString s) {
        switch (s.length()) {
            case 0: {
                return "";
            }
            case 1: {
                char c0 = s.charAt(0);
                if (c0 >= '\u0100') break;
                return BasicStringFactory.getCharString(c0);
            }
            case 2: {
                char c1;
                char c0 = s.charAt(0);
                if (c0 >= '\u0100' || (c1 = s.charAt(1)) >= '\u0100') break;
                return BasicStringFactory.getPairString(c0 * 256 + c1);
            }
        }
        return s.toString();
    }

    @Override
    public String get(String s) {
        switch (s.length()) {
            case 0: {
                return "";
            }
            case 1: {
                char c0 = s.charAt(0);
                if (c0 >= '\u0100') break;
                return BasicStringFactory.getCharString(c0);
            }
            case 2: {
                char c1;
                char c0 = s.charAt(0);
                if (c0 >= '\u0100' || (c1 = s.charAt(1)) >= '\u0100') break;
                return BasicStringFactory.getPairString(c0 * 256 + c1);
            }
        }
        return s;
    }

    @Override
    public String get(char c) {
        if (c < '\u0100') {
            return BasicStringFactory.getCharString(c);
        }
        return String.valueOf(c);
    }

    @Override
    public String get(int codepoint) {
        if (codepoint >= 0 && codepoint < 256) {
            return BasicStringFactory.getCharString(codepoint);
        }
        return Character.toString(codepoint);
    }
}

