/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.collections;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.statet.internal.jcommons.collections.AbstractImList;
import org.eclipse.statet.internal.jcommons.collections.ArrayUtils;
import org.eclipse.statet.internal.jcommons.collections.ImArrayIdentityList;
import org.eclipse.statet.internal.jcommons.collections.ImArrayIdentitySet;
import org.eclipse.statet.internal.jcommons.collections.ImArrayList;
import org.eclipse.statet.internal.jcommons.collections.ImArraySet;
import org.eclipse.statet.internal.jcommons.collections.ImEmptyIdentityList;
import org.eclipse.statet.internal.jcommons.collections.ImEmptyIdentitySet;
import org.eclipse.statet.internal.jcommons.collections.ImEmptyList;
import org.eclipse.statet.internal.jcommons.collections.ImEmptySet;
import org.eclipse.statet.internal.jcommons.collections.ImIntArrayList;
import org.eclipse.statet.internal.jcommons.collections.ImIntEmptyList;
import org.eclipse.statet.internal.jcommons.collections.ImIntSeqList;
import org.eclipse.statet.internal.jcommons.collections.ImIntSingletonList;
import org.eclipse.statet.internal.jcommons.collections.ImLongArrayList;
import org.eclipse.statet.internal.jcommons.collections.ImLongEmptyList;
import org.eclipse.statet.internal.jcommons.collections.ImLongSeqList;
import org.eclipse.statet.internal.jcommons.collections.ImLongSingletonList;
import org.eclipse.statet.internal.jcommons.collections.ImSingletonIdentityList;
import org.eclipse.statet.internal.jcommons.collections.ImSingletonIdentitySet;
import org.eclipse.statet.internal.jcommons.collections.ImSingletonList;
import org.eclipse.statet.internal.jcommons.collections.ImSingletonSet;
import org.eclipse.statet.jcommons.collections.IdentityCollection;
import org.eclipse.statet.jcommons.collections.IdentityList;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.collections.ImIdentitySet;
import org.eclipse.statet.jcommons.collections.ImIntList;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.collections.ImLongList;
import org.eclipse.statet.jcommons.collections.ImSequencedIdentitySet;
import org.eclipse.statet.jcommons.collections.ImSequencedSet;
import org.eclipse.statet.jcommons.collections.ImSet;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.collections.LongList;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.NullDefaultLocation;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault(value={NullDefaultLocation.PARAMETER, NullDefaultLocation.RETURN_TYPE, NullDefaultLocation.FIELD})
public final class ImCollections {
    public static <E> ImList<E> emptyList() {
        return ImEmptyList.INSTANCE;
    }

    public static <E> ImList<E> newList() {
        return ImEmptyList.INSTANCE;
    }

    public static <E> ImList<E> newList(E e) {
        return new ImSingletonList<E>(e);
    }

    @SafeVarargs
    public static <E> ImList<E> newList(E ... e) {
        if (e.length == 0) {
            return ImEmptyList.INSTANCE;
        }
        if (e.length == 1) {
            return new ImSingletonList<E>(e[0]);
        }
        return new ImArrayList<E>(e);
    }

    public static <E> ImList<E> newList(E[] e, int startIdx, int length) {
        if (length == 0) {
            return ImEmptyList.INSTANCE;
        }
        if (length == 1) {
            return new ImSingletonList<E>(e[startIdx]);
        }
        if (length == e.length && startIdx == 0) {
            return new ImArrayList<E>(e);
        }
        return new ImArrayList<E>(Arrays.copyOfRange(e, startIdx, startIdx + length));
    }

    public static <E> ImList<E> newList(E[] e, @Nullable Comparator<? super E> comparator) {
        int n = e.length;
        if (n == 0) {
            return ImEmptyList.INSTANCE;
        }
        if (n == 1) {
            return new ImSingletonList<E>(e[0]);
        }
        Arrays.sort(e, comparator);
        return new ImArrayList<E>(e);
    }

    public static <E> ImList<E> toList(Collection<? extends E> c) {
        if (c instanceof AbstractImList) {
            return ((AbstractImList)((Object)c)).toList();
        }
        int n = c.size();
        if (n == 0) {
            return ImEmptyList.INSTANCE;
        }
        if (n == 1) {
            return new ImSingletonList(c instanceof List ? ((List)c).get(0) : c.toArray()[0]);
        }
        return new ImArrayList<Object>(c.toArray());
    }

    public static <E> ImList<E> toList(Iterable<? extends E> iterable) {
        if (iterable instanceof Collection) {
            return ImCollections.toList((Collection)iterable);
        }
        Iterator<E> iter = iterable.iterator();
        if (!iter.hasNext()) {
            return ImEmptyList.INSTANCE;
        }
        E first = iter.next();
        if (!iter.hasNext()) {
            return new ImSingletonList<E>(first);
        }
        ArrayList<E> list = new ArrayList<E>();
        list.add(first);
        do {
            list.add(iter.next());
        } while (iter.hasNext());
        return new ImArrayList<Object>(list.toArray());
    }

    public static <E> ImList<E> toList(E[] e, int startIdx, int length) {
        if (length == 0) {
            return ImEmptyList.INSTANCE;
        }
        if (length == 1) {
            return new ImSingletonList<E>(e[startIdx]);
        }
        return new ImArrayList<E>(Arrays.copyOfRange(e, startIdx, startIdx + length));
    }

    public static <E> ImList<E> toList(Collection<? extends E> c, @Nullable Comparator<? super E> comparator) {
        int n = c.size();
        if (n == 0) {
            return ImEmptyList.INSTANCE;
        }
        if (n == 1) {
            return new ImSingletonList(c instanceof List ? ((List)c).get(0) : c.toArray()[0]);
        }
        Object[] a = c.toArray();
        Arrays.sort(a, comparator);
        return new ImArrayList<Object>(a);
    }

    public static <E> ImList<E> clearToList(Collection<? extends E> c) {
        ImList<? extends E> list = ImCollections.toList(c);
        c.clear();
        return list;
    }

    public static <E> ImList<@NonNull E> toNonNullList(Iterable<? extends E> iterable) {
        ImList<E> list = ImCollections.toList(iterable);
        int n = list.size();
        int i = 0;
        while (i < n) {
            if (list.get(i) == null) {
                throw new NullPointerException(String.format("[%1$s]", i));
            }
            ++i;
        }
        return list;
    }

    public static <E> ImList<E> concatList(Collection<? extends E> l1, Collection<? extends E> l2) {
        int n1 = l1.size();
        int n = n1 + l2.size();
        if (n == 0) {
            return ImEmptyList.INSTANCE;
        }
        if (n1 == 0) {
            return ImCollections.toList(l2);
        }
        if (n == n1) {
            return ImCollections.toList(l1);
        }
        Object[] a = new Object[n];
        ArrayUtils.copyTo(l1, a, 0);
        ArrayUtils.copyTo(l2, a, n1);
        return new ImArrayList<Object>(a);
    }

    public static <E> ImList<E> concatList(Collection<? extends E> l1, Collection<? extends E> l2, Collection<? extends E> l3) {
        int n1 = l1.size();
        int n12 = n1 + l2.size();
        int n = n12 + l3.size();
        if (n == 0) {
            return ImEmptyList.INSTANCE;
        }
        if (n12 == 0) {
            return ImCollections.toList(l3);
        }
        if (n == n1) {
            return ImCollections.toList(l1);
        }
        if (n1 == 0 && n == n12) {
            return ImCollections.toList(l2);
        }
        Object[] a = new Object[n];
        if (n1 != 0) {
            ArrayUtils.copyTo(l1, a, 0);
        }
        if (n12 != n1) {
            ArrayUtils.copyTo(l2, a, n1);
        }
        if (n != n12) {
            ArrayUtils.copyTo(l3, a, n12);
        }
        return new ImArrayList<Object>(a);
    }

    @SafeVarargs
    public static <E> ImList<E> concatList(Collection<? extends E> ... lists) {
        switch (lists.length) {
            case 0: {
                return ImEmptyList.INSTANCE;
            }
            case 1: {
                return ImCollections.toList(lists[0]);
            }
            case 2: {
                return ImCollections.concatList(lists[0], lists[1]);
            }
            case 3: {
                return ImCollections.concatList(lists[0], lists[1], lists[2]);
            }
        }
        int n = 0;
        int i = 0;
        while (i < lists.length) {
            n += lists[i].size();
            ++i;
        }
        Object[] a = new Object[n];
        n = 0;
        int i2 = 0;
        while (i2 < lists.length) {
            int ni = lists[i2].size();
            if (ni != 0) {
                ArrayUtils.copyTo(lists[i2], a, n);
                n += ni;
            }
            ++i2;
        }
        return ImCollections.newList(a);
    }

    public static <E> ImList<E> concatList(Collection<? extends E> l1, Collection<? extends E> l2, @Nullable Comparator<? super E> comparator) {
        int n1 = l1.size();
        int n = n1 + l2.size();
        if (n == 0) {
            return ImEmptyList.INSTANCE;
        }
        if (n1 == 0) {
            return ImCollections.toList(l2, comparator);
        }
        if (n == n1) {
            return ImCollections.toList(l1, comparator);
        }
        Object[] a = new Object[n];
        ArrayUtils.copyTo(l1, a, 0);
        ArrayUtils.copyTo(l2, a, n1);
        Arrays.sort(a, comparator);
        return new ImArrayList<Object>(a);
    }

    public static <E> ImList<E> concatList(@NonNull Collection<? extends E>[] lists, @Nullable Comparator<? super E> comparator) {
        switch (lists.length) {
            case 0: {
                return ImEmptyList.INSTANCE;
            }
            case 1: {
                return ImCollections.toList(lists[0], comparator);
            }
            case 2: {
                return ImCollections.concatList(lists[0], lists[1], comparator);
            }
        }
        int n = 0;
        int i = 0;
        while (i < lists.length) {
            n += lists[i].size();
            ++i;
        }
        Object[] a = new Object[n];
        n = 0;
        int i2 = 0;
        while (i2 < lists.length) {
            ArrayUtils.copyTo(lists[i2], a, n);
            n += lists[i2].size();
            ++i2;
        }
        Arrays.sort(a, comparator);
        return ImCollections.newList(a);
    }

    public static <E> ImList<E> addElement(List<? extends E> l, int index, E e) {
        int n1 = l.size();
        if (index < 0 || index > n1) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if (n1 == 0) {
            return new ImSingletonList<E>(e);
        }
        return new ImArrayList<E>(ArrayUtils.copyAddElement(l, n1, index, e));
    }

    public static <E> ImList<E> addElement(List<? extends E> l, E e) {
        int n1 = l.size();
        if (n1 == 0) {
            return new ImSingletonList<E>(e);
        }
        return new ImArrayList<E>(ArrayUtils.copyAddElement(l, n1, e));
    }

    public static <E> ImList<E> addElementIfAbsent(List<? extends E> l, E e) {
        int n1 = l.size();
        if (n1 == 0) {
            return new ImSingletonList<E>(e);
        }
        if (!l.contains(e)) {
            return new ImArrayList<E>(ArrayUtils.copyAddElement(l, n1, e));
        }
        return ImCollections.toList(l);
    }

    public static <E> ImList<E> addElementIfAbsent(ImList<? extends E> l, E e) {
        int n1 = l.size();
        if (n1 == 0) {
            return new ImSingletonList<E>(e);
        }
        if (!l.contains(e)) {
            return new ImArrayList<E>(ArrayUtils.copyAddElement(l, n1, e));
        }
        return l;
    }

    public static <E> ImList<E> addElementIfAbsent(List<? extends E> l, E e, @Nullable Comparator<? super E> comparator) {
        if (l.isEmpty()) {
            return new ImSingletonList<E>(e);
        }
        int index = Collections.binarySearch(l, e, comparator);
        if (index < 0) {
            return ImCollections.addElement(l, -(index + 1), e);
        }
        return ImCollections.toList(l);
    }

    public static <E> ImList<E> setElement(List<? extends E> l, int index, E e) {
        int n = l.size();
        if (index < 0 || index >= n) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if (n == 1) {
            return new ImSingletonList<E>(e);
        }
        Object[] a = l.toArray();
        a[index] = e;
        return new ImArrayList<Object>(a);
    }

    public static <E> ImList<E> removeElement(List<? extends E> l, @Nullable Object e) {
        int index = l.indexOf(e);
        if (index < 0) {
            return ImCollections.toList(l);
        }
        int n = l.size() - 1;
        if (n == 0) {
            return ImEmptyList.INSTANCE;
        }
        if (n == 1) {
            return new ImSingletonList<E>(l.get(index == 0 ? 1 : 0));
        }
        return new ImArrayList<E>(ArrayUtils.copyRemoveElement(l, n, index));
    }

    public static <E> ImList<E> removeElement(ImList<? extends E> l, @Nullable Object e) {
        int index = l.indexOf(e);
        if (index < 0) {
            return l;
        }
        int n = l.size() - 1;
        if (n == 0) {
            return ImEmptyList.INSTANCE;
        }
        if (n == 1) {
            return new ImSingletonList(l.get(index == 0 ? 1 : 0));
        }
        return new ImArrayList<E>(ArrayUtils.copyRemoveElement(l, n, index));
    }

    public static <E> ImList<E> removeElement(List<? extends E> l, int index) {
        int n = l.size() - 1;
        if (index < 0 || index > n) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if (n == 0) {
            return ImEmptyList.INSTANCE;
        }
        if (n == 1) {
            return new ImSingletonList<E>(l.get(index == 0 ? 1 : 0));
        }
        return new ImArrayList<E>(ArrayUtils.copyRemoveElement(l, n, index));
    }

    public static <E> ImIdentityList<E> emptyIdentityList() {
        return ImEmptyIdentityList.INSTANCE;
    }

    public static <E> ImIdentityList<E> newIdentityList() {
        return ImEmptyIdentityList.INSTANCE;
    }

    public static <E> ImIdentityList<E> newIdentityList(E e) {
        return new ImSingletonIdentityList<E>(e);
    }

    @SafeVarargs
    public static <E> ImIdentityList<E> newIdentityList(E ... e) {
        if (e.length == 0) {
            return ImEmptyIdentityList.INSTANCE;
        }
        if (e.length == 1) {
            return new ImSingletonIdentityList<E>(e[0]);
        }
        return new ImArrayIdentityList<E>(e);
    }

    public static <E> ImIdentityList<E> newIdentityList(E[] e, int startIdx, int length) {
        if (length == 0) {
            return ImEmptyIdentityList.INSTANCE;
        }
        if (length == 1) {
            return new ImSingletonIdentityList<E>(e[startIdx]);
        }
        if (length == e.length && startIdx == 0) {
            return new ImArrayIdentityList<E>(e);
        }
        return new ImArrayIdentityList<E>(Arrays.copyOfRange(e, startIdx, startIdx + length));
    }

    public static <E> ImIdentityList<E> toIdentityList(Collection<? extends E> c) {
        if (c instanceof AbstractImList) {
            return ((AbstractImList)((Object)c)).toIdentityList();
        }
        int n = c.size();
        if (n == 0) {
            return ImEmptyIdentityList.INSTANCE;
        }
        if (n == 1) {
            return new ImSingletonIdentityList<E>(c instanceof List ? ((List)c).get(0) : c.iterator().next());
        }
        return new ImArrayIdentityList<Object>(c.toArray());
    }

    public static <E> ImIdentityList<E> concatList(IdentityCollection<? extends E> l1, IdentityCollection<? extends E> l2) {
        int n1 = l1.size();
        int n = n1 + l2.size();
        if (n == 0) {
            return ImEmptyIdentityList.INSTANCE;
        }
        if (n1 == 0) {
            return ImCollections.toIdentityList(l2);
        }
        if (n == n1) {
            return ImCollections.toIdentityList(l1);
        }
        Object[] a = new Object[n];
        ArrayUtils.copyTo(l1, a, 0);
        ArrayUtils.copyTo(l2, a, n1);
        return new ImArrayIdentityList<Object>(a);
    }

    public static <E> ImIdentityList<E> addElement(IdentityList<? extends E> l, int index, E e) {
        int n1 = l.size();
        if (index < 0 || index > n1) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if (n1 == 0) {
            return new ImSingletonIdentityList<E>(e);
        }
        return new ImArrayIdentityList<E>(ArrayUtils.copyAddElement(l, n1, index, e));
    }

    public static <E> ImIdentityList<E> addElement(IdentityList<? extends E> l, E e) {
        int n1 = l.size();
        if (n1 == 0) {
            return new ImSingletonIdentityList<E>(e);
        }
        return new ImArrayIdentityList<E>(ArrayUtils.copyAddElement(l, n1, e));
    }

    public static <E> ImIdentityList<E> addElementIfAbsent(IdentityList<? extends E> l, E e) {
        int n1 = l.size();
        if (n1 == 0) {
            return new ImSingletonIdentityList<E>(e);
        }
        if (!l.contains(e)) {
            return new ImArrayIdentityList<E>(ArrayUtils.copyAddElement(l, n1, e));
        }
        return ImCollections.toIdentityList(l);
    }

    public static <E> ImIdentityList<E> addElementIfAbsent(ImIdentityList<? extends E> l, E e) {
        int n1 = l.size();
        if (n1 == 0) {
            return new ImSingletonIdentityList<E>(e);
        }
        if (!l.contains(e)) {
            return new ImArrayIdentityList<E>(ArrayUtils.copyAddElement(l, n1, e));
        }
        return l;
    }

    public static <E> ImIdentityList<E> removeElement(IdentityList<? extends E> l, @Nullable Object e) {
        int index = l.indexOf(e);
        if (index < 0) {
            return ImCollections.toIdentityList(l);
        }
        int n = l.size() - 1;
        if (n == 0) {
            return ImEmptyIdentityList.INSTANCE;
        }
        if (n == 1) {
            return new ImSingletonIdentityList(l.get(index == 0 ? 1 : 0));
        }
        return new ImArrayIdentityList<E>(ArrayUtils.copyRemoveElement(l, n, index));
    }

    public static <E> ImIdentityList<E> removeElement(ImIdentityList<? extends E> l, @Nullable Object e) {
        int index = l.indexOf(e);
        if (index < 0) {
            return l;
        }
        int n = l.size() - 1;
        if (n == 0) {
            return ImEmptyIdentityList.INSTANCE;
        }
        if (n == 1) {
            return new ImSingletonIdentityList(l.get(index == 0 ? 1 : 0));
        }
        return new ImArrayIdentityList<E>(ArrayUtils.copyRemoveElement(l, n, index));
    }

    public static <E> ImIdentityList<E> removeElement(IdentityList<? extends E> l, int index) {
        int n = l.size() - 1;
        if (index < 0 || index > n) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if (n == 0) {
            return ImEmptyIdentityList.INSTANCE;
        }
        if (n == 1) {
            return new ImSingletonIdentityList(l.get(index == 0 ? 1 : 0));
        }
        return new ImArrayIdentityList<E>(ArrayUtils.copyRemoveElement(l, n, index));
    }

    public static <E> ImIdentityList<E> removeLastElement(IdentityList<? extends E> l, Object e) {
        int index = l.lastIndexOf(e);
        if (index < 0) {
            return ImCollections.toIdentityList(l);
        }
        int n = l.size() - 1;
        if (n == 0) {
            return ImEmptyIdentityList.INSTANCE;
        }
        if (n == 1) {
            return new ImSingletonIdentityList(l.get(index == 0 ? 1 : 0));
        }
        return new ImArrayIdentityList<E>(ArrayUtils.copyRemoveElement(l, n, index));
    }

    public static <E> ImIdentityList<E> removeLastElement(ImIdentityList<? extends E> l, Object e) {
        int index = l.lastIndexOf(e);
        if (index < 0) {
            return l;
        }
        int n = l.size() - 1;
        if (n == 0) {
            return ImEmptyIdentityList.INSTANCE;
        }
        if (n == 1) {
            return new ImSingletonIdentityList(l.get(index == 0 ? 1 : 0));
        }
        return new ImArrayIdentityList<E>(ArrayUtils.copyRemoveElement(l, n, index));
    }

    public static <E> ImSequencedSet<E> emptySet() {
        return ImEmptySet.INSTANCE;
    }

    public static <E> ImSequencedSet<E> newSet() {
        return ImEmptySet.INSTANCE;
    }

    public static <E> ImSequencedSet<E> newSet(E e) {
        return new ImSingletonSet<E>(e);
    }

    private static <E> ImSequencedSet<E> newSetFromArray(E[] array, int startIdx, int endIdx) {
        int idx = startIdx + 1;
        while (idx < endIdx) {
            if (ArrayUtils.containsEqual(array, startIdx, idx, array[idx])) {
                Object[] checked = (Object[])Array.newInstance(array.getClass().getComponentType(), endIdx - startIdx - 1);
                System.arraycopy(array, startIdx, checked, 0, idx - startIdx);
                int length = idx++;
                while (idx < endIdx) {
                    if (!ArrayUtils.containsEqual(checked, 0, length, array[idx])) {
                        checked[length++] = array[idx];
                    }
                    ++idx;
                }
                if (length == 1) {
                    return new ImSingletonSet<Object>(checked[0]);
                }
                if (length == checked.length) {
                    return new ImArraySet<Object>(checked);
                }
                return new ImArraySet<Object>(Arrays.copyOfRange(checked, 0, length));
            }
            ++idx;
        }
        return new ImArraySet<E>(array);
    }

    @SafeVarargs
    public static <E> ImSequencedSet<E> newSet(E ... e) {
        if (e.length == 0) {
            return ImEmptySet.INSTANCE;
        }
        if (e.length == 1) {
            return new ImSingletonSet<E>(e[0]);
        }
        return ImCollections.newSetFromArray(e, 0, e.length);
    }

    public static <E> ImSequencedSet<E> newSet(E[] e, int startIdx, int length) {
        if (length == 0) {
            return ImEmptySet.INSTANCE;
        }
        if (length == 1) {
            return new ImSingletonSet<E>(e[startIdx]);
        }
        return ImCollections.newSetFromArray(e, startIdx, startIdx + length);
    }

    public static <E> ImSet<E> toSet(Collection<? extends E> c) {
        if (c instanceof ImSet) {
            return (ImSet)c;
        }
        int n = c.size();
        if (n == 0) {
            return ImEmptySet.INSTANCE;
        }
        if (n == 1) {
            return new ImSingletonSet<E>(c instanceof List ? ((List)c).get(0) : c.iterator().next());
        }
        return ImCollections.newSetFromArray(c.toArray(), 0, n);
    }

    public static <E> ImSet<@NonNull E> toNonNullSet(Collection<? extends E> c) {
        ImSet<E> set = ImCollections.toSet(c);
        int i = 0;
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            if (iter.next() == null) {
                throw new NullPointerException(String.format("[%1$s]", i));
            }
            ++i;
        }
        return set;
    }

    public static <E> ImSet<E> addElement(Set<? extends E> l, E e) {
        int n1 = l.size();
        if (n1 == 0) {
            return new ImSingletonSet<E>(e);
        }
        if (!l.contains(e)) {
            return new ImArraySet<E>(ArrayUtils.copyAddElement(l, n1, e));
        }
        return ImCollections.toSet(l);
    }

    public static <E> ImSet<E> addElement(ImSet<? extends E> l, E e) {
        int n1 = l.size();
        if (n1 == 0) {
            return new ImSingletonSet<E>(e);
        }
        if (!l.contains(e)) {
            return new ImArraySet<E>(ArrayUtils.copyAddElement(l, n1, e));
        }
        return l;
    }

    public static <E> ImSequencedSet<E> addElement(ImSequencedSet<? extends E> l, E e) {
        int n1 = l.size();
        if (n1 == 0) {
            return new ImSingletonSet<E>(e);
        }
        if (!l.contains(e)) {
            return new ImArraySet<E>(ArrayUtils.copyAddElement(l, n1, e));
        }
        return l;
    }

    public static <E> ImSequencedIdentitySet<E> emptyIdentitySet() {
        return ImEmptyIdentitySet.INSTANCE;
    }

    public static <E> ImSequencedIdentitySet<E> newIdentitySet() {
        return ImEmptyIdentitySet.INSTANCE;
    }

    public static <E> ImSequencedIdentitySet<E> newIdentitySet(E e) {
        return new ImSingletonIdentitySet<E>(e);
    }

    private static <E> ImSequencedIdentitySet<E> newIdentitySetFromArray(E[] array, int startIdx, int endIdx) {
        int idx = startIdx + 1;
        while (idx < endIdx) {
            if (ArrayUtils.containsIdentical(array, startIdx, idx, array[idx])) {
                Object[] checked = (Object[])Array.newInstance(array.getClass().getComponentType(), endIdx - startIdx - 1);
                System.arraycopy(array, startIdx, checked, 0, idx - startIdx);
                int length = idx++;
                while (idx < endIdx) {
                    if (!ArrayUtils.containsIdentical(checked, 0, length, array[idx])) {
                        checked[length++] = array[idx];
                    }
                    ++idx;
                }
                if (length == 1) {
                    return new ImSingletonIdentitySet<Object>(checked[0]);
                }
                if (length == checked.length) {
                    return new ImArrayIdentitySet<Object>(checked);
                }
                return new ImArrayIdentitySet<Object>(Arrays.copyOfRange(checked, 0, length));
            }
            ++idx;
        }
        return new ImArrayIdentitySet<E>(array);
    }

    @SafeVarargs
    public static <E> ImSequencedIdentitySet<E> newIdentitySet(E ... e) {
        if (e.length == 0) {
            return ImEmptyIdentitySet.INSTANCE;
        }
        if (e.length == 1) {
            return new ImSingletonIdentitySet<E>(e[0]);
        }
        return ImCollections.newIdentitySetFromArray(e, 0, e.length);
    }

    public static <E> ImSequencedIdentitySet<E> newIdentitySet(E[] e, int startIdx, int length) {
        if (length == 0) {
            return ImEmptyIdentitySet.INSTANCE;
        }
        if (length == 1) {
            return new ImSingletonIdentitySet<E>(e[startIdx]);
        }
        return ImCollections.newIdentitySetFromArray(e, startIdx, startIdx + length);
    }

    public static <E> ImIdentitySet<E> toIdentitySet(Collection<? extends E> c) {
        if (c instanceof ImSet) {
            return (ImIdentitySet)c;
        }
        int n = c.size();
        if (n == 0) {
            return ImEmptyIdentitySet.INSTANCE;
        }
        if (n == 1) {
            return new ImSingletonIdentitySet<E>(c instanceof List ? ((List)c).get(0) : c.iterator().next());
        }
        return ImCollections.newIdentitySetFromArray(c.toArray(), 0, n);
    }

    public static ImIntList emptyIntList() {
        return ImIntEmptyList.INSTANCE;
    }

    public static ImIntList newIntList() {
        return ImIntEmptyList.INSTANCE;
    }

    public static ImIntList newIntList(int e) {
        return new ImIntSingletonList(e);
    }

    @SafeVarargs
    public static ImIntList newIntList(int ... e) {
        if (e.length == 0) {
            return ImIntEmptyList.INSTANCE;
        }
        if (e.length == 1) {
            return new ImIntSingletonList(e[0]);
        }
        return new ImIntArrayList(e);
    }

    public static ImIntList newIntList(int[] e, int startIdx, int length) {
        if (length == 0) {
            return ImIntEmptyList.INSTANCE;
        }
        if (length == 1) {
            return new ImIntSingletonList(e[startIdx]);
        }
        if (length == e.length && startIdx == 0) {
            return new ImIntArrayList(e);
        }
        return new ImIntArrayList(Arrays.copyOfRange(e, startIdx, startIdx + length));
    }

    public static ImIntList newIntSequence(int start, int end) {
        int length = end - start;
        if (length < 0) {
            throw new IllegalArgumentException("start, end");
        }
        if (length == 0) {
            return ImIntEmptyList.INSTANCE;
        }
        if (length == 1) {
            return new ImIntSingletonList(start);
        }
        return new ImIntSeqList(start, length);
    }

    public static ImIntList toIntList(IntList c) {
        if (c instanceof ImIntList) {
            return (ImIntList)c;
        }
        int n = c.size();
        if (n == 0) {
            return ImIntEmptyList.INSTANCE;
        }
        if (n == 1) {
            return new ImIntSingletonList(c.getFirst());
        }
        return new ImIntArrayList(c.toArray());
    }

    public static ImIntList repeat(IntList c, int times) {
        if (times < 0) {
            throw new IllegalArgumentException("times");
        }
        if (times == 0) {
            return ImIntEmptyList.INSTANCE;
        }
        if (times == 1) {
            return ImCollections.toIntList(c);
        }
        return new ImIntArrayList(ArrayUtils.repeat(c, times));
    }

    public static <E> ImIntList addElement(IntList l, int index, int e) {
        int n1 = l.size();
        if (index < 0 || index > n1) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if (n1 == 0) {
            return new ImIntSingletonList(e);
        }
        return new ImIntArrayList(ArrayUtils.copyAddElement(l, n1, index, e));
    }

    public static ImIntList addElement(IntList l, int e) {
        int n1 = l.size();
        if (n1 == 0) {
            return new ImIntSingletonList(e);
        }
        return new ImIntArrayList(ArrayUtils.copyAddElement(l, n1, e));
    }

    public static ImLongList emptyLongList() {
        return ImLongEmptyList.INSTANCE;
    }

    public static ImLongList newLongList() {
        return ImLongEmptyList.INSTANCE;
    }

    public static ImLongList newLongList(long e) {
        return new ImLongSingletonList(e);
    }

    @SafeVarargs
    public static ImLongList newLongList(long ... e) {
        if (e.length == 0) {
            return ImLongEmptyList.INSTANCE;
        }
        if (e.length == 1) {
            return new ImLongSingletonList(e[0]);
        }
        return new ImLongArrayList(e);
    }

    public static ImLongList newLongList(long[] e, int startIdx, int length) {
        if (length == 0) {
            return ImLongEmptyList.INSTANCE;
        }
        if (length == 1) {
            return new ImLongSingletonList(e[startIdx]);
        }
        if (length == e.length && startIdx == 0) {
            return new ImLongArrayList(e);
        }
        return new ImLongArrayList(Arrays.copyOfRange(e, startIdx, startIdx + length));
    }

    public static ImLongList newLongSequence(int start, int end) {
        long length = end - start;
        if (length < 0L || length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("start, end");
        }
        if (length == 0L) {
            return ImLongEmptyList.INSTANCE;
        }
        if (length == 1L) {
            return new ImLongSingletonList(start);
        }
        return new ImLongSeqList(start, (int)length);
    }

    public static ImLongList toLongList(LongList c) {
        if (c instanceof ImLongList) {
            return (ImLongList)c;
        }
        int n = c.size();
        if (n == 0) {
            return ImLongEmptyList.INSTANCE;
        }
        if (n == 1) {
            return new ImLongSingletonList(c.getFirst());
        }
        return new ImLongArrayList(c.toArray());
    }

    public static ImLongList repeat(LongList c, int times) {
        if (times < 0) {
            throw new IllegalArgumentException("times");
        }
        if (times == 0) {
            return ImLongEmptyList.INSTANCE;
        }
        if (times == 1) {
            return ImCollections.toLongList(c);
        }
        return new ImLongArrayList(ArrayUtils.repeat(c, times));
    }

    public static <E> ImLongList addElement(LongList l, int index, long e) {
        int n1 = l.size();
        if (index < 0 || index > n1) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if (n1 == 0) {
            return new ImLongSingletonList(e);
        }
        return new ImLongArrayList(ArrayUtils.copyAddElement(l, n1, index, e));
    }

    public static ImLongList addElement(LongList l, long e) {
        int n1 = l.size();
        if (n1 == 0) {
            return new ImLongSingletonList(e);
        }
        return new ImLongArrayList(ArrayUtils.copyAddElement(l, n1, e));
    }

    private ImCollections() {
    }
}

