/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import java.util.List;
import org.eclipse.statet.ecommons.ui.components.IIntValueListener;
import org.eclipse.statet.ecommons.ui.components.IIntValueWidget;
import org.eclipse.statet.ecommons.ui.components.IntValueEvent;
import org.eclipse.statet.ecommons.ui.swt.AutoDisposeReference;
import org.eclipse.statet.ecommons.ui.swt.ColorUtils;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

@NonNullByDefault
public class WaScale
extends Composite
implements IIntValueWidget {
    private static @Nullable StyleData gDefaultStyleData;
    private static @Nullable StyleData gFlatStyleData;
    private final int thisStyle;
    private final StyleData styleData;
    private Color color1;
    private Color color2;
    private Color rangeColor;
    private Color rangeFocusColor;
    private Color tickColor;
    private Rectangle scaleArea;
    private int minimum = 1;
    private int maximum = 100;
    private int increment = 1;
    private int pageIncrement = 10;
    private ImList<Knob> knobs;
    private final CopyOnWriteIdentityListSet<IIntValueListener> selectionListeners = new CopyOnWriteIdentityListSet();
    private boolean isActive;
    private int opInProgress;
    private int opButton;
    private int opSavedValue;
    private int opOffset;
    private final FocusListener buttonFocusListener = new FocusListener(){

        public void focusGained(FocusEvent event) {
            Control[] children = WaScale.this.getChildren();
            if (children[0] == event.widget) {
                return;
            }
            ((Button)event.widget).moveAbove(children[0]);
        }

        public void focusLost(FocusEvent event) {
        }
    };
    private final PaintListener buttonPaintListener = new PaintListener(){

        public void paintControl(PaintEvent event) {
            WaScale.this.paintKnob(event);
        }
    };
    private final Listener buttonKnobMoveListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 31) {
                switch (event.keyCode) {
                    case 0x1000001: 
                    case 0x1000002: 
                    case 0x1000003: 
                    case 0x1000004: {
                        event.doit = false;
                        return;
                    }
                }
                return;
            }
            WaScale.this.moveKnob(event);
        }
    };

    private static int checkSWTStyle(int style) {
        return style &= 0xFFFFFCFF;
    }

    private static int checkThisStyle(int style, int swtStyle) {
        if (((style &= 0x300) & 0x100) != 0) {
            style &= 0xFFFFFDFF;
        }
        return style |= swtStyle & 0x800000;
    }

    public WaScale(Composite parent, int style) {
        super(parent, WaScale.checkSWTStyle(style));
        this.thisStyle = WaScale.checkThisStyle(style, this.getStyle());
        this.styleData = this.createStyle();
        this.knobs = ImCollections.emptyList();
        this.updateColors();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                WaScale.this.paint(event);
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 26: {
                        WaScale.this.isActive = true;
                        WaScale.this.redraw();
                        return;
                    }
                    case 27: {
                        WaScale.this.isActive = false;
                        WaScale.this.redraw();
                        return;
                    }
                    case 11: {
                        WaScale.this.updateLayout();
                        return;
                    }
                    case 12: {
                        WaScale.this.onDispose();
                        return;
                    }
                }
            }
        };
        this.addListener(26, listener);
        this.addListener(27, listener);
        this.addListener(11, listener);
        this.addListener(12, listener);
        this.initKnobs();
    }

    private StyleData createStyle() {
        StyleData data;
        if ((this.thisStyle & 0x800000) != 0) {
            data = gFlatStyleData;
            if (data == null) {
                gFlatStyleData = data = new StyleData(this.getDisplay(), 0x800000);
            }
        } else {
            data = gDefaultStyleData;
            if (data == null) {
                gDefaultStyleData = data = new StyleData(this.getDisplay(), 0);
            }
        }
        return data;
    }

    @Override
    public Control getControl() {
        return this;
    }

    protected void initKnobs() {
        this.setKnobs((ImList<Knob>)ImCollections.newList((Object[])new Knob[]{new Knob(this.getMinimum()), new Knob(this.getMaximum())}));
    }

    protected void setKnobs(ImList<Knob> knobs) {
        this.stopOperations(0);
        if (this.knobs != null) {
            for (Knob knob : knobs) {
                if (knob.button == null) continue;
                knob.button.dispose();
                knob.button = null;
            }
        }
        Control[] tabList = new Control[knobs.size()];
        boolean enabled = this.getEnabled();
        int idx = 0;
        while (idx < knobs.size()) {
            Knob knob = (Knob)knobs.get(idx);
            ((Knob)knobs.get((int)idx)).idx = idx;
            knob.button = this.createKnobControl(knob);
            if (!enabled) {
                knob.button.setEnabled(false);
            }
            tabList[idx] = knob.button;
            ++idx;
        }
        this.knobs = knobs;
        this.setTabList(tabList);
        this.recheckKnobValues();
        this.updateLayout();
    }

    protected List<Knob> getKnobs() {
        return this.knobs;
    }

    private void recheckKnobValues() {
        ImList<Knob> knobs = this.knobs;
        int i = 0;
        while (i < knobs.size()) {
            Knob knob = (Knob)knobs.get(i);
            knob.setValue(0, knob.getValue());
            ++i;
        }
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public void setMinimum(int value) {
        this.checkWidget();
        this.minimum = value;
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public void setMaximum(int value) {
        this.checkWidget();
        this.maximum = value;
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public void setPageIncrement(int increment) {
        this.checkWidget();
        this.pageIncrement = increment;
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public void setIncrement(int increment) {
        this.checkWidget();
        this.increment = increment;
    }

    @Override
    public int getValue(int knobIdx) {
        return ((Knob)this.knobs.get(knobIdx)).getValue();
    }

    @Override
    public void setValue(int knobIdx, int value) {
        ((Knob)this.knobs.get(knobIdx)).setValue(0, value);
        this.updateButtonPositions();
        this.redraw();
    }

    @Override
    public void addValueListener(IIntValueListener listener) {
        this.selectionListeners.add((Object)((IIntValueListener)ObjectUtils.nonNullAssert((Object)listener)));
    }

    @Override
    public void removeValueListener(IIntValueListener listener) {
        this.selectionListeners.remove((Object)listener);
    }

    private int fireAboutToChange(int time, int knobIdx, int oldValue, int newValue) {
        if (time == 0) {
            return newValue;
        }
        IntValueEvent scaleEvent = new IntValueEvent((Control)this, time, knobIdx, oldValue, newValue);
        for (IIntValueListener listener : this.selectionListeners) {
            listener.valueAboutToChange(scaleEvent);
        }
        return scaleEvent.newValue;
    }

    private void fireChanged(int time, int knobIdx, int oldValue, int newValue) {
        if (time == 0) {
            return;
        }
        IntValueEvent scaleEvent = new IntValueEvent((Control)this, time, knobIdx, oldValue, newValue);
        for (IIntValueListener listener : this.selectionListeners) {
            scaleEvent.newValue = newValue;
            listener.valueChanged(scaleEvent);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.getEnabled() == enabled) {
            return;
        }
        ImList<Knob> knobs = this.knobs;
        if (!enabled) {
            int idx = 0;
            while (idx < knobs.size()) {
                Knob knob = (Knob)knobs.get(idx);
                knob.savedEnabled = knob.button.getEnabled();
                knob.button.setEnabled(false);
                ++idx;
            }
        } else {
            int idx = 0;
            while (idx < knobs.size()) {
                Knob knob = (Knob)knobs.get(idx);
                knob.button.setEnabled(knob.savedEnabled);
                ++idx;
            }
        }
    }

    protected int convertClient2Value(int coord) {
        Rectangle scaleArea = this.scaleArea;
        double tmp = coord - scaleArea.x;
        tmp /= (double)scaleArea.width;
        tmp *= (double)this.maximum - (double)this.minimum;
        return (int)(tmp += (double)this.minimum);
    }

    protected int convertValue2Client(int value) {
        Rectangle scaleArea = this.scaleArea;
        double tmp = value - this.minimum;
        tmp /= (double)this.maximum - (double)this.minimum;
        int scale = (int)(tmp *= (double)scaleArea.width);
        if (tmp < 0.0) {
            scale = 0;
        }
        if (tmp > (double)scaleArea.width) {
            scale = scaleArea.width;
        }
        return scale + scaleArea.x;
    }

    protected final int getCoord(Event event) {
        return (this.thisStyle & 0x200) != 0 ? event.y : event.x;
    }

    protected final int getCoord(Point location) {
        return (this.thisStyle & 0x200) != 0 ? location.y : location.x;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (wHint < 0) {
            wHint = this.styleData.defaultWidth;
        } else if (wHint < this.styleData.minWidth) {
            wHint = this.styleData.minWidth;
        }
        Rectangle trim = this.computeTrim(0, 0, wHint, this.styleData.height);
        return new Point(trim.width, trim.height);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.updateColors();
    }

    protected void updateColors() {
        this.color1 = this.computeColor1();
        this.color2 = this.computeColor2();
        this.rangeColor = this.computeRangeColor(false);
        this.rangeFocusColor = this.computeRangeColor(true);
        this.tickColor = this.computeTickColor();
    }

    protected Color computeColor1() {
        Display display = this.getDisplay();
        Color color = display.getSystemColor(18);
        if (color.equals((Object)this.getBackground())) {
            color = display.getSystemColor(17);
        }
        return color;
    }

    protected Color getColor1() {
        return this.color1;
    }

    protected Color computeColor2() {
        Display display = this.getDisplay();
        Color color = display.getSystemColor(19);
        if (color.equals((Object)this.getBackground())) {
            color = display.getSystemColor(20);
        }
        return color;
    }

    protected Color getColor2() {
        return this.color2;
    }

    protected Color computeRangeColor(boolean focus) {
        Color color;
        Display display = this.getDisplay();
        if (focus) {
            color = ColorUtils.blend(this.getBackground(), display.getSystemColor(26), 0.5f);
        } else {
            color = display.getSystemColor(15);
            if (color.equals((Object)this.getBackground())) {
                color = display.getSystemColor(16);
            }
        }
        return color;
    }

    protected Color getRangeColor(boolean focus) {
        return focus ? this.rangeFocusColor : this.rangeColor;
    }

    protected Color computeTickColor() {
        return this.computeColor1();
    }

    protected Color getTickColor() {
        return this.tickColor;
    }

    private Button createKnobControl(Knob knob) {
        Button button = new Button((Composite)this, 8 | this.thisStyle & 0x800000);
        button.setSize(this.styleData.knobWidth, this.styleData.knobHeight);
        button.addFocusListener(this.buttonFocusListener);
        button.addPaintListener(this.buttonPaintListener);
        button.addListener(31, this.buttonKnobMoveListener);
        button.addListener(1, this.buttonKnobMoveListener);
        button.addListener(37, this.buttonKnobMoveListener);
        button.addListener(3, this.buttonKnobMoveListener);
        button.addListener(5, this.buttonKnobMoveListener);
        button.addListener(4, this.buttonKnobMoveListener);
        button.setData((Object)knob);
        button.setToolTipText(knob.toolTipText);
        Region shape = new Region((Device)button.getDisplay());
        shape.add(0, 0, this.styleData.knobWidth, this.styleData.knobHeight - 1);
        button.setRegion(shape);
        return button;
    }

    private void updateLayout() {
        Rectangle scaleArea = this.getClientArea();
        if ((this.thisStyle & 0x200) != 0) {
            scaleArea.x = scaleArea.y;
            scaleArea.width = scaleArea.height;
        }
        scaleArea.x += this.styleData.knobScaleOffset;
        scaleArea.width -= 2 * this.styleData.knobScaleOffset;
        this.scaleArea = scaleArea;
        this.updateButtonPositions();
    }

    private void updateButtonPositions() {
        ImList<Knob> knobs = this.knobs;
        if ((this.thisStyle & 0x200) != 0) {
            int idx = 0;
            while (idx < knobs.size()) {
                Knob knob = (Knob)knobs.get(idx);
                int y = this.convertValue2Client(knob.getValue()) - this.styleData.knobScaleOffset;
                knob.button.setLocation(0, y);
                ++idx;
            }
        } else {
            int idx = 0;
            while (idx < knobs.size()) {
                Knob knob = (Knob)knobs.get(idx);
                int x = this.convertValue2Client(knob.getValue()) - this.styleData.knobScaleOffset;
                knob.button.setLocation(x, 0);
                ++idx;
            }
        }
    }

    private void paint(PaintEvent e) {
        Rectangle clientArea = this.getClientArea();
        if (clientArea.width == 0 || clientArea.height == 0) {
            return;
        }
        GC gc = e.gc;
        gc.setBackground(this.getBackground());
        gc.fillRectangle(clientArea);
        if (clientArea.height < this.styleData.height || clientArea.width < this.styleData.knobWidth) {
            return;
        }
        gc.setLineWidth(1);
        gc.setForeground(this.getColor1());
        int x = clientArea.x + this.styleData.linePadding;
        int y = clientArea.y + this.styleData.knobHeight - 1;
        int width = clientArea.width - 2 * this.styleData.linePadding;
        gc.drawLine(x, y, x + width, y);
        gc.drawPoint(x, ++y);
        gc.setForeground(this.getColor2());
        gc.drawPoint(x + width, y);
        gc.drawLine(x, ++y, x + width, y);
        ++y;
        Rectangle scaleArea = this.scaleArea;
        width = scaleArea.width;
        y += 3;
        gc.setForeground(this.getTickColor());
        int count = 4;
        int i = 0;
        while (i <= 4) {
            x = scaleArea.x + width * i / 4;
            gc.drawLine(x, y, x, y + 3);
            ++i;
        }
        y = clientArea.y + this.styleData.knobHeight;
        this.paintRanges(gc, y);
        gc.setForeground(this.getDisplay().getSystemColor(2));
        i = 0;
        while (i < this.knobs.size()) {
            x = this.convertValue2Client(((Knob)this.knobs.get(i)).getValue());
            gc.drawPoint(x, y);
            ++i;
        }
    }

    protected void stopOperations(int time) {
        if (this.opInProgress == 0) {
            return;
        }
        this.opInProgress = 0;
        ((Knob)this.knobs.get(this.opButton)).setValue(time, this.opSavedValue);
        this.updateButtonPositions();
        this.redraw();
    }

    protected boolean isInOperation() {
        return false;
    }

    private void paintKnob(PaintEvent e) {
        GC gc = e.gc;
        gc.drawImage(this.styleData.knobLine, this.styleData.knobScaleOffset - 1, (1 + this.styleData.knobHeight) / 2);
    }

    protected void paintRanges(GC gc, int y) {
        if (this.knobs.size() == 2) {
            Knob knob0 = (Knob)this.knobs.getFirst();
            Knob knob1 = (Knob)this.knobs.getLast();
            gc.setForeground(this.getRangeColor(this.isActive && (knob0.button.isFocusControl() || knob1.button.isFocusControl())));
            gc.drawLine(this.convertValue2Client(((Knob)this.knobs.getFirst()).getValue()), y, this.convertValue2Client(((Knob)this.knobs.getLast()).getValue()), y);
        }
    }

    private void moveKnob(Event event) {
        int newValue;
        Knob knob = (Knob)ObjectUtils.nonNullAssert((Object)((Knob)event.widget.getData()));
        block0 : switch (event.type) {
            case 1: {
                this.stopOperations(event.time);
                switch (event.keyCode) {
                    case 0x1000003: {
                        newValue = knob.getValue() - this.increment;
                        break block0;
                    }
                    case 0x1000002: {
                        if ((this.thisStyle & 0x200) != 0) {
                            newValue = knob.getValue() + this.increment;
                            break block0;
                        }
                        newValue = knob.getValue() - this.increment;
                        break block0;
                    }
                    case 0x1000004: {
                        newValue = knob.getValue() + this.increment;
                        break block0;
                    }
                    case 0x1000001: {
                        if ((this.thisStyle & 0x200) != 0) {
                            newValue = knob.getValue() - this.increment;
                            break block0;
                        }
                        newValue = knob.getValue() + this.increment;
                        break block0;
                    }
                    case 0x1000006: {
                        newValue = knob.getValue() - this.pageIncrement;
                        break block0;
                    }
                    case 0x1000005: {
                        newValue = knob.getValue() + this.pageIncrement;
                        break block0;
                    }
                    case 0x1000007: {
                        newValue = this.minimum;
                        break block0;
                    }
                    case 0x1000008: {
                        newValue = this.maximum;
                        break block0;
                    }
                }
                return;
            }
            case 37: {
                if (this.isInOperation()) {
                    return;
                }
                newValue = knob.getValue() + this.increment * event.count;
                break;
            }
            case 3: {
                this.stopOperations(event.time);
                this.opInProgress = 1;
                this.opButton = knob.getIdx();
                this.opSavedValue = knob.getValue();
                this.opOffset = this.getCoord(event) - this.styleData.knobScaleOffset;
                return;
            }
            case 5: {
                if (this.opInProgress != 1) {
                    return;
                }
                newValue = this.convertClient2Value(this.getCoord(knob.button.getLocation()) + this.getCoord(event) - this.opOffset);
                break;
            }
            case 4: {
                if (this.opInProgress != 1) {
                    return;
                }
                this.opInProgress = 0;
                return;
            }
            default: {
                return;
            }
        }
        event.doit = false;
        knob.setValue(event.time, newValue);
        this.updateButtonPositions();
        this.redraw();
    }

    protected void onDispose() {
    }

    protected class Knob {
        private int idx;
        private int value;
        private Button button;
        private String toolTipText;
        private boolean savedEnabled = true;

        public Knob(int value) {
            this.value = value;
        }

        public void setToolTipText(String text) {
            this.toolTipText = text;
            if (this.button != null) {
                this.button.setToolTipText(text);
            }
        }

        public final int getIdx() {
            return this.idx;
        }

        public final int getValue() {
            return this.value;
        }

        protected int checkValue(int value) {
            if (value < WaScale.this.minimum) {
                value = WaScale.this.minimum;
            } else if (value > WaScale.this.maximum) {
                value = WaScale.this.maximum;
            }
            return value;
        }

        public boolean setValue(int time, int value) {
            int oldValue = this.value;
            value = this.checkValue(value);
            value = WaScale.this.fireAboutToChange(time, this.idx, oldValue, value);
            if (oldValue == (value = this.checkValue(value))) {
                return false;
            }
            this.value = value;
            WaScale.this.fireChanged(time, this.idx, oldValue, this.value);
            return true;
        }
    }

    protected class OrderedKnob
    extends Knob {
        public OrderedKnob(int value) {
            super(value);
        }

        public OrderedKnob(int value, String toolTipText) {
            super(value);
            this.setToolTipText(toolTipText);
        }

        protected int getMinDistance() {
            return 1;
        }

        @Override
        protected int checkValue(int value) {
            int bound;
            List<Knob> knobs = WaScale.this.getKnobs();
            int idx = this.getIdx();
            int distance = this.getMinDistance();
            if (idx + 1 < knobs.size() && (bound = knobs.get(idx + 1).getValue()) - value < distance) {
                value = bound - distance;
            }
            if (idx > 0 && value - (bound = knobs.get(idx - 1).getValue()) < distance) {
                value = bound + distance;
            }
            return super.checkValue(value);
        }
    }

    private static class StyleData {
        final int minWidth;
        final int defaultWidth;
        final int height;
        final int linePadding = 1;
        final int knobHeight;
        final int knobWidth;
        final int knobScaleOffset;
        final Image knobLine;

        public StyleData(Display display, int style) {
            Shell shell = new Shell(display, 8);
            try {
                shell.setSize(200, 200);
                shell.setFont(display.getSystemFont());
                Throwable throwable = null;
                Object var5_6 = null;
                try (AutoDisposeReference<GC> managedGC = AutoDisposeReference.autoDispose(new GC((Drawable)shell));){
                    int width = (int)(managedGC.get().getFontMetrics().getAverageCharacterWidth() * 2.0);
                    if (width % 2 == 0) {
                        ++width;
                    }
                    if (width < 11) {
                        width = 11;
                    }
                    Button button = new Button((Composite)shell, 8 | style);
                    Point size = button.computeSize(width, (int)((double)width * 1.333));
                    width = size.x;
                    if (width % 2 == 0) {
                        ++width;
                    }
                    this.knobWidth = width;
                    this.knobHeight = size.y;
                    this.knobScaleOffset = this.knobWidth / 2;
                    this.height = this.knobHeight + 9;
                    this.minWidth = 4 * this.knobWidth + 2 * this.knobScaleOffset;
                    this.defaultWidth = 100 + 2 * this.knobScaleOffset;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                this.knobLine = this.createKnobLine(display, this.knobHeight / 2);
            }
            finally {
                shell.dispose();
            }
        }

        private Image createKnobLine(Display display, int height) {
            ImageData imageData;
            Throwable throwable = null;
            Object var5_5 = null;
            try (AutoDisposeReference<Image> managedImage = AutoDisposeReference.autoDispose(new Image((Device)display, 3, height));){
                GC gc = new GC((Drawable)managedImage.get());
                try {
                    gc.setForeground(display.getSystemColor(18));
                    gc.drawLine(0, 0, 0, height);
                    gc.drawPoint(1, 0);
                    gc.drawLine(2, 0, 2, height);
                    gc.setForeground(display.getSystemColor(2));
                    gc.drawLine(1, 1, 1, height);
                }
                finally {
                    gc.dispose();
                }
                imageData = managedImage.get().getImageData();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            byte[] alphaData = new byte[3 * imageData.height];
            int alpha = 127;
            int line = 0;
            int i = 0;
            while (line++ < 4) {
                alphaData[i++] = alpha;
                alphaData[i++] = alpha;
                alphaData[i++] = alpha;
                alpha = (byte)(alpha + 16);
            }
            while (line++ < imageData.height) {
                alphaData[i++] = alpha;
                alphaData[i++] = alpha;
                alphaData[i++] = alpha;
            }
            imageData.alphaData = alphaData;
            return new Image((Device)display, imageData);
        }
    }
}

