/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.dsl.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.dsl.core.source.ast.DslAstNode;
import org.eclipse.statet.dsl.core.source.ast.DslAstVisitor;
import org.eclipse.statet.dsl.core.source.ast.DslParser;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.ltk.ast.core.Asts;

@NonNullByDefault
abstract class NContainer
extends DslAstNode {
    ImIdentityList<DslAstNode> children = NO_CHILDREN;

    NContainer(int statusCode, @Nullable DslAstNode parent) {
        super(statusCode, parent);
    }

    NContainer(@Nullable DslAstNode parent) {
        super(parent);
    }

    NContainer() {
    }

    protected void add(DslParser.NContainerBuilder containerBuilder, DslAstNode child) {
        containerBuilder.children.add(child);
    }

    protected void finish(int endOffset, DslParser.NContainerBuilder containerBuilder) {
        this.children = ImCollections.toIdentityList(containerBuilder.children);
        super.finish(endOffset);
        if (!this.children.isEmpty()) {
            this.doSetEndOffsetMin(((DslAstNode)((Object)this.children.getLast())).getEndOffset());
        }
    }

    @Override
    protected boolean hasErrorInChild() {
        for (DslAstNode child : this.children) {
            if (!Asts.hasErrors((AstNode)child)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    public final int getChildCount() {
        return this.children.size();
    }

    protected final ImIdentityList<DslAstNode> getChildren() {
        return this.children;
    }

    @Override
    public final DslAstNode getChild(int index) {
        return (DslAstNode)((Object)this.children.get(index));
    }

    @Override
    public final int getChildIndex(AstNode child) {
        return this.children.indexOf((Object)child);
    }

    public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        for (DslAstNode child : this.children) {
            visitor.visit((AstNode)child);
        }
    }

    @Override
    public final void acceptInDslChildren(DslAstVisitor visitor) throws InvocationTargetException {
        for (DslAstNode child : this.children) {
            child.acceptInDsl(visitor);
        }
    }
}

