/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui.editors;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.docmlet.base.ui.DocmlBaseUIResources;
import org.eclipse.statet.docmlet.tex.core.model.TexNameAccess;
import org.eclipse.statet.internal.docmlet.tex.ui.sourceediting.LtxAssistInvocationContext;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.SearchPattern;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.SourceProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

@NonNullByDefault
public class TexLabelCompletionProposal
extends SourceProposal<LtxAssistInvocationContext> {
    protected final TexNameAccess access;

    protected TexLabelCompletionProposal(TexLabelProposalParameters parameters) {
        super((SourceProposal.ProposalParameters)parameters);
        this.access = (TexNameAccess)ObjectUtils.nonNullAssert((Object)parameters.access);
    }

    protected String getName() {
        return this.access.getDisplayName();
    }

    protected int computeReplacementLength(int replacementOffset, Point selection, int caretOffset, boolean overwrite) throws BadLocationException {
        int end = Math.max(caretOffset, selection.x + selection.y);
        if (overwrite) {
            LtxAssistInvocationContext context = (LtxAssistInvocationContext)this.getInvocationContext();
            IDocument document = context.getDocument();
            --end;
            while (++end < document.getLength()) {
                char c = document.getChar(end);
                if (c <= ' ' || c == '\\' || c == '{' || c == '}' || c == '%' || Character.isWhitespace(c)) break;
            }
        }
        return end - replacementOffset;
    }

    public String getSortingString() {
        return this.access.getSegmentName();
    }

    public Image getImage() {
        return DocmlBaseUIResources.INSTANCE.getImage("org.eclipse.statet.docmlet.base/images/obj/Label-Text");
    }

    public boolean isAutoInsertable() {
        return true;
    }

    public static class TexLabelProposalParameters
    extends SourceProposal.ProposalParameters<LtxAssistInvocationContext> {
        public TexNameAccess access;

        public TexLabelProposalParameters(LtxAssistInvocationContext context, int replacementOffset, SearchPattern namePattern) {
            super((AssistInvocationContext)context, replacementOffset, namePattern);
        }
    }
}

