/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.docmlet.tex.core.commands.LtxCommandCategories;
import org.eclipse.statet.docmlet.tex.core.commands.LtxCommandDefinitions;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommand;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommandSet;
import org.eclipse.statet.docmlet.tex.ui.TexCommandLabelProvider;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.ui.ManagedConfigurationBlock;
import org.eclipse.statet.ecommons.runtime.core.StatusChangeListener;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

class TexCommandsConfigurationBlock
extends ManagedConfigurationBlock {
    private static final int DETAIL_CHECK_ASSIST_TEXT = 0;
    private static final int DETAIL_CHECK_ASSIST_MATH = 1;
    private static final int DETAIL_CHECK_SIZE = 2;
    private CheckboxTreeViewer treeViewer;
    private final Button[] detailCheckControls = new Button[2];
    private final Preference<Set<String>>[] detailCheckPrefs = new Preference[2];
    private final Set<String> enabled = new HashSet<String>();
    private final Set<String>[] detailCheckEnabled = new HashSet[2];

    public TexCommandsConfigurationBlock(StatusChangeListener statusListener) {
        super(null, statusListener);
        int i = 0;
        while (i < 2) {
            this.detailCheckEnabled[i] = new HashSet<String>();
            ++i;
        }
    }

    public void createBlockArea(Composite pageComposite) {
        HashMap<Preference, Object> prefs = new HashMap<Preference, Object>();
        prefs.put(TexCommandSet.MASTER_COMMANDS_INCLUDE_PREF, null);
        this.detailCheckPrefs[0] = TexCommandSet.TEXT_COMMANDS_INCLUDE_PREF;
        prefs.put(this.detailCheckPrefs[0], null);
        this.detailCheckPrefs[1] = TexCommandSet.MATH_COMMANDS_INCLUDE_PREF;
        prefs.put(this.detailCheckPrefs[1], null);
        this.setupPreferenceManager(prefs);
        LtxCommandCategories categories = new LtxCommandCategories(LtxCommandDefinitions.getAllCommands());
        Composite composite = new Composite(pageComposite, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        Control tree = this.createTree(categories, composite);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        Control detail = this.createDetailComposite(composite);
        detail.setLayoutData((Object)new GridData(4, 4, false, false));
        this.updateControls();
        this.treeViewer.getTree().select(this.treeViewer.getTree().getItem(0));
    }

    private Control createTree(LtxCommandCategories categories, Composite composite) {
        this.treeViewer = new CheckboxTreeViewer(composite, 2562);
        this.treeViewer.setContentProvider((IContentProvider)new CatContentProvider());
        this.treeViewer.addCheckStateListener(event -> {
            Object element = event.getElement();
            LtxCommandCategories.Category category = null;
            if (element instanceof LtxCommandCategories.Category) {
                category = (LtxCommandCategories.Category)element;
                ImList commands = category.getCommands();
                if (event.getChecked()) {
                    for (TexCommand command : commands) {
                        this.enabled.add(command.getControlWord());
                    }
                } else {
                    for (TexCommand command : commands) {
                        this.enabled.remove(command.getControlWord());
                    }
                }
            } else if (element instanceof TexCommand) {
                TexCommand command = (TexCommand)element;
                if (event.getChecked()) {
                    this.enabled.add(command.getControlWord());
                } else {
                    this.enabled.remove(command.getControlWord());
                }
                category = categories.getCategory(command);
            }
            if (category != null) {
                this.treeViewer.refresh((Object)category, true);
            }
        });
        this.treeViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                if (element instanceof LtxCommandCategories.Category) {
                    ImList commands = ((LtxCommandCategories.Category)element).getCommands();
                    for (TexCommand command : commands) {
                        if (!TexCommandsConfigurationBlock.this.enabled.contains(command.getControlWord())) continue;
                        return true;
                    }
                    return false;
                }
                if (element instanceof TexCommand) {
                    return TexCommandsConfigurationBlock.this.enabled.contains(((TexCommand)element).getControlWord());
                }
                return false;
            }

            public boolean isGrayed(Object element) {
                if (element instanceof LtxCommandCategories.Category) {
                    int check = 0;
                    ImList commands = ((LtxCommandCategories.Category)element).getCommands();
                    for (TexCommand command : commands) {
                        if ((check |= TexCommandsConfigurationBlock.this.enabled.contains(command.getControlWord()) ? 1 : 2) != 3) continue;
                        return true;
                    }
                }
                return false;
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TexCommandLabelProvider());
        this.treeViewer.setInput((Object)categories);
        ViewerUtils.addDoubleClickExpansion((TreeViewer)this.treeViewer);
        return this.treeViewer.getControl();
    }

    protected Object[] getSelectedElements() {
        return ((IStructuredSelection)this.treeViewer.getSelection()).toArray();
    }

    protected Control createDetailComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)1));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label.setText("Region:");
        Button button = new Button(composite, 32);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalIndent = LayoutUtils.defaultSmallIndent();
        button.setLayoutData((Object)gd);
        button.setText("&Text");
        this.detailCheckControls[0] = button;
        this.registerDetailCheck(0);
        button = new Button(composite, 32);
        gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalIndent = LayoutUtils.defaultSmallIndent();
        button.setLayoutData((Object)gd);
        button.setText("&Math");
        this.detailCheckControls[1] = button;
        this.registerDetailCheck(1);
        LayoutUtils.addSmallFiller((Composite)composite, (boolean)true);
        return composite;
    }

    private void registerDetailCheck(int id) {
        final Button button = this.detailCheckControls[id];
        final Set<String> enabled = this.detailCheckEnabled[id];
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                button.setGrayed(false);
                Object[] elements = TexCommandsConfigurationBlock.this.getSelectedElements();
                if (button.getSelection()) {
                    Object[] objectArray = elements;
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (element instanceof LtxCommandCategories.Category) {
                            ImList commands = ((LtxCommandCategories.Category)element).getCommands();
                            for (TexCommand command : commands) {
                                enabled.add(command.getControlWord());
                            }
                        } else if (element instanceof TexCommand) {
                            enabled.add(((TexCommand)element).getControlWord());
                        }
                        ++n2;
                    }
                } else {
                    Object[] objectArray = elements;
                    int n = elements.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Object element = objectArray[n3];
                        if (element instanceof LtxCommandCategories.Category) {
                            ImList commands = ((LtxCommandCategories.Category)element).getCommands();
                            for (TexCommand command : commands) {
                                enabled.remove(command.getControlWord());
                            }
                        } else if (element instanceof TexCommand) {
                            enabled.remove(((TexCommand)element).getControlWord());
                        }
                        ++n3;
                    }
                }
            }
        });
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TexCommandsConfigurationBlock.this.updateDetail();
            }
        });
    }

    private void updateDetail() {
        Object[] elements = this.getSelectedElements();
        if (elements.length == 0) {
            int i = 0;
            while (i < 2) {
                this.detailCheckControls[i].setSelection(false);
                this.detailCheckControls[i].setGrayed(false);
                this.detailCheckControls[i].setEnabled(false);
                ++i;
            }
        }
        int[] state = new int[2];
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof LtxCommandCategories.Category) {
                ImList commands = ((LtxCommandCategories.Category)element).getCommands();
                for (TexCommand command : commands) {
                    int i = 0;
                    while (i < 2) {
                        state[i] = this.detailCheckEnabled[i].contains(command.getControlWord()) ? 1 : 2;
                        ++i;
                    }
                }
            } else if (element instanceof TexCommand) {
                TexCommand command = (TexCommand)element;
                int i = 0;
                while (i < 2) {
                    state[i] = this.detailCheckEnabled[i].contains(command.getControlWord()) ? 1 : 2;
                    ++i;
                }
            }
            ++n2;
        }
        int i = 0;
        while (i < 2) {
            this.detailCheckControls[i].setEnabled(true);
            if (state[i] == 3) {
                this.detailCheckControls[i].setSelection(true);
                this.detailCheckControls[i].setGrayed(true);
            } else {
                this.detailCheckControls[i].setSelection(state[i] == 1);
                this.detailCheckControls[i].setGrayed(false);
            }
            ++i;
        }
    }

    protected void addBindings(DataBindingSupport db) {
    }

    protected void updateControls() {
        super.updateControls();
        this.enabled.clear();
        this.enabled.addAll((Collection)this.getPreferenceValue(TexCommandSet.MASTER_COMMANDS_INCLUDE_PREF));
        int i = 0;
        while (i < 2) {
            this.detailCheckEnabled[i].clear();
            this.detailCheckEnabled[i].addAll((Collection)this.getPreferenceValue(this.detailCheckPrefs[i]));
            ++i;
        }
        this.treeViewer.refresh();
        this.updateDetail();
    }

    private void save() {
        this.setPrefValue(TexCommandSet.MASTER_COMMANDS_INCLUDE_PREF, this.enabled);
        int i = 0;
        while (i < 2) {
            this.setPrefValue(this.detailCheckPrefs[i], this.detailCheckEnabled[i]);
            ++i;
        }
    }

    public boolean performOk(int flags) {
        this.save();
        return super.performOk(flags);
    }

    private static class CatContentProvider
    implements ITreeContentProvider {
        private LtxCommandCategories categories;

        private CatContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.categories = (LtxCommandCategories)newInput;
        }

        public Object[] getElements(Object inputElement) {
            List categories = this.categories.getCategories();
            return categories.toArray(new LtxCommandCategories.Category[categories.size()]);
        }

        public boolean hasChildren(Object element) {
            return element instanceof LtxCommandCategories.Category;
        }

        public Object[] getChildren(Object parentElement) {
            ImList commands = ((LtxCommandCategories.Category)parentElement).getCommands();
            return commands.toArray(new TexCommand[commands.size()]);
        }

        public Object getParent(Object element) {
            if (element instanceof TexCommand) {
                return this.categories.getCategory((TexCommand)element);
            }
            return null;
        }

        public void dispose() {
            this.categories = null;
        }
    }
}

