/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.base.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.statet.ecommons.ui.util.ImageRegistryUtil;
import org.eclipse.statet.internal.docmlet.base.ui.markuphelp.DocmletHelpManager;
import org.eclipse.statet.internal.docmlet.base.ui.processing.DocProcessingRegistry;
import org.eclipse.statet.internal.docmlet.base.ui.viewer.DocViewerCloseDelegate;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

@NonNullByDefault
public class DocmlBaseUIPlugin
extends AbstractUIPlugin {
    private static @Nullable DocmlBaseUIPlugin instance;
    private boolean started;
    private List<Disposable> disposables;
    private @Nullable DocmletHelpManager markupHelpManager;
    private @Nullable DocViewerCloseDelegate docViewerCloseDelegate;
    private @Nullable DocProcessingRegistry docProcessingRegistry;

    public static @Nullable DocmlBaseUIPlugin getInstance() {
        return instance;
    }

    public static void log(IStatus status) {
        DocmlBaseUIPlugin plugin = DocmlBaseUIPlugin.getInstance();
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        this.disposables = new ArrayList<Disposable>();
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            DocmlBaseUIPlugin docmlBaseUIPlugin = this;
            synchronized (docmlBaseUIPlugin) {
                this.started = false;
                this.docProcessingRegistry = null;
            }
            for (Disposable listener : this.disposables) {
                try {
                    listener.dispose();
                }
                catch (Throwable e) {
                    DocmlBaseUIPlugin.log((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", "Error occured while dispose module", e));
                }
            }
            this.disposables = null;
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        if (!this.started) {
            throw new IllegalStateException("Plug-in is not started.");
        }
        ImageRegistryUtil util = new ImageRegistryUtil((AbstractUIPlugin)this);
        util.register("org.eclipse.statet.docmlet.base/images/obj/Preamble", "obj_16", "preamble.png");
        util.register("org.eclipse.statet.docmlet.base/images/obj/Sectioning-H1", "obj_16", "sectioning-1.png");
        util.register("org.eclipse.statet.docmlet.base/images/obj/Sectioning-H2", "obj_16", "sectioning-2.png");
        util.register("org.eclipse.statet.docmlet.base/images/obj/Sectioning-H3", "obj_16", "sectioning-3.png");
        util.register("org.eclipse.statet.docmlet.base/images/obj/Sectioning-H4", "obj_16", "sectioning-4.png");
        util.register("org.eclipse.statet.docmlet.base/images/obj/Sectioning-H5", "obj_16", "sectioning-5.png");
        util.register("org.eclipse.statet.docmlet.base/images/obj/Sectioning-H6", "obj_16", "sectioning-6.png");
        util.register("org.eclipse.statet.docmlet.base/images/obj/Label-Def", "obj_16", "label-def.png");
        util.register("org.eclipse.statet.docmlet.base/images/obj/Label-Ref", "obj_16", "label-ref.png");
        util.register("org.eclipse.statet.docmlet.base/images/obj/Label-Text", "obj_16", "label-text.png");
        util.register("org.eclipse.statet.docmlet.base/images/view/MarkupHelp", "view_16", "markup_help.png");
        util.register("org.eclipse.statet.docmlet.base/images/tool/Process", "tool_16", "process.png");
        util.register("org.eclipse.statet.docmlet.base/images/tool/ProcessAndPreview", "tool_16", "process_and_preview.png");
        util.register("org.eclipse.statet.docmlet.base/images/tool/Preview", "tool_16", "preview.png");
    }

    public synchronized DocmletHelpManager getMarkupHelpManager() {
        DocmletHelpManager markupHelpManager = this.markupHelpManager;
        if (markupHelpManager == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.markupHelpManager = markupHelpManager = new DocmletHelpManager();
        }
        return markupHelpManager;
    }

    public synchronized DocViewerCloseDelegate getDocViewerCloseDelegate() {
        DocViewerCloseDelegate docViewerCloseDelegate = this.docViewerCloseDelegate;
        if (docViewerCloseDelegate == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            docViewerCloseDelegate = new DocViewerCloseDelegate();
            this.disposables.add((Disposable)docViewerCloseDelegate);
            this.docViewerCloseDelegate = docViewerCloseDelegate;
        }
        return docViewerCloseDelegate;
    }

    public synchronized DocProcessingRegistry getDocProcessingRegistry() {
        DocProcessingRegistry docProcessingRegistry = this.docProcessingRegistry;
        if (docProcessingRegistry == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            docProcessingRegistry = new DocProcessingRegistry();
            this.disposables.add(docProcessingRegistry);
            this.docProcessingRegistry = docProcessingRegistry;
        }
        return docProcessingRegistry;
    }
}

