/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.tex.r.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.docmlet.tex.core.TexBuildParticipant;
import org.eclipse.statet.docmlet.tex.core.model.LtxSuModelContainer;
import org.eclipse.statet.docmlet.tex.core.model.TexWorkspaceSourceUnit;
import org.eclipse.statet.internal.redocs.tex.r.model.LtxRweaveSuModelContainer;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;
import org.eclipse.statet.r.core.RProject;
import org.eclipse.statet.r.core.RProjects;
import org.eclipse.statet.r.core.model.IRSourceUnit;
import org.eclipse.statet.r.core.model.RModel;
import org.eclipse.statet.r.core.model.RModelIndexUpdate;
import org.eclipse.statet.redocs.tex.r.core.model.LtxRweaveSourceUnit;

public class LtxRweaveTexBuildParticipant
extends TexBuildParticipant {
    private static final ImList<String> TEX_R_MODEL_TYPES = ImCollections.newList((Object)"LtxRweave");
    private RModelIndexUpdate rIndexUpdate;

    public void init() {
        super.init();
        RProject rProject = RProjects.getRProject((IProject)this.getTexProject().getProject());
        if (rProject != null) {
            this.setEnabled(true);
            this.rIndexUpdate = new RModelIndexUpdate(rProject, TEX_R_MODEL_TYPES, this.getBuildType() == 6);
        }
    }

    public void clear(IFile file) throws CoreException {
        file.deleteMarkers("org.eclipse.statet.r.resourceMarkers.Tasks", false, 2);
    }

    public void ltxUnitUpdated(TexWorkspaceSourceUnit sourceUnit, IProgressMonitor monitor) throws CoreException {
        if (sourceUnit instanceof LtxRweaveSourceUnit) {
            LtxRweaveSourceUnit unit = (LtxRweaveSourceUnit)sourceUnit;
            LtxRweaveSuModelContainer modelContainer = (LtxRweaveSuModelContainer)((Object)unit.getAdapter(LtxSuModelContainer.class));
            if (modelContainer != null) {
                this.rIndexUpdate.update((IRSourceUnit)unit, RModel.getRModelInfo((ISourceUnitModelInfo)modelContainer.getCurrentModel()));
            } else {
                this.rIndexUpdate.remove((IRSourceUnit)unit);
            }
        }
    }

    public void ltxUnitRemoved(IFile file, IProgressMonitor monitor) throws CoreException {
        this.rIndexUpdate.remove(file);
    }

    public void ltxFinished(IProgressMonitor monitor) throws CoreException {
        this.rIndexUpdate.submit(monitor);
    }
}

