/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.selection;

import java.util.Collection;
import org.eclipse.statet.ecommons.waltable.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.event.RowVisualChangeEvent;
import org.eclipse.statet.ecommons.waltable.selection.ISelectionEvent;
import org.eclipse.statet.ecommons.waltable.selection.SelectionLayer;

public class RowSelectionEvent
extends RowVisualChangeEvent
implements ISelectionEvent {
    private final SelectionLayer selectionLayer;
    private long rowPositionToReveal;

    public RowSelectionEvent(SelectionLayer selectionLayer, long rowPosition, boolean revealRow) {
        this(selectionLayer, new LRangeList(rowPosition), revealRow ? rowPosition : Long.MIN_VALUE);
    }

    public RowSelectionEvent(SelectionLayer selectionLayer, Collection<LRange> rowPositions, long rowPositionToReveal) {
        super((ILayer)selectionLayer, rowPositions);
        this.selectionLayer = selectionLayer;
        this.rowPositionToReveal = rowPositionToReveal;
    }

    protected RowSelectionEvent(RowSelectionEvent event) {
        super(event);
        this.selectionLayer = event.selectionLayer;
        this.rowPositionToReveal = event.rowPositionToReveal;
    }

    @Override
    public RowSelectionEvent cloneEvent() {
        return new RowSelectionEvent(this);
    }

    @Override
    public SelectionLayer getSelectionLayer() {
        return this.selectionLayer;
    }

    public long getRowPositionToReveal() {
        return this.rowPositionToReveal;
    }

    @Override
    public boolean convertToLocal(ILayer localLayer) {
        if (this.rowPositionToReveal != Long.MIN_VALUE) {
            this.rowPositionToReveal = localLayer.getDim(Orientation.VERTICAL).underlyingToLocalPosition(this.getLayer().getDim(Orientation.VERTICAL), this.rowPositionToReveal);
        }
        return super.convertToLocal(localLayer);
    }
}

