/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.rsource.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.r.core.rlang.RTerminal;
import org.eclipse.statet.r.core.rsource.ast.Expression;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RAstVisitor;

@NonNullByDefault
abstract class SpecItem
extends RAstNode {
    @Nullable RAstNode argName;
    int equalsOffset = Integer.MIN_VALUE;
    final Expression valueExpr = new Expression();

    protected SpecItem() {
    }

    @Override
    public final @Nullable RTerminal getOperator(int index) {
        return null;
    }

    public final int getAssignOffset() {
        return this.equalsOffset;
    }

    @Override
    public final boolean hasChildren() {
        return this.argName != null || this.valueExpr.node != null;
    }

    @Override
    public final int getChildCount() {
        int count;
        int n = count = this.argName != null ? 1 : 0;
        if (this.valueExpr.node != null) {
            ++count;
        }
        return count;
    }

    public final boolean hasName() {
        return this.argName != null;
    }

    public final @Nullable RAstNode getNameChild() {
        return this.argName;
    }

    public boolean hasValue() {
        return this.valueExpr.node != null;
    }

    public final @Nullable RAstNode getValueChild() {
        return this.valueExpr.node;
    }

    @Override
    public final RAstNode getChild(int index) {
        RAstNode nameNode = this.argName;
        RAstNode valueNode = this.valueExpr.node;
        if (nameNode != null) {
            switch (index) {
                case 0: {
                    return nameNode;
                }
                case 1: {
                    if (valueNode == null) break;
                    return valueNode;
                }
            }
            throw new IndexOutOfBoundsException();
        }
        switch (index) {
            case 0: {
                if (valueNode == null) break;
                return valueNode;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final RAstNode[] getChildren() {
        RAstNode nameNode = this.argName;
        RAstNode valueNode = this.valueExpr.node;
        if (nameNode != null) {
            if (valueNode != null) {
                return new RAstNode[]{nameNode, valueNode};
            }
            return new RAstNode[]{nameNode};
        }
        if (valueNode != null) {
            return new RAstNode[]{valueNode};
        }
        return NO_CHILDREN;
    }

    @Override
    public int getChildIndex(AstNode child) {
        if (this.argName == child) {
            return 0;
        }
        if (this.valueExpr.node == child) {
            return 1;
        }
        return -1;
    }

    @Override
    public final void acceptInRChildren(RAstVisitor visitor) throws InvocationTargetException {
        RAstNode nameNode = this.argName;
        RAstNode valueNode = this.valueExpr.node;
        if (nameNode != null) {
            nameNode.acceptInR(visitor);
        }
        if (valueNode != null) {
            valueNode.acceptInR(visitor);
        }
    }

    public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        RAstNode nameNode = this.argName;
        RAstNode valueNode = this.valueExpr.node;
        if (nameNode != null) {
            visitor.visit((AstNode)nameNode);
        }
        if (valueNode != null) {
            visitor.visit((AstNode)valueNode);
        }
    }

    @Override
    final @Nullable Expression getExpr(RAstNode child) {
        if (this.valueExpr.node == child) {
            return this.valueExpr;
        }
        return null;
    }

    @Override
    final @Nullable Expression getLeftExpr() {
        return null;
    }

    @Override
    final Expression getRightExpr() {
        return this.valueExpr;
    }

    @Override
    final int getMissingExprStatus(Expression expr) {
        if (this.valueExpr == expr) {
            return 0;
        }
        throw new IllegalArgumentException();
    }

    @Override
    final void updateEndOffset() {
        this.endOffset = this.valueExpr.node != null ? this.valueExpr.node.endOffset : (this.equalsOffset != Integer.MIN_VALUE ? this.equalsOffset + 1 : (this.argName != null ? this.argName.endOffset : this.startOffset));
    }
}

