/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.sourcemodel;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.statet.internal.r.core.sourcemodel.ElementAccess;
import org.eclipse.statet.internal.r.core.sourcemodel.IBuildSourceFrameElement;
import org.eclipse.statet.internal.r.core.sourcemodel.RSourceElements;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.r.core.model.IRElement;
import org.eclipse.statet.r.core.model.IRFrame;
import org.eclipse.statet.r.core.model.IRFrameInSource;
import org.eclipse.statet.r.core.model.IRLangSourceElement;
import org.eclipse.statet.r.core.model.RElementAccess;
import org.eclipse.statet.r.core.model.RElementName;

abstract class BuildSourceFrame
implements IRFrameInSource {
    static final int CREATED_NO = 0;
    static final int CREATED_SEARCH = 1;
    static final int CREATED_RESOLVED = 2;
    static final int CREATED_EXPLICIT = 3;
    static final int CREATED_IMPORTED = 4;
    private static final ImList<BuildSourceFrame> NO_PARENTS = ImCollections.emptyList();
    protected final Map<String, ElementAccessList> data;
    protected final int type;
    protected final String id;
    ImList<BuildSourceFrame> parents;
    private List<IBuildSourceFrameElement> elements = Collections.emptyList();
    private WeakReference<List<IRLangSourceElement>> modelChildren;

    public static String createId(int type, String name, int alt) {
        if (type == 2 && name != null) {
            return "package:" + name;
        }
        return name != null ? String.valueOf(Integer.toHexString(type)) + ":`" + name + '`' : String.valueOf(Integer.toHexString(type)) + ":#" + Integer.toHexString(alt);
    }

    BuildSourceFrame(int type, String id, BuildSourceFrame[] parents) {
        this.type = type;
        this.id = id;
        this.parents = parents != null ? ImCollections.newList((Object[])parents) : NO_PARENTS;
        this.data = new HashMap<String, ElementAccessList>();
    }

    void addFrameElement(IBuildSourceFrameElement element) {
        int length = this.elements.size();
        Object[] elements = this.elements.toArray(new IBuildSourceFrameElement[length + 1]);
        elements[length] = element;
        this.elements = ImCollections.newList((Object[])elements);
    }

    abstract void add(String var1, ElementAccess var2);

    abstract void addLateResolve(String var1, ElementAccess var2);

    abstract void addRunResolve(String var1, ElementAccess var2);

    abstract void addClass(String var1, ElementAccess var2);

    abstract void runLateResolve(boolean var1);

    protected BuildSourceFrame[] createSearchList() {
        ArrayList<BuildSourceFrame> list = new ArrayList<BuildSourceFrame>();
        int idx = 0;
        list.add(this);
        while (idx < list.size()) {
            ImList<BuildSourceFrame> ps = ((BuildSourceFrame)list.get((int)idx++)).parents;
            for (BuildSourceFrame p : ps) {
                if (list.contains(p)) continue;
                list.add(p);
            }
        }
        return list.toArray(new BuildSourceFrame[list.size()]);
    }

    @Override
    public int getFrameType() {
        return this.type;
    }

    @Override
    public String getFrameId() {
        return this.id;
    }

    @Override
    public List<? extends IRFrame> getPotentialParents() {
        return this.parents;
    }

    @Override
    public Set<String> getAllAccessNames() {
        return Collections.unmodifiableSet(this.data.keySet());
    }

    @Override
    public ImList<? extends RElementAccess> getAllAccessOf(String name, boolean includeSlaves) {
        ElementAccessList list = this.data.get(name);
        if (list == null) {
            return ImCollections.emptyList();
        }
        return list.getAll(includeSlaves);
    }

    @Override
    public boolean isResolved(String name) {
        ElementAccessList accessList = this.data.get(name);
        return accessList != null && accessList.isCreated >= 2;
    }

    @Override
    public List<? extends IRElement> getModelElements() {
        return this.elements;
    }

    @Override
    public boolean hasModelChildren(IModelElement.Filter filter) {
        for (ElementAccessList list : this.data.values()) {
            for (ElementAccess access : list.entries) {
                if (access.modelElement == null || filter != null && !filter.include((IModelElement)access.modelElement)) continue;
                return true;
            }
        }
        return false;
    }

    public List<? extends IRLangSourceElement> getModelChildren(IModelElement.Filter filter) {
        List<IRLangSourceElement> children;
        if (this.data.isEmpty()) {
            return RSourceElements.NO_R_SOURCE_CHILDREN;
        }
        List list = children = this.modelChildren != null ? (ArrayList)this.modelChildren.get() : null;
        if (children != null) {
            if (filter == null) {
                return children;
            }
            return RSourceElements.getChildren(children, filter);
        }
        children = new ArrayList();
        for (ElementAccessList list2 : this.data.values()) {
            for (ElementAccess access : list2.entries) {
                if (access.modelElement == null || filter != null && !filter.include((IModelElement)access.modelElement)) continue;
                children.add(access.modelElement);
            }
        }
        children = Collections.unmodifiableList(children);
        if (filter == null) {
            this.modelChildren = new WeakReference(children);
        }
        return children;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        RElementName elementName = this.getElementName();
        if (elementName != null) {
            sb.append(' ').append(elementName);
        } else {
            sb.append(" <unnamed>");
        }
        return sb.toString();
    }

    static class DefScope
    extends BuildSourceFrame {
        private Map<String, ElementAccessList> lateWrite = new HashMap<String, ElementAccessList>();
        private Map<String, ElementAccessList> lateRead = new HashMap<String, ElementAccessList>();
        private Map<String, ElementAccessList> classes;
        private RElementName elementName;

        DefScope(int type, String id, String name, BuildSourceFrame[] parents) {
            super(type, id, parents);
            switch (type) {
                case 1: {
                    this.elementName = null;
                    this.classes = new HashMap<String, ElementAccessList>();
                    break;
                }
                case 2: {
                    this.elementName = RElementName.create(38, name);
                    this.classes = new HashMap<String, ElementAccessList>();
                    break;
                }
                default: {
                    this.classes = null;
                }
            }
        }

        @Override
        public RElementName getElementName() {
            return this.elementName;
        }

        @Override
        void add(String name, ElementAccess access) {
            ElementAccessList detail = (ElementAccessList)this.data.get(name);
            if (detail == null) {
                detail = new ElementAccessList(name);
                detail.frame = this;
                this.data.put(name, detail);
            }
            detail.entries.add(access);
            if (access.isWriteAccess() && !access.isDeletion()) {
                detail.isCreated = 3;
            } else if (access.isImport()) {
                detail.isCreated = 4;
            }
            access.shared = detail;
            access.fullNode.addAttachment(access);
        }

        @Override
        void addLateResolve(String name, ElementAccess access) {
            Map<String, ElementAccessList> late;
            if (name == null) {
                this.add(null, access);
                return;
            }
            ElementAccessList detail = (ElementAccessList)this.data.get(name);
            if (detail != null && detail.isCreated <= 0) {
                detail = null;
            }
            if (detail == null && (detail = (late = (access.flags & 0x10F) == 2 ? this.lateWrite : this.lateRead).get(name)) == null) {
                detail = new ElementAccessList(name);
                late.put(name, detail);
            }
            detail.entries.add(access);
            access.shared = detail;
            access.fullNode.addAttachment(access);
        }

        @Override
        void addClass(String name, ElementAccess access) {
            if (this.classes == null) {
                ((BuildSourceFrame)this.parents.get(0)).addClass(name, access);
                return;
            }
            ElementAccessList detail = this.classes.get(name);
            if (detail == null) {
                detail = new ElementAccessList(name);
                detail.frame = this;
                this.classes.put(name, detail);
            }
            detail.entries.add(access);
            access.shared = detail;
            access.fullNode.addAttachment(access);
        }

        @Override
        void addRunResolve(String name, ElementAccess access) {
        }

        @Override
        void runLateResolve(boolean onlyWrite) {
            ElementAccessList exist;
            int i;
            int requiredCreation;
            BuildSourceFrame defaultScope;
            BuildSourceFrame[] searchList = this.createSearchList();
            Map<String, ElementAccessList> map = this.lateWrite;
            if (map != null) {
                defaultScope = this;
                block0: for (ElementAccessList detail : map.values()) {
                    requiredCreation = 1;
                    while (requiredCreation >= 0) {
                        i = 0;
                        while (i < searchList.length) {
                            exist = searchList[i].data.get(detail.getName());
                            if (exist != null && exist.isCreated >= requiredCreation) {
                                for (ElementAccess access : detail.entries) {
                                    access.shared = exist;
                                }
                                exist.entries.addAll(detail.entries);
                                continue block0;
                            }
                            ++i;
                        }
                        --requiredCreation;
                    }
                    detail.frame = defaultScope;
                    detail.isCreated = 1;
                    this.data.put(detail.getName(), detail);
                }
                this.lateWrite = null;
            }
            if (onlyWrite) {
                return;
            }
            map = this.lateRead;
            if (map != null) {
                defaultScope = this;
                int i2 = 0;
                while (i2 < searchList.length) {
                    if (searchList[i2].type <= 2) {
                        defaultScope = searchList[i2];
                        break;
                    }
                    ++i2;
                }
                block5: for (ElementAccessList detail : map.values()) {
                    requiredCreation = 1;
                    while (requiredCreation >= 0) {
                        i = 0;
                        while (i < searchList.length) {
                            exist = searchList[i].data.get(detail.getName());
                            if (exist != null && exist.isCreated >= requiredCreation) {
                                for (ElementAccess access : detail.entries) {
                                    access.shared = exist;
                                }
                                exist.entries.addAll(detail.entries);
                                continue block5;
                            }
                            ++i;
                        }
                        --requiredCreation;
                    }
                    detail.frame = defaultScope;
                    defaultScope.data.put(detail.getName(), detail);
                }
                this.lateRead = null;
            }
        }
    }

    static final class ElementAccessList {
        private final String name;
        final List<ElementAccess> entries;
        IRFrame frame;
        int isCreated;

        public ElementAccessList(String name) {
            this.name = name;
            this.entries = new ArrayList<ElementAccess>(4);
            this.isCreated = 0;
        }

        public String getName() {
            return this.name;
        }

        public void postAdd(ElementAccess access) {
            access.shared = this;
            this.entries.add(access);
            access.fullNode.addAttachment(access);
        }

        public ImList<ElementAccess> getAll(boolean includeSlaves) {
            if (!includeSlaves) {
                int counter = 0;
                for (ElementAccess element : this.entries) {
                    if (!element.isSlave()) continue;
                    ++counter;
                }
                if (counter > 0) {
                    Object[] elements = new ElementAccess[this.entries.size() - counter];
                    counter = 0;
                    for (ElementAccess element : this.entries) {
                        if (!element.isMaster()) continue;
                        elements[counter++] = element;
                    }
                    Arrays.sort(elements, RElementAccess.NAME_POSITION_COMPARATOR);
                    return ImCollections.newList((Object[])elements);
                }
            }
            Object[] elements = this.entries.toArray(new ElementAccess[this.entries.size()]);
            Arrays.sort(elements, RElementAccess.NAME_POSITION_COMPARATOR);
            return ImCollections.newList((Object[])elements);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.name);
            sb.append(" (").append(this.entries.size()).append(')');
            return sb.toString();
        }
    }

    static class RunScope
    extends BuildSourceFrame {
        public RunScope(int type, String id, BuildSourceFrame parent) {
            super(type, id, new BuildSourceFrame[]{parent});
        }

        @Override
        public RElementName getElementName() {
            return null;
        }

        @Override
        public void add(String name, ElementAccess access) {
            ((BuildSourceFrame)this.parents.get(0)).add(name, access);
        }

        @Override
        public void addLateResolve(String name, ElementAccess access) {
            ((BuildSourceFrame)this.parents.get(0)).addLateResolve(name, access);
        }

        @Override
        public void addRunResolve(String name, ElementAccess access) {
            ElementAccessList detail = (ElementAccessList)this.data.get(name);
            if (detail == null) {
                detail = new ElementAccessList(name);
                detail.frame = this;
                this.data.put(name, detail);
            }
            detail.entries.add(access);
            if (access.isWriteAccess() && !access.isDeletion()) {
                detail.isCreated = 3;
            } else if (access.isImport()) {
                detail.isCreated = 4;
            }
            access.shared = detail;
            access.fullNode.addAttachment(access);
        }

        @Override
        void addClass(String name, ElementAccess access) {
            ((BuildSourceFrame)this.parents.get(0)).addClass(name, access);
        }

        @Override
        void runLateResolve(boolean onlyWrite) {
        }
    }
}

