/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.emf.ui.forms;

import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;

public class EFEditorActionBarContributor
extends MultiPageEditorActionBarContributor
implements IPropertyListener {
    private IEditorPart activeEditor;
    private UndoAction undoAction;
    private RedoAction redoAction;

    public void init(IActionBars bars, IWorkbenchPage page) {
        super.init(bars, page);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.undoAction = new UndoAction();
        this.undoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        bars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        this.redoAction = new RedoAction();
        this.redoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        bars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    IEditorPart getActiveEditor() {
        return this.activeEditor;
    }

    public void setActiveEditor(IEditorPart part) {
        if (!(part instanceof IEditingDomainProvider)) {
            part = null;
        }
        if (this.activeEditor != null) {
            this.activeEditor.removePropertyListener((IPropertyListener)this);
        }
        this.activeEditor = part;
        if (part != null) {
            part.addPropertyListener((IPropertyListener)this);
        }
        this.undoAction.setActiveWorkbenchPart((IWorkbenchPart)part);
        this.redoAction.setActiveWorkbenchPart((IWorkbenchPart)part);
        this.update();
    }

    public void setActivePage(IEditorPart activeEditor) {
    }

    public void propertyChanged(Object source, int propId) {
        this.update();
    }

    public void update() {
        this.undoAction.update();
        this.redoAction.update();
    }

    public void shareGlobalActions(IPage page, IActionBars actionBars) {
    }
}

