/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.rmi.eruntime;

import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.runtime.UriUtils;
import org.osgi.framework.Bundle;

@NonNullByDefault
public class ERuntimeContributor {
    private static final String EXTENSIONPOINT_ID = "org.eclipse.statet.jcommons.rmi.ERegistry";

    private static void log(IStatus status) {
        Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.statet.jcommons.util")).log(status);
    }

    public List<URI> addCodebaseEntries(List<URI> entries) {
        ArrayList<IStatus> statusList = new ArrayList<IStatus>();
        ArrayList<String> pluginIds = new ArrayList<String>();
        this.collectPluginIds(EXTENSIONPOINT_ID, "codebaseEntry", pluginIds);
        for (String pluginId : pluginIds) {
            Bundle pluginBundle = Platform.getBundle((String)pluginId);
            if (pluginBundle == null) continue;
            this.addCodebasePath(pluginBundle, entries, statusList);
            Bundle[] fragments = Platform.getFragments((Bundle)pluginBundle);
            if (fragments == null) continue;
            Bundle[] bundleArray = fragments;
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle fragmentBundle = bundleArray[n2];
                this.addCodebasePath(fragmentBundle, entries, statusList);
                ++n2;
            }
        }
        if (!statusList.isEmpty()) {
            ERuntimeContributor.log((IStatus)new MultiStatus("org.eclipse.statet.jcommons.util", 0, statusList.toArray(new IStatus[statusList.size()]), "An error occurred when looking up RJ libraries. This may cause problems starting/running RJ.", null));
        }
        return entries;
    }

    private void collectPluginIds(String extensionPointId, String entryId, List<String> pluginIds) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = RegistryFactory.getRegistry().getConfigurationElementsFor(extensionPointId);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String pluginId;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(entryId) && (pluginId = element.getAttribute("pluginId")) != null && pluginId.length() > 0 && !pluginIds.contains(pluginId)) {
                pluginIds.add(pluginId);
            }
            ++n2;
        }
    }

    private void addCodebasePath(Bundle bundle, List<URI> entries, List<IStatus> statusList) {
        try {
            URI binUrl;
            Path path;
            Path binPath;
            URI url = UriUtils.toUri(FileLocator.resolve((URL)bundle.getEntry("/")));
            if (UriUtils.isJarUrl(url) && UriUtils.getJarEntryPath(url).isEmpty()) {
                url = UriUtils.getJarFileUrl(url);
            }
            if (Platform.inDevelopmentMode() && url.getPath().endsWith("/") && Files.isDirectory(binPath = (path = Paths.get(url)).resolve("target/classes"), new LinkOption[0]) && !entries.contains(binUrl = new URI(String.valueOf(url.toString()) + "target/classes/"))) {
                entries.add(binUrl);
            }
            if (!entries.contains(url)) {
                entries.add(url);
            }
        }
        catch (Exception e) {
            statusList.add((IStatus)new Status(2, "org.eclipse.statet.jcommons.util", String.format("Failed to check location for plug-in: '%1$s'.", bundle.getSymbolicName()), (Throwable)e));
        }
    }
}

