/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.redocs.wikitext.r.core.source;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.statet.docmlet.tex.core.source.TexDocumentConstants;
import org.eclipse.statet.ecommons.text.core.sections.BasicDocContentSections;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNode;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.source.IRDocumentConstants;
import org.eclipse.statet.redocs.r.core.source.DocContentSectionsRweaveExtension;
import org.eclipse.statet.redocs.r.core.source.RweaveDocSectionTreePartImpl;
import org.eclipse.statet.redocs.wikitext.r.core.source.WikitextRweaveDocumentConstants;
import org.eclipse.statet.yaml.core.source.YamlDocumentConstants;

@NonNullByDefault
public class WikidocRweaveDocumentContentInfo
extends BasicDocContentSections
implements DocContentSectionsRweaveExtension {
    public static final String WIKITEXT = "org.eclipse.statet.Wikidoc";
    public static final String YAML = "org.eclipse.statet.Yaml";
    public static final String LTX = "org.eclipse.statet.Ltx";
    public static final String R_CHUNK_CONTROL = "org.eclipse.statet.WikitextR-ChunkControl";
    public static final String R = "org.eclipse.statet.R";
    public static final DocContentSectionsRweaveExtension INSTANCE = new WikidocRweaveDocumentContentInfo();
    private final RweaveDocSectionTreePartImpl rweaveImpl = new RweaveDocSectionTreePartImpl((DocContentSections)this);

    public WikidocRweaveDocumentContentInfo() {
        super("org.eclipse.statet.WikidocRweave", WIKITEXT, ImCollections.newList((Object[])new String[]{WIKITEXT, YAML, LTX, R_CHUNK_CONTROL, R}));
    }

    public final String getTypeByPartition(String contentType) {
        if (IRDocumentConstants.R_ANY_CONTENT_CONSTRAINT.matches(contentType)) {
            return R;
        }
        if (WikitextRweaveDocumentConstants.RCHUNK_PARTITION_CONSTRAINT.matches(contentType)) {
            return R_CHUNK_CONTROL;
        }
        if (YamlDocumentConstants.YAML_ANY_CONTENT_CONSTRAINT.matches(contentType)) {
            return YAML;
        }
        if (TexDocumentConstants.LTX_ANY_CONTENT_CONSTRAINT.matches(contentType)) {
            return LTX;
        }
        return WIKITEXT;
    }

    public @Nullable TreePartitionNode getRChunkRegion(IDocument document, int offset) throws BadLocationException {
        return this.rweaveImpl.getRChunkRegion(document, offset);
    }

    public List<TreePartitionNode> getRChunkRegions(IDocument document, int offset, int length) throws BadLocationException {
        return this.rweaveImpl.getRChunkCodeRegions(document, offset, length);
    }

    public @Nullable IRegion getRChunkContentRegion(IDocument document, int offset) throws BadLocationException {
        return this.rweaveImpl.getRChunkContentRegion(document, offset);
    }

    public @Nullable TreePartitionNode getRCodeRegion(IDocument document, int offset) throws BadLocationException {
        return this.rweaveImpl.getRCodeRegion(document, offset);
    }

    public List<TreePartitionNode> getRChunkCodeRegions(IDocument document, int offset, int length) throws BadLocationException {
        return this.rweaveImpl.getRChunkCodeRegions(document, offset, length);
    }
}

