/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.eruntime;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.runtime.UriUtils;
import org.eclipse.statet.jcommons.runtime.bundle.BundleEntry;
import org.eclipse.statet.jcommons.runtime.bundle.BundleEntryProvider;
import org.eclipse.statet.jcommons.runtime.bundle.BundleResolver;
import org.eclipse.statet.jcommons.runtime.bundle.BundleSpec;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.MultiStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.rj.RjInvalidConfigurationException;
import org.eclipse.statet.rj.server.util.RJContext;
import org.osgi.framework.Bundle;

@NonNullByDefault
public class ERJContext
extends RJContext {
    public ERJContext() {
        super((Collection<BundleEntryProvider>)ImCollections.emptyList());
    }

    @Override
    protected @Nullable BundleResolver getBundleResolver(String id) throws RjInvalidConfigurationException {
        if (id.equals("default")) {
            return new EPlatformBundleResolver();
        }
        return super.getBundleResolver(id);
    }

    @Override
    public String getServerPolicyFilePath() throws RjInvalidConfigurationException {
        try {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.statet.rj.server");
            if (bundle == null) {
                throw new RjInvalidConfigurationException(String.format("RJ bundle '%1$s' is missing.", "org.eclipse.statet.rj.server"));
            }
            URL intern = bundle.getEntry("/localhost.policy");
            URL java = FileLocator.resolve((URL)intern);
            String path = java.toExternalForm();
            return path;
        }
        catch (IOException e) {
            throw new RjInvalidConfigurationException("Failed find server policy file.", e);
        }
    }

    private static class EPlatformBundleResolver
    implements BundleResolver {
        public boolean resolveBundle(BundleResolver.Data data, BundleSpec bundleSpec, MultiStatus status) {
            Bundle pluginBundle = Platform.getBundle((String)bundleSpec.getId());
            if (pluginBundle != null) {
                this.addPath(pluginBundle, data.getResolved(), status);
                Bundle[] fragments = Platform.getFragments((Bundle)pluginBundle);
                if (fragments != null) {
                    Bundle[] bundleArray = fragments;
                    int n = fragments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Bundle fragmentBundle = bundleArray[n2];
                        this.addPath(fragmentBundle, data.getResolved(), status);
                        ++n2;
                    }
                }
                return true;
            }
            return false;
        }

        private void addPath(Bundle bundle, Set<BundleEntry> resolved, MultiStatus status) {
            try {
                Path binPath;
                String libId = (String)ObjectUtils.nonNullAssert((Object)bundle.getSymbolicName());
                URI url = UriUtils.toUri((URL)FileLocator.resolve((URL)bundle.getEntry("/")));
                if (UriUtils.isJarUrl((URI)url) && UriUtils.getJarEntryPath((URI)url).isEmpty()) {
                    url = UriUtils.getJarFileUrl((URI)url);
                }
                Path path = Paths.get(url);
                if (Platform.inDevelopmentMode() && url.getPath().endsWith("/") && Files.isDirectory(binPath = path.resolve("target/classes"), new LinkOption[0])) {
                    resolved.add(new BundleEntry(libId, binPath));
                }
                resolved.add(new BundleEntry(libId, path));
                return;
            }
            catch (Exception e) {
                status.add((Status)new ErrorStatus("org.eclipse.statet.rj.server", String.format("Failed to check location for plug-in: '%1$s'.", bundle.getSymbolicName()), (Throwable)e));
                return;
            }
        }
    }
}

