/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ecommons.emf.ui.forms;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

public class UndoCommandHandler
extends AbstractHandler
implements IElementUpdater {
    private final EditingDomain domain;

    public UndoCommandHandler(EditingDomain domain) {
        this.domain = domain;
    }

    public void setEnabled(Object evaluationContext) {
        this.setBaseEnabled(this.domain.getCommandStack().canUndo());
    }

    public void updateElement(UIElement element, Map parameters) {
        Command command = this.domain.getCommandStack().getUndoCommand();
        if (command != null) {
            WorkbenchUIUtils.aboutToUpdateCommandsElements((IHandler2)this, (UIElement)element);
            try {
                String name = EMFEditUIPlugin.INSTANCE.getString("_UI_Undo_menu_item", true);
                element.setText(NLS.bind((String)name, (Object)this.getLabel(command)));
                element.setTooltip(NLS.bind((String)name, (Object)this.getTipLabel(command)));
            }
            finally {
                WorkbenchUIUtils.finalizeUpdateCommandsElements((IHandler2)this);
            }
        }
    }

    protected String getLabel(Command command) {
        String label = command.getLabel();
        if (label == null) {
            label = "";
        }
        return label;
    }

    protected String getTipLabel(Command command) {
        String label = command.getDescription();
        if (label == null) {
            label = this.getLabel(command);
        }
        return label;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.domain.getCommandStack().undo();
        return null;
    }
}

