/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.statet.ecommons.text.ui.BracketLevel;
import org.eclipse.statet.internal.r.ui.editors.RArgumentListContextInformation;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpInfoHoverCreator;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.SearchPattern;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.ui.ElementLabelProvider;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ElementNameCompletionProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.SourceProposal;
import org.eclipse.statet.nico.ui.console.InputSourceViewer;
import org.eclipse.statet.r.core.IRCoreAccess;
import org.eclipse.statet.r.core.RCodeStyleSettings;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.model.ArgsDefinition;
import org.eclipse.statet.r.core.model.IRElement;
import org.eclipse.statet.r.core.model.IRMethod;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.statet.r.ui.RUI;
import org.eclipse.statet.r.ui.sourceediting.RAssistInvocationContext;
import org.eclipse.statet.r.ui.sourceediting.RBracketLevel;
import org.eclipse.statet.rhelp.core.REnvHelp;
import org.eclipse.statet.rhelp.core.RHelpManager;
import org.eclipse.statet.rhelp.core.RPkgHelp;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

@NonNullByDefault
public class RElementCompletionProposal
extends ElementNameCompletionProposal<RAssistInvocationContext, IRElement>
implements ICompletionProposalExtension5 {
    protected static final int PACKAGE_NAME = 1;
    protected static final int ARGUMENT_NAME = 2;
    protected static final int FUNCTION = 3;
    private static boolean rHelpInfoHoverInitialized;
    private static @Nullable IInformationControlCreator rHelpInfoHoverCreator;

    private static @Nullable IInformationControlCreator getRHelpInfoHoverCreator(AssistInvocationContext context) {
        Shell shell;
        if (!rHelpInfoHoverInitialized && (shell = context.getSourceViewer().getTextWidget().getShell()) != null) {
            if (RHelpInfoHoverCreator.isAvailable((Composite)shell)) {
                rHelpInfoHoverCreator = new RHelpInfoHoverCreator(2);
            }
            rHelpInfoHoverInitialized = true;
        }
        return rHelpInfoHoverCreator;
    }

    private static final boolean isFollowedByOpeningBracket(int forwardOffset, RAssistInvocationContext context) {
        RHeuristicTokenScanner scanner = context.getRHeuristicTokenScanner();
        scanner.configure(context.getDocument());
        int idx = scanner.findAnyNonBlankForward(forwardOffset, -2, false);
        return idx >= 0 && scanner.getChar() == '(';
    }

    private static final boolean isClosedBracket(int backwardOffset, int forwardOffset, RAssistInvocationContext context) {
        boolean searchType = true;
        int[] balance = new int[3];
        balance[1] = balance[1] + 1;
        RHeuristicTokenScanner scanner = context.getRHeuristicTokenScanner();
        scanner.configureDefaultPartitions(context.getDocument());
        balance = scanner.computeBracketBalance(backwardOffset, forwardOffset, balance, 1);
        return balance[1] <= 0;
    }

    private static final boolean isFollowedByEqualAssign(int forwardOffset, RAssistInvocationContext context) {
        RHeuristicTokenScanner scanner = context.getRHeuristicTokenScanner();
        scanner.configure(context.getDocument());
        int idx = scanner.findAnyNonBlankForward(forwardOffset, -2, false);
        return idx >= 0 && scanner.getChar() == '=';
    }

    private static final boolean isFollowedByAssign(int forwardOffset, RAssistInvocationContext data) {
        RHeuristicTokenScanner scanner = data.getRHeuristicTokenScanner();
        scanner.configure(data.getDocument());
        int idx = scanner.findAnyNonBlankForward(forwardOffset, -2, false);
        return idx >= 0 && (scanner.getChar() == '=' || scanner.getChar() == '<');
    }

    public RElementCompletionProposal(RElementProposalParameters parameters) {
        super((SourceProposal.ProposalParameters)parameters, parameters.replacementName, (IModelElement)parameters.element, parameters.labelProvider);
    }

    protected IRCoreAccess getRCoreAccess() {
        return ((RAssistInvocationContext)this.getInvocationContext()).getEditor().getRCoreAccess();
    }

    protected int getMode() {
        return this.getElement() != null && (((IRElement)this.getElement()).getElementType() & 0xF00) == 1280 ? 3 : 0;
    }

    protected int computeReplacementLength(int replacementOffset, Point selection, int caretOffset, boolean overwrite) {
        int end = Math.max(caretOffset, selection.x + selection.y);
        if (overwrite) {
            RAssistInvocationContext context = (RAssistInvocationContext)this.getInvocationContext();
            RHeuristicTokenScanner scanner = context.getRHeuristicTokenScanner();
            scanner.configure(context.getDocument());
            IRegion word = scanner.findRWord(end, false, true);
            if (word != null) {
                return word.getOffset() + word.getLength() - replacementOffset;
            }
        }
        return end - replacementOffset;
    }

    protected @Nullable String getValidationPrefix(int offset) throws BadLocationException {
        int startOffset = Math.max(this.getReplacementOffset(), 0);
        if (offset >= startOffset) {
            RAssistInvocationContext context = (RAssistInvocationContext)this.getInvocationContext();
            IDocument document = context.getDocument();
            int nameEndOffset = offset;
            int nameStartOffset = startOffset;
            if (nameEndOffset > nameStartOffset && document.getChar(nameStartOffset) == '`') {
                ++nameStartOffset;
            }
            if (nameEndOffset > nameStartOffset && document.getChar(nameEndOffset - 1) == '`') {
                --nameEndOffset;
            }
            if (nameEndOffset >= nameStartOffset) {
                return context.getIdentifierSegmentName(document.get(startOffset, offset - startOffset));
            }
        }
        return null;
    }

    protected void doApply(char trigger, int stateMask, int caretOffset, int replacementOffset, int replacementLength) throws BadLocationException {
        RAssistInvocationContext context = (RAssistInvocationContext)this.getInvocationContext();
        IDocument document = context.getDocument();
        SourceProposal.ApplyData applyData = this.getApplyData();
        ElementName replacementName = this.getReplacementName();
        int mode = this.getMode();
        boolean assignmentFunction = mode == 3 && replacementName.getNextSegment() == null && replacementName.getSegmentName().endsWith("<-");
        Object elementName = assignmentFunction ? RElementName.create((int)17, (String)replacementName.getSegmentName().substring(0, replacementName.getSegmentName().length() - 2)) : replacementName;
        StringBuilder replacement = new StringBuilder(mode == 1 ? elementName.getSegmentName() : elementName.getDisplayName());
        int cursor = replacement.length();
        if (replacementLength > 0 && document.getChar(replacementOffset) == '`' && replacement.charAt(0) != '`') {
            if (replacement.length() == elementName.getSegmentName().length() && replacementOffset + replacementLength < document.getLength() && document.getChar(replacementOffset + replacementLength) == '`') {
                ++replacementLength;
            }
            replacement.insert(elementName.getSegmentName().length(), '`');
            replacement.insert(0, '`');
            cursor += 2;
        }
        int subMode = 0;
        int linkedMode = -1;
        switch (mode) {
            case 3: {
                ArgsDefinition argsDef;
                subMode = 1;
                IRMethod rMethod = (IRMethod)this.getElement();
                if (replacementOffset + replacementLength < document.getLength() - 1 && document.getChar(replacementOffset + replacementLength) == '(') {
                    ++cursor;
                    subMode = 10;
                } else if (!RElementCompletionProposal.isFollowedByOpeningBracket(replacementOffset + replacementLength, context)) {
                    replacement.append('(');
                    ++cursor;
                    subMode = 11;
                }
                if (subMode < 10) break;
                if (subMode == 11 && !RElementCompletionProposal.isClosedBracket(replacementOffset, replacementOffset + replacementLength, context)) {
                    replacement.append(')');
                    linkedMode = 2;
                    if (assignmentFunction && !RElementCompletionProposal.isFollowedByAssign(replacementOffset + replacementLength, context)) {
                        replacement.append(" <- ");
                        if (linkedMode >= 0) {
                            linkedMode += 4;
                        }
                    }
                }
                if ((argsDef = rMethod.getArgsDefinition()) == null || argsDef.size() > 0 || subMode == 11 && linkedMode < 0) {
                    applyData.setContextInformation((IContextInformation)new RArgumentListContextInformation(replacementOffset + cursor, rMethod));
                    break;
                }
                ++cursor;
                linkedMode = -1;
                break;
            }
            case 2: {
                if (RElementCompletionProposal.isFollowedByEqualAssign(replacementOffset + replacementLength, context)) break;
                RCodeStyleSettings codeStyle = this.getRCoreAccess().getRCodeStyle();
                String argAssign = codeStyle.getArgAssignString();
                replacement.append(argAssign);
                cursor += argAssign.length();
            }
        }
        document.replace(replacementOffset, replacementLength, replacement.toString());
        applyData.setSelection(replacementOffset + cursor);
        if (linkedMode >= 0) {
            this.createLinkedMode(replacementOffset + cursor - 1, linkedMode).enter();
        }
    }

    private LinkedModeUI createLinkedMode(int offset, int mode) throws BadLocationException {
        AssistInvocationContext context = this.getInvocationContext();
        IDocument document = context.getDocument();
        LinkedModeModel model = new LinkedModeModel();
        int pos = 0;
        LinkedPositionGroup group = new LinkedPositionGroup();
        BracketLevel.InBracketPosition position = RBracketLevel.createPosition('(', document, offset + 1, 0, pos++);
        group.addPosition((LinkedPosition)position);
        model.addGroup(group);
        model.forceInstall();
        RBracketLevel level = new RBracketLevel(model, document, context.getEditor().getDocumentContentInfo(), position, context.getSourceViewer() instanceof InputSourceViewer, true);
        LinkedModeUI ui = new LinkedModeUI(model, (ITextViewer)context.getSourceViewer());
        ui.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
        ui.setExitPosition((ITextViewer)context.getSourceViewer(), offset + (mode & 0xFF), 0, pos);
        ui.setSimpleMode(true);
        ui.setExitPolicy((LinkedModeUI.IExitPolicy)level);
        return ui;
    }

    public IInformationControlCreator getInformationControlCreator() {
        return RElementCompletionProposal.getRHelpInfoHoverCreator(this.getInvocationContext());
    }

    public @Nullable Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        RHelpManager rHelpManager = RCore.getRHelpManager();
        int mode = this.getMode();
        RPkgHelp helpObject = null;
        switch (mode) {
            case 1: {
                ElementName elementName = this.getReplacementName();
                if (elementName.getType() != 38) break;
                String pkgName = elementName.getSegmentName();
                if (pkgName == null) {
                    return null;
                }
                REnvHelp help = rHelpManager.getHelp(this.getRCoreAccess().getREnv());
                if (help == null) break;
                try {
                    helpObject = help.getPkgHelp(pkgName);
                    break;
                }
                finally {
                    help.unlock();
                }
            }
            default: {
                IRElement element = (IRElement)this.getElement();
                if (element == null) {
                    return null;
                }
                RElementName elementName = element.getElementName();
                if (elementName.getType() != 17) break;
                RElementName scope = elementName.getScope();
                if (scope == null && element.getModelParent() instanceof IRElement) {
                    scope = element.getModelParent().getElementName();
                }
                if (scope == null || !RElementName.isPackageFacetScopeType((int)scope.getType())) {
                    return null;
                }
                String pkgName = scope.getSegmentName();
                String topic = elementName.getSegmentName();
                if (pkgName == null || topic == null) {
                    return null;
                }
                REnvHelp help = rHelpManager.getHelp(this.getRCoreAccess().getREnv());
                if (help == null) break;
                try {
                    RPkgHelp pkgHelp = help.getPkgHelp(pkgName);
                    if (pkgHelp != null) {
                        helpObject = pkgHelp.getPageForTopic(topic);
                    }
                }
                finally {
                    help.unlock();
                }
                {
                }
            }
        }
        if (Thread.interrupted() || helpObject == null) {
            return null;
        }
        URI url = RCore.getRHelpHttpService().toHttpUrl(helpObject, "info");
        if (url != null) {
            return new RHelpInfoHoverCreator.Data((Control)((RAssistInvocationContext)this.getInvocationContext()).getSourceViewer().getTextWidget(), helpObject, url);
        }
        return null;
    }

    public static class ArgumentProposal
    extends RElementCompletionProposal {
        public ArgumentProposal(RElementProposalParameters parameters) {
            super(parameters);
        }

        @Override
        protected int getMode() {
            return 2;
        }

        public String getDisplayString() {
            return this.getReplacementName().getDisplayName();
        }

        public StyledString computeStyledText() {
            return new StyledString(this.getReplacementName().getDisplayName());
        }

        public Image getImage() {
            return RUI.getImage("org.eclipse.statet.r.ui/image/obj/argument.assign");
        }
    }

    public static class ContextInformationProposal
    extends RElementCompletionProposal {
        public ContextInformationProposal(RElementProposalParameters parameters) {
            super(parameters);
        }

        public boolean isAutoInsertable() {
            return true;
        }

        @Override
        protected void doApply(char trigger, int stateMask, int caretOffset, int replacementOffset, int replacementLength) throws BadLocationException {
            SourceProposal.ApplyData applyData = this.getApplyData();
            applyData.clearSelection();
            applyData.setContextInformation((IContextInformation)new RArgumentListContextInformation(this.getReplacementOffset(), (IRMethod)this.getElement()));
        }
    }

    public static class RElementProposalParameters
    extends SourceProposal.ProposalParameters<RAssistInvocationContext> {
        public final ElementLabelProvider labelProvider;
        public ElementName replacementName;
        public IRElement element;

        public RElementProposalParameters(RAssistInvocationContext context, int replacementOffset, SearchPattern namePattern, int baseRelevance, ElementLabelProvider labelProvider) {
            super((AssistInvocationContext)context, replacementOffset, namePattern, baseRelevance);
            this.labelProvider = labelProvider;
        }

        public RElementProposalParameters(RAssistInvocationContext context, int replacementOffset, SearchPattern namePattern, ElementLabelProvider labelProvider) {
            super((AssistInvocationContext)context, replacementOffset, namePattern);
            this.labelProvider = labelProvider;
        }

        public RElementProposalParameters(RAssistInvocationContext context, int replacementOffset, ElementLabelProvider labelProvider) {
            super((AssistInvocationContext)context, replacementOffset, 0);
            this.labelProvider = labelProvider;
        }
    }
}

