/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpHover;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.EditorInformationProvider;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.r.core.source.IRDocumentConstants;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.statet.r.ui.editors.IRSourceEditor;
import org.eclipse.statet.r.ui.sourceediting.RAssistInvocationContext;

@NonNullByDefault
public class REditorInformationProvider
extends EditorInformationProvider {
    private @Nullable RHeuristicTokenScanner scanner;

    public REditorInformationProvider(IRSourceEditor editor) {
        super((ISourceEditor)editor, ImCollections.newList((Object)new RHelpHover(17)));
    }

    public IRegion getSubject(ITextViewer textViewer, int offset) {
        RHeuristicTokenScanner scanner = this.scanner;
        if (scanner == null) {
            this.scanner = scanner = RHeuristicTokenScanner.create((DocContentSections)this.getEditor().getDocumentContentInfo());
        }
        try {
            ITypedRegion partition;
            IDocument document = this.getEditor().getViewer().getDocument();
            scanner.configure(document);
            IRegion word = scanner.findRWord(offset, false, true);
            if (word != null && (IRDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches((partition = scanner.getPartition(word.getOffset())).getType()) || partition.getType() == "R.String" || partition.getType() == "R.QuotedSymbol")) {
                return word;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Region(offset, 0);
    }

    protected @Nullable AssistInvocationContext createContext(IRegion region, String contentType, IProgressMonitor monitor) {
        RAssistInvocationContext context = new RAssistInvocationContext((IRSourceEditor)this.getEditor(), region, contentType, this.scanner, monitor);
        if (context.getAstInfo() == null) {
            return null;
        }
        return context;
    }
}

