/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.statet.ecommons.preferences.PreferencesUtil;
import org.eclipse.statet.ecommons.preferences.SettingsChangeNotifier;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.ecommons.text.PartitionerDocumentSetupParticipant;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.ltk.core.LTK;
import org.eclipse.statet.ltk.issues.core.Problem;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.SourceAnnotationModel;
import org.eclipse.statet.ltk.ui.sourceediting.SourceDocumentProvider;
import org.eclipse.statet.ltk.ui.sourceediting.SourceProblemAnnotation;
import org.eclipse.statet.r.core.model.IRSourceUnit;
import org.eclipse.statet.r.core.model.RModel;
import org.eclipse.statet.r.core.source.RDocumentSetupParticipant;
import org.eclipse.statet.r.ui.editors.REditorBuild;

public class RDocumentProvider
extends SourceDocumentProvider<IRSourceUnit>
implements Disposable {
    private SettingsChangeNotifier.ChangeListener fEditorPrefListener = new SettingsChangeNotifier.ChangeListener(){

        public void settingsChanged(Set<String> groupIds) {
            if (groupIds.contains("r/r.editor/build.options")) {
                RDocumentProvider.this.updateEditorPrefs();
            }
        }
    };
    private boolean fHandleTemporaryProblems;

    public RDocumentProvider() {
        super("R", (PartitionerDocumentSetupParticipant)new RDocumentSetupParticipant());
        PreferencesUtil.getSettingsChangeNotifier().addChangeListener(this.fEditorPrefListener);
        PreferenceAccess access = PreferenceUtils.getInstancePrefs();
        this.fHandleTemporaryProblems = (Boolean)access.getPreferenceValue((Preference)REditorBuild.PROBLEMCHECKING_ENABLED_PREF);
    }

    public void dispose() {
        if (this.fEditorPrefListener != null) {
            PreferencesUtil.getSettingsChangeNotifier().removeChangeListener(this.fEditorPrefListener);
            this.fEditorPrefListener = null;
        }
    }

    private void updateEditorPrefs() {
        PreferenceAccess access = PreferenceUtils.getInstancePrefs();
        boolean newHandleTemporaryProblems = (Boolean)access.getPreferenceValue((Preference)REditorBuild.PROBLEMCHECKING_ENABLED_PREF);
        if (this.fHandleTemporaryProblems != newHandleTemporaryProblems) {
            this.fHandleTemporaryProblems = newHandleTemporaryProblems;
            if (this.fHandleTemporaryProblems) {
                RModel.getRModelManager().refresh(LTK.EDITOR_CONTEXT);
            } else {
                List sus = LTK.getSourceUnitManager().getOpenSourceUnits("R", LTK.EDITOR_CONTEXT);
                for (ISourceUnit su : sus) {
                    IAnnotationModel model = this.getAnnotationModel(su);
                    if (!(model instanceof ThisAnnotationModel)) continue;
                    ((ThisAnnotationModel)model).clearProblems(null);
                }
            }
        }
    }

    protected IAnnotationModel createAnnotationModel(IFile file) {
        return new ThisAnnotationModel((IResource)file);
    }

    private class ThisAnnotationModel
    extends SourceAnnotationModel {
        public ThisAnnotationModel(IResource resource) {
            super(resource);
        }

        protected boolean isHandlingTemporaryProblems() {
            return RDocumentProvider.this.fHandleTemporaryProblems;
        }

        protected SourceProblemAnnotation createAnnotation(Problem problem) {
            if (problem.getCategoryId() == "R") {
                switch (problem.getSeverity()) {
                    case 2: {
                        return new SourceProblemAnnotation("org.eclipse.statet.r.ui.error", problem, SourceProblemAnnotation.ERROR_CONFIG);
                    }
                    case 1: {
                        return new SourceProblemAnnotation("org.eclipse.statet.r.ui.warning", problem, SourceProblemAnnotation.WARNING_CONFIG);
                    }
                }
                return new SourceProblemAnnotation("org.eclipse.statet.r.ui.info", problem, SourceProblemAnnotation.INFO_CONFIG);
            }
            return null;
        }
    }
}

