/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.eval;

import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.r.debug.core.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.input.StringParserInput;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.ltk.issues.core.Problem;
import org.eclipse.statet.ltk.issues.core.ProblemRequestor;
import org.eclipse.statet.r.core.model.RProblemReporter;
import org.eclipse.statet.r.core.rsource.ast.RAst;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RScanner;

@NonNullByDefault
public class ExpressionValidator
implements ProblemRequestor {
    private final RScanner rParser = new RScanner(4);
    private final RProblemReporter rProblemReporter = new RProblemReporter();
    private @Nullable String errorMessage;

    public @Nullable String checkExpression(String expression) {
        try {
            RAstNode node = this.rParser.scanExpr((TextParserInput)new StringParserInput(expression).init());
            if (node == null) {
                this.errorMessage = Messages.Expression_Validate_Detail_SingleExpression_message;
            } else if (RAst.hasErrors((RAstNode)node)) {
                SourceContent content = new SourceContent(0L, expression);
                try {
                    this.rProblemReporter.run(null, content, node, (ProblemRequestor)this);
                }
                catch (StopReporterException stopReporterException) {
                    // empty catch block
                }
                if (this.errorMessage == null) {
                    this.errorMessage = Messages.Expression_Validate_Detail_DetailMissing_message;
                }
            }
            if (this.errorMessage != null) {
                String string = NLS.bind((String)Messages.Expression_Validate_Invalid_message, (Object)this.errorMessage);
                return string;
            }
            return null;
        }
        finally {
            this.errorMessage = null;
        }
    }

    public void acceptProblems(Problem problem) {
        this.errorMessage = problem.getMessage();
        throw new StopReporterException();
    }

    public void acceptProblems(String categoryId, List<Problem> problems) {
        for (Problem problem : problems) {
            this.acceptProblems(problem);
        }
    }

    public void finish() {
    }

    private static class StopReporterException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }
}

