/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.rsource.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.r.core.rlang.RTerminal;
import org.eclipse.statet.r.core.rsource.ast.Expression;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RAstVisitor;

@NonNullByDefault
public final class CIfElse
extends RAstNode {
    boolean withElse = false;
    int condOpenOffset = Integer.MIN_VALUE;
    final Expression condExpr = new Expression();
    int condCloseOffset = Integer.MIN_VALUE;
    final Expression thenExpr = new Expression();
    int elseOffset = Integer.MIN_VALUE;
    final Expression elseExpr = new Expression();

    CIfElse() {
    }

    @Override
    public final NodeType getNodeType() {
        return NodeType.C_IF;
    }

    @Override
    public final @Nullable RTerminal getOperator(int index) {
        return null;
    }

    public final boolean hasElse() {
        return this.withElse;
    }

    @Override
    public final boolean hasChildren() {
        return true;
    }

    @Override
    public final int getChildCount() {
        return this.withElse ? 3 : 2;
    }

    @Override
    public final RAstNode getChild(int index) {
        switch (index) {
            case 0: {
                return this.condExpr.node;
            }
            case 1: {
                return this.thenExpr.node;
            }
            case 2: {
                if (!this.withElse) break;
                return this.elseExpr.node;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final RAstNode[] getChildren() {
        if (this.withElse) {
            return new RAstNode[]{this.condExpr.node, this.thenExpr.node, this.elseExpr.node};
        }
        return new RAstNode[]{this.condExpr.node, this.thenExpr.node};
    }

    @Override
    public final int getChildIndex(AstNode child) {
        if (this.condExpr.node == child) {
            return 0;
        }
        if (this.thenExpr.node == child) {
            return 1;
        }
        if (this.elseExpr.node == child) {
            return 2;
        }
        return -1;
    }

    public final int getCondOpenOffset() {
        return this.condOpenOffset;
    }

    public final RAstNode getCondChild() {
        return this.condExpr.node;
    }

    public final int getCondCloseOffset() {
        return this.condCloseOffset;
    }

    public final RAstNode getThenChild() {
        return this.thenExpr.node;
    }

    public final int getElseOffset() {
        return this.elseOffset;
    }

    public final RAstNode getElseChild() {
        return this.elseExpr.node;
    }

    @Override
    public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public final void acceptInRChildren(RAstVisitor visitor) throws InvocationTargetException {
        this.condExpr.node.acceptInR(visitor);
        this.thenExpr.node.acceptInR(visitor);
        if (this.withElse) {
            this.elseExpr.node.acceptInR(visitor);
        }
    }

    public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        visitor.visit((AstNode)this.condExpr.node);
        visitor.visit((AstNode)this.thenExpr.node);
        if (this.withElse) {
            visitor.visit((AstNode)this.elseExpr.node);
        }
    }

    @Override
    final @Nullable Expression getExpr(RAstNode child) {
        if (this.thenExpr.node == child) {
            return this.thenExpr;
        }
        if (this.elseExpr.node == child) {
            return this.elseExpr;
        }
        if (this.condExpr.node == child) {
            return this.condExpr;
        }
        return null;
    }

    @Override
    final Expression getLeftExpr() {
        return this.thenExpr;
    }

    @Override
    final Expression getRightExpr() {
        if (this.withElse) {
            return this.elseExpr;
        }
        return this.thenExpr;
    }

    @Override
    public final boolean equalsSingle(RAstNode element) {
        return NodeType.C_IF == element.getNodeType();
    }

    @Override
    final int getMissingExprStatus(Expression expr) {
        if (this.condExpr == expr) {
            return 70465;
        }
        if (this.thenExpr == expr) {
            return 70497;
        }
        if (this.withElse && this.elseExpr == expr) {
            return 70498;
        }
        throw new IllegalArgumentException();
    }

    @Override
    final void updateEndOffset() {
        this.endOffset = this.withElse && this.elseExpr.node != null ? this.elseExpr.node.endOffset : (this.withElse && this.elseOffset != Integer.MIN_VALUE ? this.elseOffset + 4 : (this.thenExpr.node != null ? this.thenExpr.node.endOffset : (this.condCloseOffset != Integer.MIN_VALUE ? this.condCloseOffset + 1 : (this.condExpr.node != null ? this.condExpr.node.endOffset : (this.condOpenOffset != Integer.MIN_VALUE ? this.condOpenOffset + 1 : this.startOffset + 2)))));
    }
}

