/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core;

import java.util.List;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.r.core.model.IRElement;
import org.eclipse.statet.r.core.model.IRFrame;
import org.eclipse.statet.r.core.model.IRLangElement;
import org.eclipse.statet.r.core.model.RElementName;

public class FilteredFrame
implements IRFrame,
IModelElement.Filter {
    private final IRFrame frame;
    private final ISourceUnit exclude;

    public FilteredFrame(IRFrame frame, ISourceUnit exclude) {
        this.frame = frame;
        this.exclude = exclude;
    }

    @Override
    public String getFrameId() {
        return this.frame.getFrameId();
    }

    @Override
    public int getFrameType() {
        return this.frame.getFrameType();
    }

    @Override
    public RElementName getElementName() {
        return this.frame.getElementName();
    }

    @Override
    public boolean hasModelChildren(IModelElement.Filter filter) {
        return this.frame.hasModelChildren(this.exclude != null ? this : null);
    }

    @Override
    public List<? extends IRLangElement> getModelChildren(IModelElement.Filter filter) {
        return this.frame.getModelChildren(this.exclude != null ? this : null);
    }

    @Override
    public List<? extends IRElement> getModelElements() {
        return this.frame.getModelElements();
    }

    @Override
    public List<? extends IRFrame> getPotentialParents() {
        return this.frame.getPotentialParents();
    }

    public boolean include(IModelElement element) {
        ISourceUnit su;
        ISourceUnit iSourceUnit = su = element instanceof ISourceElement ? ((ISourceElement)element).getSourceUnit() : null;
        return su == null || !this.exclude.getId().equals(su.getId());
    }

    public String toString() {
        ObjectUtils.ToStringBuilder builder = new ObjectUtils.ToStringBuilder("FilteredFrame", this.getClass());
        builder.addProp("frame", (Object)this.frame);
        builder.addProp("exclude", (Object)this.exclude);
        return builder.build();
    }
}

